/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty.http2;

import io.ktor.http.URLUtilsKt;
import io.ktor.http.Url;
import io.ktor.server.application.Application;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.netty.NettyApplicationCallHandler;
import io.ktor.server.netty.NettyHttpHandlerState;
import io.ktor.server.netty.cio.NettyHttpResponsePipeline;
import io.ktor.server.netty.http2.NettyHttp2ApplicationCall;
import io.ktor.server.netty.http2.NettyHttp2ApplicationRequest;
import io.ktor.server.netty.http2.NettyHttp2Handler;
import io.ktor.server.response.ResponsePushBuilder;
import io.ktor.server.response.UseHttp2Push;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2MultiplexCodec;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.channels.ClosedChannelException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CopyableThrowable;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ChannelHandler.Sharable
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 ?2\u00020\u00012\u00020\u0002:\u0002?@B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020,H\u0016J\u0018\u0010-\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010.\u001a\u00020/H\u0002J\u001d\u00100\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u00101\u001a\u000202H\u0001\u00a2\u0006\u0002\b3J\u0011\u00104\u001a\u00020\u0018*\u0006\u0012\u0002\b\u000305H\u0082\u0010J\u0014\u00106\u001a\u00020\"*\u0002072\u0006\u00108\u001a\u00020\fH\u0002J\u001c\u00109\u001a\u00020:*\u00020\u001e2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0017\u001a\u0004\u0018\u00010\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001d\u001a\u00020\u0018*\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006A"}, d2={"Lio/ktor/server/netty/http2/NettyHttp2Handler;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "Lkotlinx/coroutines/CoroutineScope;", "enginePipeline", "Lio/ktor/server/engine/EnginePipeline;", "application", "Lio/ktor/server/application/Application;", "callEventGroup", "Lio/netty/util/concurrent/EventExecutorGroup;", "userCoroutineContext", "Lkotlin/coroutines/CoroutineContext;", "runningLimit", "", "(Lio/ktor/server/engine/EnginePipeline;Lio/ktor/server/application/Application;Lio/netty/util/concurrent/EventExecutorGroup;Lkotlin/coroutines/CoroutineContext;I)V", "coroutineContext", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "handlerJob", "Lkotlinx/coroutines/CompletableJob;", "responseWriter", "Lio/ktor/server/netty/cio/NettyHttpResponsePipeline;", "state", "Lio/ktor/server/netty/NettyHttpHandlerState;", "streamKeyField", "Ljava/lang/reflect/Field;", "getStreamKeyField", "()Ljava/lang/reflect/Field;", "streamKeyField$delegate", "Lkotlin/Lazy;", "idField", "Lio/netty/handler/codec/http2/Http2FrameStream;", "getIdField", "(Lio/netty/handler/codec/http2/Http2FrameStream;)Ljava/lang/reflect/Field;", "channelActive", "", "context", "Lio/netty/channel/ChannelHandlerContext;", "channelRead", "message", "", "channelReadComplete", "exceptionCaught", "ctx", "cause", "", "startHttp2", "headers", "Lio/netty/handler/codec/http2/Http2Headers;", "startHttp2PushPromise", "builder", "Lio/ktor/server/response/ResponsePushBuilder;", "startHttp2PushPromise$ktor_server_netty", "findIdField", "Ljava/lang/Class;", "setId", "Lio/netty/handler/codec/http2/Http2StreamChannel;", "streamId", "setStreamAndProperty", "", "codec", "Lio/netty/handler/codec/http2/Http2FrameCodec;", "childStream", "Lio/netty/handler/codec/http2/Http2Stream;", "Companion", "Http2ClosedChannelException", "ktor-server-netty"})
public final class NettyHttp2Handler
extends ChannelInboundHandlerAdapter
implements CoroutineScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EnginePipeline enginePipeline;
    @NotNull
    private final Application application;
    @NotNull
    private final EventExecutorGroup callEventGroup;
    @NotNull
    private final CoroutineContext userCoroutineContext;
    @NotNull
    private final CompletableJob handlerJob;
    @NotNull
    private final NettyHttpHandlerState state;
    private NettyHttpResponsePipeline responseWriter;
    @NotNull
    private final Lazy streamKeyField$delegate;
    private static final AttributeKey<NettyHttp2ApplicationCall> ApplicationCallKey = AttributeKey.newInstance("ktor.ApplicationCall");

    public NettyHttp2Handler(@NotNull EnginePipeline enginePipeline, @NotNull Application application, @NotNull EventExecutorGroup callEventGroup2, @NotNull CoroutineContext userCoroutineContext, int runningLimit) {
        Intrinsics.checkNotNullParameter(enginePipeline, "enginePipeline");
        Intrinsics.checkNotNullParameter(application, "application");
        Intrinsics.checkNotNullParameter(callEventGroup2, "callEventGroup");
        Intrinsics.checkNotNullParameter(userCoroutineContext, "userCoroutineContext");
        this.enginePipeline = enginePipeline;
        this.application = application;
        this.callEventGroup = callEventGroup2;
        this.userCoroutineContext = userCoroutineContext;
        this.handlerJob = SupervisorKt.SupervisorJob((Job)this.userCoroutineContext.get(Job.Key));
        this.state = new NettyHttpHandlerState(runningLimit);
        this.streamKeyField$delegate = LazyKt.lazy(streamKeyField.2.INSTANCE);
    }

    @Override
    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.handlerJob;
    }

    @Override
    public void channelRead(@NotNull ChannelHandlerContext context, @NotNull Object message2) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(message2, "message");
        Object object = message2;
        if (object instanceof Http2HeadersFrame) {
            NettyHttpHandlerState.isChannelReadCompleted$FU$internal.compareAndSet(this.state, 1, 0);
            NettyHttpHandlerState.activeRequests$FU$internal.incrementAndGet(this.state);
            Http2Headers http2Headers = ((Http2HeadersFrame)message2).headers();
            Intrinsics.checkNotNullExpressionValue(http2Headers, "message.headers()");
            this.startHttp2(context, http2Headers);
        } else if (object instanceof Http2DataFrame) {
            Object object2 = NettyHttp2Handler.Companion.getApplicationCall(context);
            if (object2 != null && (object2 = ((NettyHttp2ApplicationCall)object2).getRequest()) != null) {
                Object object3;
                Object $this$channelRead_u24lambda_u2d0 = object3 = object2;
                boolean bl = false;
                boolean eof = ((Http2DataFrame)message2).isEndStream();
                ChannelResult.isSuccess-impl(((NettyHttp2ApplicationRequest)$this$channelRead_u24lambda_u2d0).getContentActor().trySend-JP2dKIU((Http2DataFrame)message2));
                if (eof) {
                    SendChannel.DefaultImpls.close$default(((NettyHttp2ApplicationRequest)$this$channelRead_u24lambda_u2d0).getContentActor(), null, 1, null);
                    NettyHttpHandlerState.isCurrentRequestFullyRead$FU$internal.compareAndSet(this.state, 0, 1);
                } else {
                    NettyHttpHandlerState.isCurrentRequestFullyRead$FU$internal.compareAndSet(this.state, 1, 0);
                }
            } else {
                ((Http2DataFrame)message2).release();
            }
        } else if (object instanceof Http2ResetFrame) {
            Object object4 = NettyHttp2Handler.Companion.getApplicationCall(context);
            if (object4 != null && (object4 = ((NettyHttp2ApplicationCall)object4).getRequest()) != null) {
                Object r2 = object4;
                boolean bl = false;
                Http2ClosedChannelException e = ((Http2ResetFrame)message2).errorCode() == 0L ? null : new Http2ClosedChannelException(((Http2ResetFrame)message2).errorCode());
                ((NettyHttp2ApplicationRequest)r2).getContentActor().close(e);
            }
        } else {
            context.fireChannelRead(message2);
        }
    }

    @Override
    public void channelActive(@NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.responseWriter = new NettyHttpResponsePipeline(context, this.state, this.getCoroutineContext());
        ChannelPipeline channelPipeline = context.pipeline();
        if (channelPipeline != null) {
            ChannelPipeline channelPipeline2;
            ChannelPipeline $this$channelActive_u24lambda_u2d2 = channelPipeline2 = channelPipeline;
            boolean bl = false;
            ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new NettyApplicationCallHandler(this.userCoroutineContext, this.enginePipeline)};
            $this$channelActive_u24lambda_u2d2.addLast(this.callEventGroup, channelHandlerArray);
        }
        context.fireChannelActive();
    }

    @Override
    public void channelReadComplete(@NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        NettyHttpHandlerState.isChannelReadCompleted$FU$internal.compareAndSet(this.state, 0, 1);
        NettyHttpResponsePipeline nettyHttpResponsePipeline = this.responseWriter;
        if (nettyHttpResponsePipeline == null) {
            Intrinsics.throwUninitializedPropertyAccessException("responseWriter");
            nettyHttpResponsePipeline = null;
        }
        nettyHttpResponsePipeline.flushIfNeeded$ktor_server_netty();
        context.fireChannelReadComplete();
    }

    @Override
    public void exceptionCaught(@NotNull ChannelHandlerContext ctx2, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter(ctx2, "ctx");
        Intrinsics.checkNotNullParameter(cause, "cause");
        ctx2.close();
    }

    private final void startHttp2(ChannelHandlerContext context, Http2Headers headers2) {
        NettyHttp2ApplicationCall call = new NettyHttp2ApplicationCall(this.application, context, headers2, this, this.handlerJob.plus(Dispatchers.getUnconfined()), this.userCoroutineContext);
        NettyHttp2Handler.Companion.setApplicationCall(context, call);
        context.fireChannelRead(call);
        NettyHttpResponsePipeline nettyHttpResponsePipeline = this.responseWriter;
        if (nettyHttpResponsePipeline == null) {
            Intrinsics.throwUninitializedPropertyAccessException("responseWriter");
            nettyHttpResponsePipeline = null;
        }
        nettyHttpResponsePipeline.processResponse$ktor_server_netty(call);
    }

    @UseHttp2Push
    public final void startHttp2PushPromise$ktor_server_netty(@NotNull ChannelHandlerContext context, @NotNull ResponsePushBuilder builder) {
        DefaultHttp2Headers defaultHttp2Headers;
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(builder, "builder");
        Channel channel2 = context.channel();
        if (channel2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type io.netty.handler.codec.http2.Http2StreamChannel");
        }
        Http2StreamChannel channel3 = (Http2StreamChannel)channel2;
        int streamId = channel3.stream().id();
        Http2MultiplexCodec http2MultiplexCodec = channel3.parent().pipeline().get(Http2MultiplexCodec.class);
        Intrinsics.checkNotNull(http2MultiplexCodec);
        Http2MultiplexCodec codec = http2MultiplexCodec;
        Http2Connection connection = codec.connection();
        if (!connection.remote().allowPushTo()) {
            return;
        }
        ChannelHandlerContext rootContext = channel3.parent().pipeline().lastContext();
        int promisedStreamId = connection.local().incrementAndGetNextStreamId();
        DefaultHttp2Headers $this$startHttp2PushPromise_u24lambda_u2d3 = defaultHttp2Headers = new DefaultHttp2Headers();
        boolean bl = false;
        Url url2 = builder.getUrl().build();
        $this$startHttp2PushPromise_u24lambda_u2d3.method(builder.getMethod().getValue());
        $this$startHttp2PushPromise_u24lambda_u2d3.authority(URLUtilsKt.getHostWithPort(url2));
        $this$startHttp2PushPromise_u24lambda_u2d3.scheme(url2.getProtocol().getName());
        $this$startHttp2PushPromise_u24lambda_u2d3.path(url2.getEncodedPathAndQuery());
        DefaultHttp2Headers headers2 = defaultHttp2Headers;
        Http2StreamChannelBootstrap bs = new Http2StreamChannelBootstrap(channel3.parent()).handler(this);
        Http2StreamChannel child = (Http2StreamChannel)bs.open().get();
        Intrinsics.checkNotNullExpressionValue(child, "child");
        this.setId(child, promisedStreamId);
        ChannelPromise promise = rootContext.newPromise();
        Http2Stream childStream = connection.local().createStream(promisedStreamId, false);
        Http2FrameStream http2FrameStream = child.stream();
        Intrinsics.checkNotNullExpressionValue(http2FrameStream, "child.stream()");
        Http2FrameCodec http2FrameCodec = codec;
        Intrinsics.checkNotNullExpressionValue(childStream, "childStream");
        if (!this.setStreamAndProperty(http2FrameStream, http2FrameCodec, childStream)) {
            childStream.close();
            child.close();
            return;
        }
        codec.encoder().frameWriter().writePushPromise(rootContext, streamId, promisedStreamId, headers2, 0, promise);
        if (promise.isSuccess()) {
            ChannelHandlerContext channelHandlerContext = child.pipeline().firstContext();
            Intrinsics.checkNotNullExpressionValue(channelHandlerContext, "child.pipeline().firstContext()");
            this.startHttp2(channelHandlerContext, headers2);
        } else {
            promise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)arg_0 -> NettyHttp2Handler.startHttp2PushPromise$lambda-4(this, child, headers2, arg_0)));
        }
    }

    private final void setId(Http2StreamChannel $this$setId, int streamId) {
        Http2FrameStream http2FrameStream = $this$setId.stream();
        Intrinsics.checkNotNull(http2FrameStream);
        Http2FrameStream stream = http2FrameStream;
        this.getIdField(stream).setInt(stream, streamId);
    }

    private final Field getStreamKeyField() {
        Lazy lazy = this.streamKeyField$delegate;
        return (Field)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean setStreamAndProperty(Http2FrameStream $this$setStreamAndProperty, Http2FrameCodec codec, Http2Stream childStream) {
        Object[] objectArray;
        Object v3;
        Http2Connection.PropertyKey streamKey;
        Object[] objectArray2;
        block5: {
            void $this$firstOrNull$iv;
            Field field = this.getStreamKeyField();
            objectArray2 = field != null ? field.get(codec) : null;
            Http2Connection.PropertyKey propertyKey = objectArray2 instanceof Http2Connection.PropertyKey ? (Http2Connection.PropertyKey)objectArray2 : null;
            if (propertyKey == null) {
                return false;
            }
            streamKey = propertyKey;
            Method[] methodArray = $this$setStreamAndProperty.getClass().getDeclaredMethods();
            Intrinsics.checkNotNullExpressionValue(methodArray, "javaClass.declaredMethods");
            Object[] objectArray3 = methodArray;
            boolean $i$f$firstOrNull = false;
            for (void element$iv : $this$firstOrNull$iv) {
                Method it = (Method)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), "setStreamAndProperty")) continue;
                v3 = element$iv;
                break block5;
            }
            v3 = null;
        }
        objectArray2 = v3;
        if (objectArray2 == null) {
            return false;
        }
        Object[] it = objectArray = objectArray2;
        boolean bl = false;
        it.setAccessible(true);
        Object[] function = objectArray;
        try {
            objectArray2 = new Object[]{streamKey, childStream};
            function.invoke((Object)$this$setStreamAndProperty, objectArray2);
        }
        catch (Throwable cause) {
            return false;
        }
        return true;
    }

    private final Field getIdField(Http2FrameStream $this$idField) {
        return this.findIdField($this$idField.getClass());
    }

    private final Field findIdField(Class<?> $this$findIdField) {
        NettyHttp2Handler nettyHttp2Handler = this;
        Class<?> clazz = $this$findIdField;
        while (true) {
            Class<?> superclass;
            Field field;
            NettyHttp2Handler nettyHttp2Handler2 = nettyHttp2Handler;
            Class<?> clazz2 = clazz;
            try {
                field = clazz2.getDeclaredField("id");
            }
            catch (NoSuchFieldException t) {
                field = null;
            }
            Field idField = field;
            if (idField != null) {
                idField.setAccessible(true);
                return idField;
            }
            if (clazz2.getSuperclass() == null) {
                throw new NoSuchFieldException("id field not found");
            }
            nettyHttp2Handler = nettyHttp2Handler2;
            clazz = superclass;
        }
    }

    private static final void startHttp2PushPromise$lambda-4(NettyHttp2Handler this$0, Http2StreamChannel $child, DefaultHttp2Headers $headers, Future future) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($headers, "$headers");
        future.get();
        ChannelHandlerContext channelHandlerContext = $child.pipeline().firstContext();
        Intrinsics.checkNotNullExpressionValue(channelHandlerContext, "child.pipeline().firstContext()");
        this$0.startHttp2(channelHandlerContext, $headers);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\u0000H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lio/ktor/server/netty/http2/NettyHttp2Handler$Http2ClosedChannelException;", "Ljava/nio/channels/ClosedChannelException;", "Lkotlinx/coroutines/CopyableThrowable;", "errorCode", "", "(J)V", "getErrorCode", "()J", "message", "", "getMessage", "()Ljava/lang/String;", "createCopy", "ktor-server-netty"})
    private static final class Http2ClosedChannelException
    extends ClosedChannelException
    implements CopyableThrowable<Http2ClosedChannelException> {
        private final long errorCode;

        public Http2ClosedChannelException(long errorCode) {
            this.errorCode = errorCode;
        }

        public final long getErrorCode() {
            return this.errorCode;
        }

        @Override
        @NotNull
        public String getMessage() {
            return "Got close frame with code " + this.errorCode;
        }

        @Override
        @NotNull
        public Http2ClosedChannelException createCopy() {
            Http2ClosedChannelException http2ClosedChannelException;
            Http2ClosedChannelException it = http2ClosedChannelException = new Http2ClosedChannelException(this.errorCode);
            boolean bl = false;
            it.initCause(this);
            return http2ClosedChannelException;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\b\u001a\u0004\u0018\u00010\u0005*\u00020\t2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00058B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lio/ktor/server/netty/http2/NettyHttp2Handler$Companion;", "", "()V", "ApplicationCallKey", "Lio/netty/util/AttributeKey;", "Lio/ktor/server/netty/http2/NettyHttp2ApplicationCall;", "kotlin.jvm.PlatformType", "newValue", "applicationCall", "Lio/netty/channel/ChannelHandlerContext;", "getApplicationCall", "(Lio/netty/channel/ChannelHandlerContext;)Lio/ktor/server/netty/http2/NettyHttp2ApplicationCall;", "setApplicationCall", "(Lio/netty/channel/ChannelHandlerContext;Lio/ktor/server/netty/http2/NettyHttp2ApplicationCall;)V", "ktor-server-netty"})
    public static final class Companion {
        private Companion() {
        }

        private final NettyHttp2ApplicationCall getApplicationCall(ChannelHandlerContext $this$applicationCall) {
            return (NettyHttp2ApplicationCall)$this$applicationCall.channel().attr(ApplicationCallKey).get();
        }

        private final void setApplicationCall(ChannelHandlerContext $this$applicationCall, NettyHttp2ApplicationCall newValue) {
            $this$applicationCall.channel().attr(ApplicationCallKey).set(newValue);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

