/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.plugins;

import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMethod;
import io.ktor.http.RequestConnectionPoint;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.request.ApplicationRequestPropertiesKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u0014\u0010\t\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000bR\u0014\u0010\u0016\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000bR\u0014\u0010\u0018\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000bR\u0014\u0010\u001a\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lio/ktor/server/plugins/OriginConnectionPoint;", "Lio/ktor/http/RequestConnectionPoint;", "call", "Lio/ktor/server/application/ApplicationCall;", "(Lio/ktor/server/application/ApplicationCall;)V", "local", "hostHeaderValue", "", "(Lio/ktor/http/RequestConnectionPoint;Ljava/lang/String;)V", "host", "getHost", "()Ljava/lang/String;", "method", "Lio/ktor/http/HttpMethod;", "getMethod", "()Lio/ktor/http/HttpMethod;", "port", "", "getPort", "()I", "remoteHost", "getRemoteHost", "scheme", "getScheme", "uri", "getUri", "version", "getVersion", "ktor-server-core"})
public final class OriginConnectionPoint
implements RequestConnectionPoint {
    @NotNull
    private final RequestConnectionPoint local;
    @Nullable
    private final String hostHeaderValue;

    public OriginConnectionPoint(@NotNull RequestConnectionPoint local, @Nullable String hostHeaderValue) {
        Intrinsics.checkNotNullParameter(local, "local");
        this.local = local;
        this.hostHeaderValue = hostHeaderValue;
    }

    public OriginConnectionPoint(@NotNull ApplicationCall call) {
        Intrinsics.checkNotNullParameter(call, "call");
        this(call.getRequest().getLocal(), ApplicationRequestPropertiesKt.header(call.getRequest(), HttpHeaders.INSTANCE.getHost()));
    }

    @Override
    @NotNull
    public String getScheme() {
        return this.local.getScheme();
    }

    @Override
    @NotNull
    public String getVersion() {
        return this.local.getVersion();
    }

    @Override
    public int getPort() {
        Integer n;
        String string;
        String string2 = this.hostHeaderValue;
        return string2 != null && (string = StringsKt.substringAfter(string2, ":", "80")) != null && (n = StringsKt.toIntOrNull(string)) != null ? n.intValue() : this.local.getPort();
    }

    @Override
    @NotNull
    public String getHost() {
        String string = this.hostHeaderValue;
        if (string == null || (string = StringsKt.substringBefore$default(string, ":", null, 2, null)) == null) {
            string = this.local.getHost();
        }
        return string;
    }

    @Override
    @NotNull
    public String getUri() {
        return this.local.getUri();
    }

    @Override
    @NotNull
    public HttpMethod getMethod() {
        return this.local.getMethod();
    }

    @Override
    @NotNull
    public String getRemoteHost() {
        return this.local.getRemoteHost();
    }
}

