/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.plugins.callloging;

import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpStatusCode;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.plugins.callloging.MDCEntry;
import io.ktor.server.request.ApplicationRequest;
import io.ktor.server.request.ApplicationRequestPropertiesKt;
import io.ktor.util.KtorDsl;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.event.Level;

@KtorDsl
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010$\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u0006H\u0002J\u0006\u0010,\u001a\u00020-J\u001a\u0010.\u001a\u00020-2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005J\u001a\u00100\u001a\u00020-2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u0005J$\u00102\u001a\u00020-2\u0006\u00103\u001a\u00020\u000b2\u0014\u00104\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0005J\u0011\u00105\u001a\u00020\u000b*\u000206H\u0000\u00a2\u0006\u0002\b7R&\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR&\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\t\u00a8\u00068"}, d2={"Lio/ktor/server/plugins/callloging/CallLoggingConfig;", "", "()V", "filters", "", "Lkotlin/Function1;", "Lio/ktor/server/application/ApplicationCall;", "", "getFilters$ktor_server_call_logging", "()Ljava/util/List;", "formatCall", "", "getFormatCall$ktor_server_call_logging", "()Lkotlin/jvm/functions/Function1;", "setFormatCall$ktor_server_call_logging", "(Lkotlin/jvm/functions/Function1;)V", "isColorsEnabled", "isColorsEnabled$ktor_server_call_logging", "()Z", "setColorsEnabled$ktor_server_call_logging", "(Z)V", "level", "Lorg/slf4j/event/Level;", "getLevel", "()Lorg/slf4j/event/Level;", "setLevel", "(Lorg/slf4j/event/Level;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "setLogger", "(Lorg/slf4j/Logger;)V", "mdcEntries", "Lio/ktor/server/plugins/callloging/MDCEntry;", "getMdcEntries$ktor_server_call_logging", "colored", "status", "Lio/ktor/http/HttpStatusCode;", "value", "color", "Lorg/fusesource/jansi/Ansi$Color;", "defaultFormat", "call", "disableDefaultColors", "", "filter", "predicate", "format", "formatter", "mdc", "name", "provider", "toLogStringWithColors", "Lio/ktor/server/request/ApplicationRequest;", "toLogStringWithColors$ktor_server_call_logging", "ktor-server-call-logging"})
public final class CallLoggingConfig {
    @NotNull
    private final List<Function1<ApplicationCall, Boolean>> filters = new ArrayList();
    @NotNull
    private final List<MDCEntry> mdcEntries = new ArrayList();
    @NotNull
    private Function1<? super ApplicationCall, String> formatCall = new Function1<ApplicationCall, String>((Object)this){

        @NotNull
        public final String invoke(@NotNull ApplicationCall p0) {
            Intrinsics.checkNotNullParameter(p0, "p0");
            return CallLoggingConfig.access$defaultFormat((CallLoggingConfig)this.receiver, p0);
        }
    };
    private boolean isColorsEnabled = true;
    @NotNull
    private Level level = Level.INFO;
    @Nullable
    private Logger logger;

    @NotNull
    public final List<Function1<ApplicationCall, Boolean>> getFilters$ktor_server_call_logging() {
        return this.filters;
    }

    @NotNull
    public final List<MDCEntry> getMdcEntries$ktor_server_call_logging() {
        return this.mdcEntries;
    }

    @NotNull
    public final Function1<ApplicationCall, String> getFormatCall$ktor_server_call_logging() {
        return this.formatCall;
    }

    public final void setFormatCall$ktor_server_call_logging(@NotNull Function1<? super ApplicationCall, String> function1) {
        Intrinsics.checkNotNullParameter(function1, "<set-?>");
        this.formatCall = function1;
    }

    public final boolean isColorsEnabled$ktor_server_call_logging() {
        return this.isColorsEnabled;
    }

    public final void setColorsEnabled$ktor_server_call_logging(boolean bl) {
        this.isColorsEnabled = bl;
    }

    @NotNull
    public final Level getLevel() {
        return this.level;
    }

    public final void setLevel(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, "<set-?>");
        this.level = level;
    }

    @Nullable
    public final Logger getLogger() {
        return this.logger;
    }

    public final void setLogger(@Nullable Logger logger) {
        this.logger = logger;
    }

    public final void filter(@NotNull Function1<? super ApplicationCall, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        this.filters.add(predicate);
    }

    public final void mdc(@NotNull String name, @NotNull Function1<? super ApplicationCall, String> provider2) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(provider2, "provider");
        this.mdcEntries.add(new MDCEntry(name, provider2));
    }

    public final void format(@NotNull Function1<? super ApplicationCall, String> formatter) {
        Intrinsics.checkNotNullParameter(formatter, "formatter");
        this.formatCall = formatter;
    }

    public final void disableDefaultColors() {
        this.isColorsEnabled = false;
    }

    private final String defaultFormat(ApplicationCall call) {
        HttpStatusCode status;
        Object object = call.getResponse().status();
        if (object == null) {
            object = "Unhandled";
        }
        return Intrinsics.areEqual(status = object, HttpStatusCode.Companion.getFound()) ? this.colored(status) + ": " + this.toLogStringWithColors$ktor_server_call_logging(call.getRequest()) + " -> " + call.getResponse().getHeaders().get(HttpHeaders.INSTANCE.getLocation()) : (Intrinsics.areEqual(status, "Unhandled") ? this.colored(status, Ansi.Color.RED) + ": " + this.toLogStringWithColors$ktor_server_call_logging(call.getRequest()) : this.colored(status) + ": " + this.toLogStringWithColors$ktor_server_call_logging(call.getRequest()));
    }

    @NotNull
    public final String toLogStringWithColors$ktor_server_call_logging(@NotNull ApplicationRequest $this$toLogStringWithColors) {
        Intrinsics.checkNotNullParameter($this$toLogStringWithColors, "<this>");
        return this.colored(ApplicationRequestPropertiesKt.getHttpMethod($this$toLogStringWithColors).getValue(), Ansi.Color.CYAN) + " - " + ApplicationRequestPropertiesKt.path($this$toLogStringWithColors);
    }

    private final String colored(HttpStatusCode status) {
        HttpStatusCode httpStatusCode;
        try {
            if (this.isColorsEnabled && !AnsiConsole.isInstalled()) {
                AnsiConsole.systemInstall();
            }
        }
        catch (Throwable cause) {
            this.isColorsEnabled = false;
        }
        return (((Intrinsics.areEqual(httpStatusCode = status, HttpStatusCode.Companion.getFound()) ? true : Intrinsics.areEqual(httpStatusCode, HttpStatusCode.Companion.getOK())) ? true : Intrinsics.areEqual(httpStatusCode, HttpStatusCode.Companion.getAccepted())) ? true : Intrinsics.areEqual(httpStatusCode, HttpStatusCode.Companion.getCreated())) ? this.colored(status, Ansi.Color.GREEN) : (((((((Intrinsics.areEqual(httpStatusCode, HttpStatusCode.Companion.getContinue()) ? true : Intrinsics.areEqual(httpStatusCode, HttpStatusCode.Companion.getProcessing())) ? true : Intrinsics.areEqual(httpStatusCode, HttpStatusCode.Companion.getPartialContent())) ? true : Intrinsics.areEqual(httpStatusCode, HttpStatusCode.Companion.getNotModified())) ? true : Intrinsics.areEqual(httpStatusCode, HttpStatusCode.Companion.getUseProxy())) ? true : Intrinsics.areEqual(httpStatusCode, HttpStatusCode.Companion.getUpgradeRequired())) ? true : Intrinsics.areEqual(httpStatusCode, HttpStatusCode.Companion.getNoContent())) ? this.colored(status, Ansi.Color.YELLOW) : this.colored(status, Ansi.Color.RED));
    }

    private final String colored(Object value, Ansi.Color color) {
        String string;
        if (this.isColorsEnabled) {
            String string2 = Ansi.ansi().fg(color).a(value).reset().toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "ansi().fg(color).a(value).reset().toString()");
        } else {
            string = value.toString();
        }
        return string;
    }

    public static final /* synthetic */ String access$defaultFormat(CallLoggingConfig $this, ApplicationCall call) {
        return $this.defaultFormat(call);
    }
}

