/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.plugins.cors;

import io.ktor.http.ContentType;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMethod;
import io.ktor.util.CaseInsensitiveSet;
import io.ktor.util.CollectionsJvmKt;
import io.ktor.util.KtorDsl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@KtorDsl
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u000b\b\u0007\u0018\u0000 A2\u00020\u0001:\u0001AB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0011H\u0002J\u000e\u0010/\u001a\u00020-2\u0006\u00100\u001a\u00020\u0011J\u001a\u00101\u001a\u00020-2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00040\u0017J\u000e\u00103\u001a\u00020-2\u0006\u00104\u001a\u00020\u0011J.\u00105\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00112\u000e\b\u0002\u00106\u001a\b\u0012\u0004\u0012\u00020\u0011072\u000e\b\u0002\u00108\u001a\b\u0012\u0004\u0012\u00020\u001107J\u000e\u00109\u001a\u00020-2\u0006\u0010:\u001a\u00020'J\u001a\u0010;\u001a\u00020-2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00040\u0017J\u0006\u0010<\u001a\u00020-J\u0006\u0010=\u001a\u00020-J\u000e\u0010>\u001a\u00020-2\u0006\u00100\u001a\u00020\u0011J\u0010\u0010?\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0011H\u0002J\u0010\u0010@\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u0011H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u0002\u001a\u0004\b\u0013\u0010\u0014R#\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00040\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001d\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001b\u0010\u0002\u001a\u0004\b\u001c\u0010\u0014R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0014R$\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 @FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0014R&\u0010)\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00040\u00170\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0019R\u000e\u0010+\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lio/ktor/server/plugins/cors/CORSConfig;", "", "()V", "allowCredentials", "", "getAllowCredentials", "()Z", "setAllowCredentials", "(Z)V", "allowNonSimpleContentTypes", "getAllowNonSimpleContentTypes", "setAllowNonSimpleContentTypes", "allowSameOrigin", "getAllowSameOrigin", "setAllowSameOrigin", "exposedHeaders", "", "", "getExposedHeaders$annotations", "getExposedHeaders", "()Ljava/util/Set;", "headerPredicates", "", "Lkotlin/Function1;", "getHeaderPredicates", "()Ljava/util/List;", "headers", "getHeaders$annotations", "getHeaders", "hosts", "getHosts", "newMaxAge", "", "maxAgeInSeconds", "getMaxAgeInSeconds", "()J", "setMaxAgeInSeconds", "(J)V", "methods", "Lio/ktor/http/HttpMethod;", "getMethods", "originPredicates", "getOriginPredicates$ktor_server_cors", "wildcardWithDot", "addHost", "", "host", "allowHeader", "header", "allowHeaders", "predicate", "allowHeadersPrefixed", "headerPrefix", "allowHost", "schemes", "", "subDomains", "allowMethod", "method", "allowOrigins", "allowXHttpMethodOverride", "anyHost", "exposeHeader", "validateWildcardRequirements", "wildcardInFrontOfDomain", "Companion", "ktor-server-cors"})
public final class CORSConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String wildcardWithDot;
    @NotNull
    private final Set<String> hosts = new HashSet();
    @NotNull
    private final Set<String> headers = new CaseInsensitiveSet();
    @NotNull
    private final Set<HttpMethod> methods = new HashSet();
    @NotNull
    private final Set<String> exposedHeaders = new CaseInsensitiveSet();
    private boolean allowCredentials;
    @NotNull
    private final List<Function1<String, Boolean>> originPredicates = new ArrayList();
    @NotNull
    private final List<Function1<String, Boolean>> headerPredicates = new ArrayList();
    private long maxAgeInSeconds = 86400L;
    private boolean allowSameOrigin = true;
    private boolean allowNonSimpleContentTypes;
    public static final long CORS_DEFAULT_MAX_AGE = 86400L;
    @NotNull
    private static final Set<HttpMethod> CorsDefaultMethods;
    @NotNull
    private static final Set<String> CorsSimpleRequestHeaders;
    @NotNull
    private static final Set<String> CorsSimpleResponseHeaders;
    @NotNull
    private static final Set<ContentType> CorsSimpleContentTypes;

    public CORSConfig() {
        this.wildcardWithDot = "*.";
    }

    @NotNull
    public final Set<String> getHosts() {
        return this.hosts;
    }

    @NotNull
    public final Set<String> getHeaders() {
        return this.headers;
    }

    public static /* synthetic */ void getHeaders$annotations() {
    }

    @NotNull
    public final Set<HttpMethod> getMethods() {
        return this.methods;
    }

    @NotNull
    public final Set<String> getExposedHeaders() {
        return this.exposedHeaders;
    }

    public static /* synthetic */ void getExposedHeaders$annotations() {
    }

    public final boolean getAllowCredentials() {
        return this.allowCredentials;
    }

    public final void setAllowCredentials(boolean bl) {
        this.allowCredentials = bl;
    }

    @NotNull
    public final List<Function1<String, Boolean>> getOriginPredicates$ktor_server_cors() {
        return this.originPredicates;
    }

    @NotNull
    public final List<Function1<String, Boolean>> getHeaderPredicates() {
        return this.headerPredicates;
    }

    public final long getMaxAgeInSeconds() {
        return this.maxAgeInSeconds;
    }

    public final void setMaxAgeInSeconds(long newMaxAge) {
        if (!(newMaxAge >= 0L)) {
            boolean bl = false;
            String string = "maxAgeInSeconds shouldn't be negative: " + newMaxAge;
            throw new IllegalStateException(string.toString());
        }
        this.maxAgeInSeconds = newMaxAge;
    }

    public final boolean getAllowSameOrigin() {
        return this.allowSameOrigin;
    }

    public final void setAllowSameOrigin(boolean bl) {
        this.allowSameOrigin = bl;
    }

    public final boolean getAllowNonSimpleContentTypes() {
        return this.allowNonSimpleContentTypes;
    }

    public final void setAllowNonSimpleContentTypes(boolean bl) {
        this.allowNonSimpleContentTypes = bl;
    }

    public final void anyHost() {
        this.hosts.add("*");
    }

    public final void allowHost(@NotNull String host2, @NotNull List<String> schemes, @NotNull List<String> subDomains) {
        Intrinsics.checkNotNullParameter(host2, "host");
        Intrinsics.checkNotNullParameter(schemes, "schemes");
        Intrinsics.checkNotNullParameter(subDomains, "subDomains");
        if (Intrinsics.areEqual(host2, "*")) {
            this.anyHost();
            return;
        }
        if (!(!StringsKt.contains$default((CharSequence)host2, "://", false, 2, null))) {
            boolean $i$a$-require-CORSConfig$allowHost$22 = false;
            String $i$a$-require-CORSConfig$allowHost$22 = "scheme should be specified as a separate parameter schemes";
            throw new IllegalArgumentException($i$a$-require-CORSConfig$allowHost$22.toString());
        }
        for (String schema2 : schemes) {
            this.addHost(schema2 + "://" + host2);
            for (String subDomain : subDomains) {
                this.validateWildcardRequirements(subDomain);
                this.addHost(schema2 + "://" + subDomain + '.' + host2);
            }
        }
    }

    public static /* synthetic */ void allowHost$default(CORSConfig cORSConfig, String string, List list, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.listOf("http");
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        cORSConfig.allowHost(string, list, list2);
    }

    private final void addHost(String host2) {
        this.validateWildcardRequirements(host2);
        this.hosts.add(host2);
    }

    private final void validateWildcardRequirements(String host2) {
        if (!StringsKt.contains$default((CharSequence)host2, '*', false, 2, null)) {
            return;
        }
        if (!this.wildcardInFrontOfDomain(host2)) {
            boolean $i$a$-require-CORSConfig$validateWildcardRequirements$32 = false;
            String $i$a$-require-CORSConfig$validateWildcardRequirements$32 = "wildcard must appear in front of the domain, e.g. *.domain.com";
            throw new IllegalArgumentException($i$a$-require-CORSConfig$validateWildcardRequirements$32.toString());
        }
        if (!(CORSConfig.validateWildcardRequirements$countMatches(host2, this.wildcardWithDot) == 1)) {
            boolean bl = false;
            String string = "wildcard cannot appear more than once";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final boolean wildcardInFrontOfDomain(String host2) {
        int indexOfWildcard = StringsKt.indexOf$default((CharSequence)host2, this.wildcardWithDot, 0, false, 6, null);
        return StringsKt.contains$default((CharSequence)host2, this.wildcardWithDot, false, 2, null) && !StringsKt.endsWith$default(host2, this.wildcardWithDot, false, 2, null) && (indexOfWildcard <= 0 || StringsKt.endsWith$default(StringsKt.substringBefore$default(host2, this.wildcardWithDot, null, 2, null), "://", false, 2, null));
    }

    public final void exposeHeader(@NotNull String header) {
        Intrinsics.checkNotNullParameter(header, "header");
        if (!CorsSimpleResponseHeaders.contains(header)) {
            this.exposedHeaders.add(header);
        }
    }

    public final void allowXHttpMethodOverride() {
        this.allowHeader(HttpHeaders.INSTANCE.getXHttpMethodOverride());
    }

    public final void allowOrigins(@NotNull Function1<? super String, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        this.originPredicates.add(predicate);
    }

    public final void allowHeadersPrefixed(@NotNull String headerPrefix) {
        Intrinsics.checkNotNullParameter(headerPrefix, "headerPrefix");
        String string = headerPrefix.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        String prefix = string;
        this.headerPredicates.add(new Function1<String, Boolean>(prefix){
            final /* synthetic */ String $prefix;
            {
                this.$prefix = $prefix;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String name) {
                Intrinsics.checkNotNullParameter(name, "name");
                return StringsKt.startsWith$default(name, this.$prefix, false, 2, null);
            }
        });
    }

    public final void allowHeaders(@NotNull Function1<? super String, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        this.headerPredicates.add(predicate);
    }

    public final void allowHeader(@NotNull String header) {
        Intrinsics.checkNotNullParameter(header, "header");
        if (StringsKt.equals(header, HttpHeaders.INSTANCE.getContentType(), true)) {
            this.allowNonSimpleContentTypes = true;
            return;
        }
        if (!CorsSimpleRequestHeaders.contains(header)) {
            this.headers.add(header);
        }
    }

    public final void allowMethod(@NotNull HttpMethod method2) {
        Intrinsics.checkNotNullParameter(method2, "method");
        if (!CorsDefaultMethods.contains(method2)) {
            this.methods.add(method2);
        }
    }

    private static final int validateWildcardRequirements$countMatches(String $this$validateWildcardRequirements_u24countMatches, String subString) {
        return CollectionsKt.sumOfInt(StringsKt.windowed$default($this$validateWildcardRequirements_u24countMatches, subString.length(), 0, false, new Function1<CharSequence, Integer>(subString){
            final /* synthetic */ String $subString;
            {
                this.$subString = $subString;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull CharSequence it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it, this.$subString) ? 1 : 0;
            }
        }, 6, null));
    }

    static {
        Object[] objectArray = new HttpMethod[]{HttpMethod.Companion.getGet(), HttpMethod.Companion.getPost(), HttpMethod.Companion.getHead()};
        CorsDefaultMethods = SetsKt.setOf(objectArray);
        objectArray = new String[]{HttpHeaders.INSTANCE.getAccept(), HttpHeaders.INSTANCE.getAcceptLanguage(), HttpHeaders.INSTANCE.getContentLanguage(), HttpHeaders.INSTANCE.getContentType()};
        CorsSimpleRequestHeaders = CORSConfig.Companion.caseInsensitiveSet((String[])objectArray);
        objectArray = new String[]{HttpHeaders.INSTANCE.getCacheControl(), HttpHeaders.INSTANCE.getContentLanguage(), HttpHeaders.INSTANCE.getContentType(), HttpHeaders.INSTANCE.getExpires(), HttpHeaders.INSTANCE.getLastModified(), HttpHeaders.INSTANCE.getPragma()};
        CorsSimpleResponseHeaders = CORSConfig.Companion.caseInsensitiveSet((String[])objectArray);
        objectArray = new ContentType[]{ContentType.Application.INSTANCE.getFormUrlEncoded(), ContentType.MultiPart.INSTANCE.getFormData(), ContentType.Text.INSTANCE.getPlain()};
        CorsSimpleContentTypes = CollectionsJvmKt.unmodifiable(SetsKt.setOf(objectArray));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u0015\"\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\tR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\t\u00a8\u0006\u0017"}, d2={"Lio/ktor/server/plugins/cors/CORSConfig$Companion;", "", "()V", "CORS_DEFAULT_MAX_AGE", "", "CorsDefaultMethods", "", "Lio/ktor/http/HttpMethod;", "getCorsDefaultMethods", "()Ljava/util/Set;", "CorsSimpleContentTypes", "Lio/ktor/http/ContentType;", "getCorsSimpleContentTypes$annotations", "getCorsSimpleContentTypes", "CorsSimpleRequestHeaders", "", "getCorsSimpleRequestHeaders", "CorsSimpleResponseHeaders", "getCorsSimpleResponseHeaders", "caseInsensitiveSet", "elements", "", "([Ljava/lang/String;)Ljava/util/Set;", "ktor-server-cors"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<HttpMethod> getCorsDefaultMethods() {
            return CorsDefaultMethods;
        }

        @NotNull
        public final Set<String> getCorsSimpleRequestHeaders() {
            return CorsSimpleRequestHeaders;
        }

        @NotNull
        public final Set<String> getCorsSimpleResponseHeaders() {
            return CorsSimpleResponseHeaders;
        }

        @NotNull
        public final Set<ContentType> getCorsSimpleContentTypes() {
            return CorsSimpleContentTypes;
        }

        public static /* synthetic */ void getCorsSimpleContentTypes$annotations() {
        }

        private final Set<String> caseInsensitiveSet(String ... elements) {
            return new CaseInsensitiveSet((Iterable<String>)ArraysKt.asList(elements));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

