/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.plugins.cors;

import io.ktor.http.ContentType;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMethod;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.RequestConnectionPoint;
import io.ktor.http.content.OutgoingContent;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.application.ApplicationPlugin;
import io.ktor.server.application.CreatePluginUtilsKt;
import io.ktor.server.application.OnCallContext;
import io.ktor.server.application.PluginBuilder;
import io.ktor.server.plugins.OriginConnectionPointKt;
import io.ktor.server.plugins.cors.CORSConfig;
import io.ktor.server.plugins.cors.CORSKt;
import io.ktor.server.plugins.cors.OriginCheckResult;
import io.ktor.server.request.ApplicationRequestPropertiesKt;
import io.ktor.server.response.ApplicationResponsePropertiesKt;
import io.ktor.server.response.ResponseTypeKt;
import io.ktor.util.TextKt;
import io.ktor.util.reflect.TypeInfoJvmKt;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u001ar\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0018\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00130\u00112\u0018\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001ab\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0018\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00130\u00112\u0018\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a>\u0010\u001a\u001a\u00020\u000e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0018\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\u00160\u0015H\u0002\u001a*\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\n2\u0018\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\u00160\u0015H\u0002\u001a \u0010 \u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0018\u0010\"\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0014\u0010#\u001a\u00020$*\u00020%2\u0006\u0010&\u001a\u00020\u000eH\u0002\u001a$\u0010'\u001a\u00020$*\u00020%2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u000eH\u0002\u001a\u0016\u0010(\u001a\u00020$*\u00020%2\b\u0010)\u001a\u0004\u0018\u00010\nH\u0002\u001a\u0012\u0010*\u001a\u00020$*\b\u0012\u0004\u0012\u00020\u00020+H\u0000\u001a\u001a\u0010,\u001a\u00020\u000e*\u00020%2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u0011H\u0002\u001a\u001a\u0010/\u001a\u00020\u000e*\u00020%2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u0011H\u0002\u001a\f\u00100\u001a\u00020$*\u00020%H\u0002\u001a\u0015\u00101\u001a\u00020$*\u00020%H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102\u001a\u0083\u0001\u00103\u001a\u00020$*\u00020%2\u0006\u0010\t\u001a\u00020\n2\u0006\u00104\u001a\u00020\n2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\n0\u00152\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u00112\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u000e2\b\u0010)\u001a\u0004\u0018\u00010\n2\u0018\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\u00160\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106\"\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00067"}, d2={"CORS", "Lio/ktor/server/application/ApplicationPlugin;", "Lio/ktor/server/plugins/cors/CORSConfig;", "getCORS$annotations", "()V", "getCORS", "()Lio/ktor/server/application/ApplicationPlugin;", "checkOrigin", "Lio/ktor/server/plugins/cors/OriginCheckResult;", "origin", "", "point", "Lio/ktor/http/RequestConnectionPoint;", "allowSameOrigin", "", "allowsAnyHost", "hostsNormalized", "", "hostsWithWildcard", "Lkotlin/Pair;", "originPredicates", "", "Lkotlin/Function1;", "numberRegex", "Lkotlin/text/Regex;", "corsCheckOrigins", "corsCheckRequestHeaders", "requestHeaders", "allHeadersSet", "headerPredicates", "headerMatchesAPredicate", "header", "isSameOrigin", "isValidOrigin", "normalizeOrigin", "accessControlAllowCredentials", "", "Lio/ktor/server/application/ApplicationCall;", "allowCredentials", "accessControlAllowOrigin", "accessControlMaxAge", "maxAgeHeaderValue", "buildPlugin", "Lio/ktor/server/application/PluginBuilder;", "corsCheckCurrentMethod", "methods", "Lio/ktor/http/HttpMethod;", "corsCheckRequestMethod", "corsVary", "respondCorsFailed", "(Lio/ktor/server/application/ApplicationCall;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "respondPreflight", "methodsListHeaderValue", "headersList", "(Lio/ktor/server/application/ApplicationCall;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/Set;ZZLjava/lang/String;Ljava/util/List;Ljava/util/Set;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ktor-server-cors"})
public final class CORSKt {
    @NotNull
    private static final ApplicationPlugin<CORSConfig> CORS = CreatePluginUtilsKt.createApplicationPlugin("CORS", CORS.1.INSTANCE, CORS.2.INSTANCE);

    @NotNull
    public static final ApplicationPlugin<CORSConfig> getCORS() {
        return CORS;
    }

    @Deprecated(message="This plugin was moved to io.ktor.server.plugins.cors.routing", replaceWith=@ReplaceWith(expression="CORS", imports={"io.ktor.server.plugins.cors.routing.CORS"}), level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getCORS$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    public static final void buildPlugin(@NotNull PluginBuilder<CORSConfig> $this$buildPlugin) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        String it;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        void $this$mapTo$iv$iv3;
        void $this$map$iv3;
        void $this$filterNotTo$iv$iv2;
        void $this$filterNotTo$iv$iv3;
        Collection collection2;
        void $this$mapTo$iv$iv4;
        Intrinsics.checkNotNullParameter($this$buildPlugin, "<this>");
        Regex numberRegex = new Regex("[0-9]+");
        boolean allowSameOrigin = $this$buildPlugin.getPluginConfig().getAllowSameOrigin();
        boolean allowsAnyHost = $this$buildPlugin.getPluginConfig().getHosts().contains("*");
        boolean allowCredentials = $this$buildPlugin.getPluginConfig().getAllowCredentials();
        Set<String> headers2 = SetsKt.plus($this$buildPlugin.getPluginConfig().getHeaders(), (Iterable)CORSConfig.Companion.getCorsSimpleRequestHeaders());
        boolean bl = false;
        Set<String> allHeaders = $this$buildPlugin.getPluginConfig().getAllowNonSimpleContentTypes() ? headers2 : SetsKt.minus(headers2, HttpHeaders.INSTANCE.getContentType());
        List<Function1<String, Boolean>> originPredicates = $this$buildPlugin.getPluginConfig().getOriginPredicates$ktor_server_cors();
        List<Function1<String, Boolean>> headerPredicates = $this$buildPlugin.getPluginConfig().getHeaderPredicates();
        Set methods2 = new HashSet(SetsKt.plus($this$buildPlugin.getPluginConfig().getMethods(), (Iterable)CORSConfig.Companion.getCorsDefaultMethods()));
        Iterable $this$map$iv4 = allHeaders;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv4;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv4, 10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            Iterator it2;
            String string = (String)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl2 = false;
            collection2.add(TextKt.toLowerCasePreservingASCIIRules((String)((Object)it2)));
        }
        Set<String> allHeadersSet = CollectionsKt.toSet((List)destination$iv$iv);
        boolean allowNonSimpleContentTypes = $this$buildPlugin.getPluginConfig().getAllowNonSimpleContentTypes();
        Iterable $this$filterNot$iv2 = $this$buildPlugin.getPluginConfig().getHeaders();
        boolean $i$f$filterNot = false;
        Iterable $i$f$mapTo22 = $this$filterNot$iv2;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv3) {
            String it3 = (String)element$iv$iv;
            boolean bl3 = false;
            if (CORSConfig.Companion.getCorsSimpleRequestHeaders().contains(it3)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List<String> it4 = (List<String>)destination$iv$iv2;
        boolean bl4 = false;
        List<String> headersList = allowNonSimpleContentTypes ? CollectionsKt.plus((Collection)it4, HttpHeaders.INSTANCE.getContentType()) : it4;
        Iterable $this$filterNot$iv3 = methods2;
        boolean $i$f$filterNot2 = false;
        destination$iv$iv2 = $this$filterNot$iv3;
        Iterable destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterNotTo2 = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv2) {
            HttpMethod it5 = (HttpMethod)element$iv$iv;
            boolean bl5 = false;
            if (CORSConfig.Companion.getCorsDefaultMethods().contains(it5)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filterNot$iv3 = (List)destination$iv$iv3;
        boolean $i$f$map2 = false;
        $this$filterNotTo$iv$iv2 = $this$map$iv3;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            HttpMethod it5 = (HttpMethod)item$iv$iv;
            collection2 = destination$iv$iv3;
            boolean bl6 = false;
            collection2.add(it5.getValue());
        }
        String methodsListHeaderValue = CollectionsKt.joinToString$default(CollectionsKt.sorted((List)destination$iv$iv3), ", ", null, null, 0, null, null, 62, null);
        long it6 = $this$buildPlugin.getPluginConfig().getMaxAgeInSeconds();
        boolean bl7 = false;
        String maxAgeHeaderValue = it6 > 0L ? String.valueOf(it6) : null;
        String exposedHeaders = !((Collection)$this$buildPlugin.getPluginConfig().getExposedHeaders()).isEmpty() ? CollectionsKt.joinToString$default(CollectionsKt.sorted((Iterable)$this$buildPlugin.getPluginConfig().getExposedHeaders()), ", ", null, null, 0, null, null, 62, null) : null;
        destination$iv$iv3 = $this$buildPlugin.getPluginConfig().getHosts();
        boolean $i$f$filterNot3 = false;
        Iterator element$iv$iv = $this$filterNot$iv;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterNotTo3 = false;
        for (Object element$iv$iv2 : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv2;
            boolean bl8 = false;
            if (StringsKt.contains$default((CharSequence)it, '*', false, 2, null)) continue;
            destination$iv$iv4.add(element$iv$iv2);
        }
        $this$filterNot$iv = (List)destination$iv$iv4;
        boolean $i$f$map222 = false;
        $this$filterNotTo$iv$iv = $this$map$iv2;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl9 = false;
            collection.add(CORSKt.normalizeOrigin(it, numberRegex));
        }
        Collection collection3 = (List)destination$iv$iv4;
        HashSet<String> hostsNormalized = new HashSet<String>(collection3);
        Iterable $i$f$map222 = $this$buildPlugin.getPluginConfig().getHosts();
        boolean $i$f$filter = false;
        destination$iv$iv4 = $this$filter$iv;
        Collection destination$iv$iv5 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
            String it7 = (String)element$iv$iv3;
            boolean bl10 = false;
            if (!StringsKt.contains$default((CharSequence)it7, '*', false, 2, null)) continue;
            destination$iv$iv5.add(element$iv$iv3);
        }
        $this$filter$iv = (List)destination$iv$iv5;
        boolean $i$f$map3 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String it7 = (String)item$iv$iv;
            collection = destination$iv$iv5;
            boolean bl11 = false;
            String normalizedOrigin = CORSKt.normalizeOrigin(it7, numberRegex);
            char[] cArray = new char[]{'*'};
            List list = StringsKt.split$default((CharSequence)normalizedOrigin, cArray, false, 0, 6, null);
            String prefix = (String)list.get(0);
            String suffix = (String)list.get(1);
            collection.add(TuplesKt.to(prefix, suffix));
        }
        Collection collection4 = (List)destination$iv$iv5;
        HashSet<Pair<String, String>> hostsWithWildcard = new HashSet<Pair<String, String>>(collection4);
        $this$buildPlugin.onCall((Function3<OnCallContext<CORSConfig>, ApplicationCall, Continuation<Unit>, Object>)new Function3<OnCallContext<CORSConfig>, ApplicationCall, Continuation<? super Unit>, Object>(allowsAnyHost, allowCredentials, allowSameOrigin, hostsNormalized, hostsWithWildcard, originPredicates, numberRegex, allowNonSimpleContentTypes, methodsListHeaderValue, headersList, (Set<HttpMethod>)methods2, maxAgeHeaderValue, headerPredicates, allHeadersSet, exposedHeaders, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ boolean $allowsAnyHost;
            final /* synthetic */ boolean $allowCredentials;
            final /* synthetic */ boolean $allowSameOrigin;
            final /* synthetic */ HashSet<String> $hostsNormalized;
            final /* synthetic */ HashSet<Pair<String, String>> $hostsWithWildcard;
            final /* synthetic */ List<Function1<String, Boolean>> $originPredicates;
            final /* synthetic */ Regex $numberRegex;
            final /* synthetic */ boolean $allowNonSimpleContentTypes;
            final /* synthetic */ String $methodsListHeaderValue;
            final /* synthetic */ List<String> $headersList;
            final /* synthetic */ Set<HttpMethod> $methods;
            final /* synthetic */ String $maxAgeHeaderValue;
            final /* synthetic */ List<Function1<String, Boolean>> $headerPredicates;
            final /* synthetic */ Set<String> $allHeadersSet;
            final /* synthetic */ String $exposedHeaders;
            {
                this.$allowsAnyHost = $allowsAnyHost;
                this.$allowCredentials = $allowCredentials;
                this.$allowSameOrigin = $allowSameOrigin;
                this.$hostsNormalized = $hostsNormalized;
                this.$hostsWithWildcard = $hostsWithWildcard;
                this.$originPredicates = $originPredicates;
                this.$numberRegex = $numberRegex;
                this.$allowNonSimpleContentTypes = $allowNonSimpleContentTypes;
                this.$methodsListHeaderValue = $methodsListHeaderValue;
                this.$headersList = $headersList;
                this.$methods = $methods;
                this.$maxAgeHeaderValue = $maxAgeHeaderValue;
                this.$headerPredicates = $headerPredicates;
                this.$allHeadersSet = $allHeadersSet;
                this.$exposedHeaders = $exposedHeaders;
                super(3, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block23: {
                    block22: {
                        block21: {
                            var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            block0 : switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure(var1_1);
                                    call = (ApplicationCall)this.L$0;
                                    if (!this.$allowsAnyHost || this.$allowCredentials) {
                                        CORSKt.access$corsVary(call);
                                    }
                                    if ((v0 = call.getRequest().getHeaders().getAll(HttpHeaders.INSTANCE.getOrigin())) == null || (v0 = CollectionsKt.singleOrNull(v0)) == null) {
                                        return Unit.INSTANCE;
                                    }
                                    origin = v0;
                                    var5_6 = checkOrigin = CORSKt.access$checkOrigin((String)origin, OriginConnectionPointKt.getOrigin(call.getRequest()), this.$allowSameOrigin, this.$allowsAnyHost, this.$hostsNormalized, this.$hostsWithWildcard, this.$originPredicates, this.$numberRegex);
                                    switch (buildPlugin.WhenMappings.$EnumSwitchMapping$0[var5_6.ordinal()]) {
                                        case 1: {
                                            ** GOTO lbl29
                                        }
                                        case 2: {
                                            return Unit.INSTANCE;
                                        }
                                        case 3: {
                                            this.label = 1;
                                            v1 = CORSKt.access$respondCorsFailed(call, this);
                                            if (v1 == var8_2) {
                                                return var8_2;
                                            }
                                            ** GOTO lbl28
                                        }
                                        default: {
                                            if (this.$allowNonSimpleContentTypes) break block0;
                                        }
                                    }
                                }
                                case 1: {
                                    ResultKt.throwOnFailure($result);
                                    v1 = $result;
lbl28:
                                    // 2 sources

                                    return Unit.INSTANCE;
                                }
                            }
lbl29:
                            // 1 sources

                            if (this.$allowNonSimpleContentTypes) ** break;
                            v2 = ApplicationRequestPropertiesKt.header(call.getRequest(), HttpHeaders.INSTANCE.getContentType());
                            if (v2 != null) {
                                it = v2;
                                $i$a$-let-CORSKt$buildPlugin$1$contentType$1 = false;
                                v3 = ContentType.Companion.parse(it);
                            } else {
                                v3 = contentType = null;
                            }
                            if (contentType == null || CORSConfig.Companion.getCorsSimpleContentTypes().contains(contentType.withoutParameters())) break block21;
                            this.label = 2;
                            v4 = CORSKt.access$respondCorsFailed(call, this);
                            if (v4 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl47
                            {
                                case 2: {
                                    ResultKt.throwOnFailure($result);
                                    v4 = $result;
lbl47:
                                    // 2 sources

                                    return Unit.INSTANCE;
                                }
                            }
                        }
                        if (!Intrinsics.areEqual(ApplicationRequestPropertiesKt.getHttpMethod(call.getRequest()), HttpMethod.Companion.getOptions())) break block22;
                        this.label = 3;
                        v5 = CORSKt.access$respondPreflight(call, (String)origin, this.$methodsListHeaderValue, this.$headersList, this.$methods, this.$allowsAnyHost, this.$allowCredentials, this.$maxAgeHeaderValue, this.$headerPredicates, this.$allHeadersSet, this);
                        if (v5 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl58
                        {
                            case 3: {
                                ResultKt.throwOnFailure($result);
                                v5 = $result;
lbl58:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                    }
                    if (CORSKt.access$corsCheckCurrentMethod(call, this.$methods)) break block23;
                    this.label = 4;
                    v6 = CORSKt.access$respondCorsFailed(call, this);
                    if (v6 == var8_2) {
                        return var8_2;
                    }
                    ** GOTO lbl69
                    {
                        case 4: {
                            ResultKt.throwOnFailure($result);
                            v6 = $result;
lbl69:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                }
                CORSKt.access$accessControlAllowOrigin(call, (String)origin, this.$allowsAnyHost, this.$allowCredentials);
                CORSKt.access$accessControlAllowCredentials(call, this.$allowCredentials);
                if (this.$exposedHeaders != null) {
                    ApplicationResponsePropertiesKt.header(call.getResponse(), HttpHeaders.INSTANCE.getAccessControlExposeHeaders(), this.$exposedHeaders);
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Nullable
            public final Object invoke(@NotNull OnCallContext<CORSConfig> p1, @NotNull ApplicationCall p2, @Nullable Continuation<? super Unit> p3) {
                Function3<OnCallContext<CORSConfig>, ApplicationCall, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.L$0 = p2;
                return function3.invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private static final OriginCheckResult checkOrigin(String origin2, RequestConnectionPoint point, boolean allowSameOrigin, boolean allowsAnyHost, Set<String> hostsNormalized, Set<Pair<String, String>> hostsWithWildcard, List<? extends Function1<? super String, Boolean>> originPredicates, Regex numberRegex) {
        return !CORSKt.isValidOrigin(origin2) ? OriginCheckResult.SkipCORS : (allowSameOrigin && CORSKt.isSameOrigin(origin2, point, numberRegex) ? OriginCheckResult.SkipCORS : (!CORSKt.corsCheckOrigins(origin2, allowsAnyHost, hostsNormalized, hostsWithWildcard, originPredicates, numberRegex) ? OriginCheckResult.Failed : OriginCheckResult.OK));
    }

    /*
     * WARNING - void declaration
     */
    private static final Object respondPreflight(ApplicationCall $this$respondPreflight, String origin2, String methodsListHeaderValue, List<String> headersList, Set<HttpMethod> methods2, boolean allowsAnyHost, boolean allowCredentials, String maxAgeHeaderValue, List<? extends Function1<? super String, Boolean>> headerPredicates, Set<String> allHeadersSet, Continuation<? super Unit> $completion) {
        void $this$respond$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        List requestHeaders2;
        List list;
        List<String> list2 = $this$respondPreflight.getRequest().getHeaders().getAll(HttpHeaders.INSTANCE.getAccessControlRequestHeaders());
        if (list2 != null) {
            Iterator $this$mapTo$iv$iv;
            void $this$map$iv;
            Object element$iv$iv3;
            void $this$filterTo$iv$iv2;
            void $this$filter$iv2;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = list2;
            boolean $i$f$flatMap22 = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
                String it = (String)element$iv$iv2;
                boolean bl = false;
                String[] stringArray = new String[]{","};
                Iterable list$iv$iv = StringsKt.split$default((CharSequence)it, stringArray, false, 0, 6, null);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            Iterable $i$f$flatMap22 = (List)destination$iv$iv;
            boolean $i$f$filter22 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv3 : $this$filterTo$iv$iv2) {
                String it = (String)element$iv$iv3;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank(it);
                if (!bl2) continue;
                destination$iv$iv2.add(element$iv$iv3);
            }
            Iterable $i$f$filter22 = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            destination$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            element$iv$iv3 = $this$mapTo$iv$iv.iterator();
            while (element$iv$iv3.hasNext()) {
                void it;
                Object item$iv$iv = element$iv$iv3.next();
                String bl = (String)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl3 = false;
                collection.add(TextKt.toLowerCasePreservingASCIIRules(((Object)StringsKt.trim((CharSequence)it)).toString()));
            }
            list = (List)destination$iv$iv3;
        } else {
            list = requestHeaders2 = CollectionsKt.emptyList();
        }
        if (!CORSKt.corsCheckRequestMethod($this$respondPreflight, methods2) || !CORSKt.corsCheckRequestHeaders(requestHeaders2, allHeadersSet, headerPredicates)) {
            void $this$respond$iv2;
            ApplicationCall applicationCall = $this$respondPreflight;
            HttpStatusCode message$iv = HttpStatusCode.Companion.getForbidden();
            boolean $i$f$respondWithType = false;
            if (!(message$iv instanceof OutgoingContent) && !(message$iv instanceof byte[])) {
                boolean $i$f$typeInfo = false;
                KType kType$iv$iv = Reflection.typeOf(HttpStatusCode.class);
                Type reifiedType$iv$iv = TypesJVMKt.getJavaType(kType$iv$iv);
                ResponseTypeKt.setResponseType($this$respond$iv2.getResponse(), TypeInfoJvmKt.typeInfoImpl(reifiedType$iv$iv, Reflection.getOrCreateKotlinClass(HttpStatusCode.class), kType$iv$iv));
            }
            Object object = $this$respond$iv2.getResponse().getPipeline().execute($this$respond$iv2, (Object)message$iv, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        CORSKt.accessControlAllowOrigin($this$respondPreflight, origin2, allowsAnyHost, allowCredentials);
        CORSKt.accessControlAllowCredentials($this$respondPreflight, allowCredentials);
        if (((CharSequence)methodsListHeaderValue).length() > 0) {
            ApplicationResponsePropertiesKt.header($this$respondPreflight.getResponse(), HttpHeaders.INSTANCE.getAccessControlAllowMethods(), methodsListHeaderValue);
        }
        Iterable message$iv = requestHeaders2;
        boolean $i$f$filter32 = false;
        void $i$f$typeInfo = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String header = (String)element$iv$iv;
            boolean bl = false;
            if (!CORSKt.headerMatchesAPredicate(header, headerPredicates)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List requestHeadersMatchingPrefix = (List)destination$iv$iv;
        String headersListHeaderValue = CollectionsKt.joinToString$default(CollectionsKt.sorted(CollectionsKt.plus((Collection)headersList, (Iterable)requestHeadersMatchingPrefix)), ", ", null, null, 0, null, null, 62, null);
        ApplicationResponsePropertiesKt.header($this$respondPreflight.getResponse(), HttpHeaders.INSTANCE.getAccessControlAllowHeaders(), headersListHeaderValue);
        CORSKt.accessControlMaxAge($this$respondPreflight, maxAgeHeaderValue);
        ApplicationCall $i$f$filter32 = $this$respondPreflight;
        HttpStatusCode message$iv2 = HttpStatusCode.Companion.getOK();
        boolean $i$f$respondWithType = false;
        if (!(message$iv2 instanceof OutgoingContent) && !(message$iv2 instanceof byte[])) {
            boolean $i$f$typeInfo2 = false;
            KType kType$iv$iv = Reflection.typeOf(HttpStatusCode.class);
            Type reifiedType$iv$iv = TypesJVMKt.getJavaType(kType$iv$iv);
            ResponseTypeKt.setResponseType($this$respond$iv.getResponse(), TypeInfoJvmKt.typeInfoImpl(reifiedType$iv$iv, Reflection.getOrCreateKotlinClass(HttpStatusCode.class), kType$iv$iv));
        }
        Object object = $this$respond$iv.getResponse().getPipeline().execute($this$respond$iv, (Object)message$iv2, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final void accessControlAllowOrigin(ApplicationCall $this$accessControlAllowOrigin, String origin2, boolean allowsAnyHost, boolean allowCredentials) {
        if (allowsAnyHost && !allowCredentials) {
            ApplicationResponsePropertiesKt.header($this$accessControlAllowOrigin.getResponse(), HttpHeaders.INSTANCE.getAccessControlAllowOrigin(), "*");
        } else {
            ApplicationResponsePropertiesKt.header($this$accessControlAllowOrigin.getResponse(), HttpHeaders.INSTANCE.getAccessControlAllowOrigin(), origin2);
        }
    }

    private static final void corsVary(ApplicationCall $this$corsVary) {
        String vary = $this$corsVary.getResponse().getHeaders().get(HttpHeaders.INSTANCE.getVary());
        if (vary == null) {
            ApplicationResponsePropertiesKt.header($this$corsVary.getResponse(), HttpHeaders.INSTANCE.getVary(), HttpHeaders.INSTANCE.getOrigin());
        } else {
            ApplicationResponsePropertiesKt.header($this$corsVary.getResponse(), HttpHeaders.INSTANCE.getVary(), vary + ", " + HttpHeaders.INSTANCE.getOrigin());
        }
    }

    private static final void accessControlAllowCredentials(ApplicationCall $this$accessControlAllowCredentials, boolean allowCredentials) {
        if (allowCredentials) {
            ApplicationResponsePropertiesKt.header($this$accessControlAllowCredentials.getResponse(), HttpHeaders.INSTANCE.getAccessControlAllowCredentials(), "true");
        }
    }

    private static final void accessControlMaxAge(ApplicationCall $this$accessControlMaxAge, String maxAgeHeaderValue) {
        if (maxAgeHeaderValue != null) {
            ApplicationResponsePropertiesKt.header($this$accessControlMaxAge.getResponse(), HttpHeaders.INSTANCE.getAccessControlMaxAge(), maxAgeHeaderValue);
        }
    }

    private static final boolean isSameOrigin(String origin2, RequestConnectionPoint point, Regex numberRegex) {
        String requestOrigin = point.getScheme() + "://" + point.getHost() + ':' + point.getPort();
        return Intrinsics.areEqual(CORSKt.normalizeOrigin(requestOrigin, numberRegex), CORSKt.normalizeOrigin(origin2, numberRegex));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean corsCheckOrigins(String origin2, boolean allowsAnyHost, Set<String> hostsNormalized, Set<Pair<String, String>> hostsWithWildcard, List<? extends Function1<? super String, Boolean>> originPredicates, Regex numberRegex) {
        Function1 it;
        boolean bl;
        String normalizedOrigin = CORSKt.normalizeOrigin(origin2, numberRegex);
        if (allowsAnyHost) return true;
        if (hostsNormalized.contains(normalizedOrigin)) return true;
        Iterable $this$any$iv = hostsWithWildcard;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl2 = false;
                String prefix = (String)pair.component1();
                String suffix = (String)pair.component2();
                if (StringsKt.startsWith$default(normalizedOrigin, prefix, false, 2, null) && StringsKt.endsWith$default(normalizedOrigin, suffix, false, 2, null)) {
                    return true;
                }
                boolean bl3 = false;
                if (!bl3) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        $this$any$iv = originPredicates;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return false;
            element$iv = iterator2.next();
            it = (Function1)element$iv;
            boolean bl4 = false;
        } while (!((Boolean)it.invoke(origin2)).booleanValue());
        return true;
    }

    private static final boolean corsCheckRequestHeaders(List<String> requestHeaders2, Set<String> allHeadersSet, List<? extends Function1<? super String, Boolean>> headerPredicates) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = requestHeaders2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String header = (String)element$iv;
                    boolean bl2 = false;
                    if (allHeadersSet.contains(header) || CORSKt.headerMatchesAPredicate(header, headerPredicates)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean headerMatchesAPredicate(String header, List<? extends Function1<? super String, Boolean>> headerPredicates) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = headerPredicates;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Function1 it = (Function1)element$iv;
                    boolean bl2 = false;
                    if (!((Boolean)it.invoke(header)).booleanValue()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean corsCheckCurrentMethod(ApplicationCall $this$corsCheckCurrentMethod, Set<HttpMethod> methods2) {
        return methods2.contains(ApplicationRequestPropertiesKt.getHttpMethod($this$corsCheckCurrentMethod.getRequest()));
    }

    private static final boolean corsCheckRequestMethod(ApplicationCall $this$corsCheckRequestMethod, Set<HttpMethod> methods2) {
        HttpMethod httpMethod;
        String string = ApplicationRequestPropertiesKt.header($this$corsCheckRequestMethod.getRequest(), HttpHeaders.INSTANCE.getAccessControlRequestMethod());
        if (string != null) {
            String it = string;
            boolean bl = false;
            httpMethod = new HttpMethod(it);
        } else {
            httpMethod = null;
        }
        HttpMethod requestMethod = httpMethod;
        return requestMethod != null && methods2.contains(requestMethod);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object respondCorsFailed(ApplicationCall $this$respondCorsFailed, Continuation<? super Unit> $completion) {
        void $this$respond$iv;
        ApplicationCall applicationCall = $this$respondCorsFailed;
        HttpStatusCode message$iv = HttpStatusCode.Companion.getForbidden();
        boolean $i$f$respondWithType = false;
        if (!(message$iv instanceof OutgoingContent) && !(message$iv instanceof byte[])) {
            boolean $i$f$typeInfo = false;
            KType kType$iv$iv = Reflection.typeOf(HttpStatusCode.class);
            Type reifiedType$iv$iv = TypesJVMKt.getJavaType(kType$iv$iv);
            ResponseTypeKt.setResponseType($this$respond$iv.getResponse(), TypeInfoJvmKt.typeInfoImpl(reifiedType$iv$iv, Reflection.getOrCreateKotlinClass(HttpStatusCode.class), kType$iv$iv));
        }
        Object object = $this$respond$iv.getResponse().getPipeline().execute($this$respond$iv, (Object)message$iv, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isValidOrigin(String origin2) {
        int index;
        int n;
        if (((CharSequence)origin2).length() == 0) {
            return false;
        }
        boolean bl = false;
        if (bl) {
            return false;
        }
        if (Intrinsics.areEqual(origin2, "null")) {
            return true;
        }
        if (StringsKt.contains$default((CharSequence)origin2, "%", false, 2, null)) {
            return false;
        }
        int protoDelimiter = StringsKt.indexOf$default((CharSequence)origin2, "://", 0, false, 6, null);
        if (protoDelimiter <= 0) {
            return false;
        }
        if (!Character.isLetter(origin2.charAt(0))) return false;
        CharSequence $this$all$iv = origin2.subSequence(0, protoDelimiter);
        boolean $i$f$all = false;
        for (n = 0; n < $this$all$iv.length(); ++n) {
            char element$iv;
            char ch2 = element$iv = $this$all$iv.charAt(n);
            boolean bl2 = false;
            if (!Character.isLetter(ch2) && !Character.isDigit(ch2) && ch2 != '-' && ch2 != '+') {
                if (ch2 != '.') return false;
            }
            boolean bl3 = true;
            if (bl3) continue;
            return false;
        }
        boolean bl4 = true;
        if (!bl4) return false;
        boolean bl5 = true;
        boolean protoValid = bl5;
        if (!protoValid) {
            return false;
        }
        int portIndex = origin2.length();
        n = origin2.length();
        for (index = protoDelimiter + 3; index < n; ++index) {
            char ch3 = origin2.charAt(index);
            if (ch3 == ':' || ch3 == '/') {
                portIndex = index + 1;
                break;
            }
            if (ch3 != '?') continue;
            return false;
        }
        index = portIndex;
        n = origin2.length();
        while (index < n) {
            if (!Character.isDigit(origin2.charAt(index))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    private static final String normalizeOrigin(String origin2, Regex numberRegex) {
        String string;
        if (Intrinsics.areEqual(origin2, "null") || Intrinsics.areEqual(origin2, "*")) {
            string = origin2;
        } else {
            StringBuilder stringBuilder;
            StringBuilder $this$normalizeOrigin_u24lambda_u2d21 = stringBuilder = new StringBuilder(origin2.length());
            boolean bl = false;
            $this$normalizeOrigin_u24lambda_u2d21.append(origin2);
            if (!numberRegex.matches(StringsKt.substringAfterLast(origin2, ":", ""))) {
                String port2;
                String string2 = StringsKt.substringBefore$default(origin2, ':', null, 2, null);
                String string3 = Intrinsics.areEqual(string2, "http") ? "80" : (port2 = Intrinsics.areEqual(string2, "https") ? "443" : null);
                if (port2 != null) {
                    $this$normalizeOrigin_u24lambda_u2d21.append(':');
                    $this$normalizeOrigin_u24lambda_u2d21.append(port2);
                }
            }
            String string4 = stringBuilder.toString();
            string = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "StringBuilder(origin.len\u2026       }\n    }.toString()");
        }
        return string;
    }

    public static final /* synthetic */ void access$corsVary(ApplicationCall $receiver) {
        CORSKt.corsVary($receiver);
    }

    public static final /* synthetic */ OriginCheckResult access$checkOrigin(String origin2, RequestConnectionPoint point, boolean allowSameOrigin, boolean allowsAnyHost, Set hostsNormalized, Set hostsWithWildcard, List originPredicates, Regex numberRegex) {
        return CORSKt.checkOrigin(origin2, point, allowSameOrigin, allowsAnyHost, hostsNormalized, hostsWithWildcard, originPredicates, numberRegex);
    }

    public static final /* synthetic */ Object access$respondCorsFailed(ApplicationCall $receiver, Continuation $completion) {
        return CORSKt.respondCorsFailed($receiver, $completion);
    }

    public static final /* synthetic */ Object access$respondPreflight(ApplicationCall $receiver, String origin2, String methodsListHeaderValue, List headersList, Set methods2, boolean allowsAnyHost, boolean allowCredentials, String maxAgeHeaderValue, List headerPredicates, Set allHeadersSet, Continuation $completion) {
        return CORSKt.respondPreflight($receiver, origin2, methodsListHeaderValue, headersList, methods2, allowsAnyHost, allowCredentials, maxAgeHeaderValue, headerPredicates, allHeadersSet, $completion);
    }

    public static final /* synthetic */ boolean access$corsCheckCurrentMethod(ApplicationCall $receiver, Set methods2) {
        return CORSKt.corsCheckCurrentMethod($receiver, methods2);
    }

    public static final /* synthetic */ void access$accessControlAllowOrigin(ApplicationCall $receiver, String origin2, boolean allowsAnyHost, boolean allowCredentials) {
        CORSKt.accessControlAllowOrigin($receiver, origin2, allowsAnyHost, allowCredentials);
    }

    public static final /* synthetic */ void access$accessControlAllowCredentials(ApplicationCall $receiver, boolean allowCredentials) {
        CORSKt.accessControlAllowCredentials($receiver, allowCredentials);
    }
}

