/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.http.Parameters;
import io.ktor.http.ParametersBuilder;
import io.ktor.http.ParametersKt;
import io.ktor.server.plugins.OriginConnectionPointKt;
import io.ktor.server.routing.RouteSelector;
import io.ktor.server.routing.RouteSelectorEvaluation;
import io.ktor.server.routing.RoutingResolveContext;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u00c6\u0003J9\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\bH\u0016J\t\u0010\u001b\u001a\u00020\bH\u00d6\u0001J\b\u0010\u001c\u001a\u00020\u0004H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lio/ktor/server/routing/HostRouteSelector;", "Lio/ktor/server/routing/RouteSelector;", "hostList", "", "", "hostPatterns", "Lkotlin/text/Regex;", "portsList", "", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getHostList", "()Ljava/util/List;", "getHostPatterns", "getPortsList", "component1", "component2", "component3", "copy", "equals", "", "other", "", "evaluate", "Lio/ktor/server/routing/RouteSelectorEvaluation;", "context", "Lio/ktor/server/routing/RoutingResolveContext;", "segmentIndex", "hashCode", "toString", "Companion", "ktor-server-core"})
public final class HostRouteSelector
extends RouteSelector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> hostList;
    @NotNull
    private final List<Regex> hostPatterns;
    @NotNull
    private final List<Integer> portsList;
    @NotNull
    public static final String HostNameParameter = "$RequestHost";
    @NotNull
    public static final String PortParameter = "$RequestPort";

    public HostRouteSelector(@NotNull List<String> hostList, @NotNull List<Regex> hostPatterns, @NotNull List<Integer> portsList) {
        Intrinsics.checkNotNullParameter(hostList, "hostList");
        Intrinsics.checkNotNullParameter(hostPatterns, "hostPatterns");
        Intrinsics.checkNotNullParameter(portsList, "portsList");
        this.hostList = hostList;
        this.hostPatterns = hostPatterns;
        this.portsList = portsList;
        if (!(!((Collection)this.hostList).isEmpty() || !((Collection)this.hostPatterns).isEmpty() || !((Collection)this.portsList).isEmpty())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final List<String> getHostList() {
        return this.hostList;
    }

    @NotNull
    public final List<Regex> getHostPatterns() {
        return this.hostPatterns;
    }

    @NotNull
    public final List<Integer> getPortsList() {
        return this.portsList;
    }

    @Override
    @NotNull
    public RouteSelectorEvaluation evaluate(@NotNull RoutingResolveContext context, int segmentIndex) {
        ParametersBuilder parametersBuilder;
        Intrinsics.checkNotNullParameter(context, "context");
        String requestHost = OriginConnectionPointKt.getOrigin(context.getCall().getRequest()).getHost();
        int requestPort = OriginConnectionPointKt.getOrigin(context.getCall().getRequest()).getPort();
        if (!((Collection)this.hostList).isEmpty() || !((Collection)this.hostPatterns).isEmpty()) {
            boolean matches2;
            boolean matches1;
            block8: {
                boolean bl;
                matches1 = this.hostList.contains(requestHost);
                if (!matches1) {
                    Iterable $this$any$iv = this.hostPatterns;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Regex it = (Regex)element$iv;
                            boolean bl2 = false;
                            if (!it.matches(requestHost)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                } else {
                    bl = matches2 = false;
                }
            }
            if (!matches1 && !matches2) {
                return RouteSelectorEvaluation.Companion.getFailed();
            }
        }
        if (!((Collection)this.portsList).isEmpty() && !this.portsList.contains(requestPort)) {
            return RouteSelectorEvaluation.Companion.getFailed();
        }
        Parameters.Companion this_$iv = Parameters.Companion;
        boolean $i$f$build = false;
        ParametersBuilder $this$evaluate_u24lambda_u2d1 = parametersBuilder = ParametersKt.ParametersBuilder$default(0, 1, null);
        boolean bl = false;
        $this$evaluate_u24lambda_u2d1.append(HostNameParameter, requestHost);
        $this$evaluate_u24lambda_u2d1.append(PortParameter, String.valueOf(requestPort));
        Parameters params = parametersBuilder.build();
        return new RouteSelectorEvaluation.Success(1.0, params, 0, 4, null);
    }

    @NotNull
    public String toString() {
        return "" + '(' + this.hostList + ", " + this.hostPatterns + ", " + this.portsList + ')';
    }

    @NotNull
    public final List<String> component1() {
        return this.hostList;
    }

    @NotNull
    public final List<Regex> component2() {
        return this.hostPatterns;
    }

    @NotNull
    public final List<Integer> component3() {
        return this.portsList;
    }

    @NotNull
    public final HostRouteSelector copy(@NotNull List<String> hostList, @NotNull List<Regex> hostPatterns, @NotNull List<Integer> portsList) {
        Intrinsics.checkNotNullParameter(hostList, "hostList");
        Intrinsics.checkNotNullParameter(hostPatterns, "hostPatterns");
        Intrinsics.checkNotNullParameter(portsList, "portsList");
        return new HostRouteSelector(hostList, hostPatterns, portsList);
    }

    public static /* synthetic */ HostRouteSelector copy$default(HostRouteSelector hostRouteSelector, List list, List list2, List list3, int n, Object object) {
        if ((n & 1) != 0) {
            list = hostRouteSelector.hostList;
        }
        if ((n & 2) != 0) {
            list2 = hostRouteSelector.hostPatterns;
        }
        if ((n & 4) != 0) {
            list3 = hostRouteSelector.portsList;
        }
        return hostRouteSelector.copy(list, list2, list3);
    }

    public int hashCode() {
        int result2 = ((Object)this.hostList).hashCode();
        result2 = result2 * 31 + ((Object)this.hostPatterns).hashCode();
        result2 = result2 * 31 + ((Object)this.portsList).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HostRouteSelector)) {
            return false;
        }
        HostRouteSelector hostRouteSelector = (HostRouteSelector)other;
        if (!Intrinsics.areEqual(this.hostList, hostRouteSelector.hostList)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.hostPatterns, hostRouteSelector.hostPatterns)) {
            return false;
        }
        return Intrinsics.areEqual(this.portsList, hostRouteSelector.portsList);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/ktor/server/routing/HostRouteSelector$Companion;", "", "()V", "HostNameParameter", "", "PortParameter", "ktor-server-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

