/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.server.application.ApplicationCall;
import io.ktor.server.routing.Route;
import io.ktor.server.routing.RoutingResolveResult;
import io.ktor.server.routing.RoutingResolveTrace;
import io.ktor.server.routing.RoutingResolveTraceEntry;
import io.ktor.server.routing.Stack;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005J\u0016\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u0006J\u001e\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u000bJ\u0010\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u0010H\u0002J\u000e\u0010\"\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u000bJ\u001e\u0010#\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u000bJ\b\u0010$\u001a\u00020\u0006H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/ktor/server/routing/RoutingResolveTrace;", "", "call", "Lio/ktor/server/application/ApplicationCall;", "segments", "", "", "(Lio/ktor/server/application/ApplicationCall;Ljava/util/List;)V", "getCall", "()Lio/ktor/server/application/ApplicationCall;", "finalResult", "Lio/ktor/server/routing/RoutingResolveResult;", "resolveCandidates", "", "Lio/ktor/server/routing/RoutingResolveResult$Success;", "routing", "Lio/ktor/server/routing/RoutingResolveTraceEntry;", "getSegments", "()Ljava/util/List;", "stack", "Lio/ktor/server/routing/Stack;", "addCandidate", "", "trait", "begin", "route", "Lio/ktor/server/routing/Route;", "segmentIndex", "", "buildText", "finish", "result", "register", "entry", "registerFinalResult", "skip", "toString", "ktor-server-core"})
public final class RoutingResolveTrace {
    @NotNull
    private final ApplicationCall call;
    @NotNull
    private final List<String> segments;
    @NotNull
    private final Stack<RoutingResolveTraceEntry> stack;
    @Nullable
    private RoutingResolveTraceEntry routing;
    private RoutingResolveResult finalResult;
    @NotNull
    private final List<List<RoutingResolveResult.Success>> resolveCandidates;

    public RoutingResolveTrace(@NotNull ApplicationCall call, @NotNull List<String> segments2) {
        Intrinsics.checkNotNullParameter(call, "call");
        Intrinsics.checkNotNullParameter(segments2, "segments");
        this.call = call;
        this.segments = segments2;
        this.stack = new Stack();
        this.resolveCandidates = new ArrayList();
    }

    @NotNull
    public final ApplicationCall getCall() {
        return this.call;
    }

    @NotNull
    public final List<String> getSegments() {
        return this.segments;
    }

    private final void register(RoutingResolveTraceEntry entry) {
        if (this.stack.empty()) {
            this.routing = entry;
        } else {
            this.stack.peek().append(entry);
        }
    }

    public final void begin(@NotNull Route route, int segmentIndex) {
        Intrinsics.checkNotNullParameter(route, "route");
        this.stack.push(new RoutingResolveTraceEntry(route, segmentIndex, null, 4, null));
    }

    public final void finish(@NotNull Route route, int segmentIndex, @NotNull RoutingResolveResult result2) {
        Intrinsics.checkNotNullParameter(route, "route");
        Intrinsics.checkNotNullParameter(result2, "result");
        RoutingResolveTraceEntry entry = this.stack.pop();
        if (!Intrinsics.areEqual(entry.getRoute(), route)) {
            boolean $i$a$-require-RoutingResolveTrace$finish$32 = false;
            String $i$a$-require-RoutingResolveTrace$finish$32 = "end should be called for the same route as begin";
            throw new IllegalArgumentException($i$a$-require-RoutingResolveTrace$finish$32.toString());
        }
        if (!(entry.getSegmentIndex() == segmentIndex)) {
            boolean bl = false;
            String string = "end should be called for the same segmentIndex as begin";
            throw new IllegalArgumentException(string.toString());
        }
        entry.setResult(result2);
        this.register(entry);
    }

    public final void skip(@NotNull Route route, int segmentIndex, @NotNull RoutingResolveResult result2) {
        Intrinsics.checkNotNullParameter(route, "route");
        Intrinsics.checkNotNullParameter(result2, "result");
        this.register(new RoutingResolveTraceEntry(route, segmentIndex, result2));
    }

    public final void registerFinalResult(@NotNull RoutingResolveResult result2) {
        Intrinsics.checkNotNullParameter(result2, "result");
        this.finalResult = result2;
    }

    @NotNull
    public String toString() {
        return "Trace for " + this.segments;
    }

    @NotNull
    public final String buildText() {
        StringBuilder stringBuilder;
        StringBuilder $this$buildText_u24lambda_u2d2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$buildText_u24lambda_u2d2.append(this.toString());
        Intrinsics.checkNotNullExpressionValue(stringBuilder2, "append(value)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder2.append('\n'), "append('\\n')");
        RoutingResolveTraceEntry routingResolveTraceEntry = this.routing;
        if (routingResolveTraceEntry != null) {
            routingResolveTraceEntry.buildText($this$buildText_u24lambda_u2d2, 0);
        }
        if (this.finalResult != null) {
            StringBuilder stringBuilder3 = $this$buildText_u24lambda_u2d2.append("Matched routes:");
            Intrinsics.checkNotNullExpressionValue(stringBuilder3, "append(value)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder3.append('\n'), "append('\\n')");
            if (this.resolveCandidates.isEmpty()) {
                StringBuilder stringBuilder4 = $this$buildText_u24lambda_u2d2.append("  No results");
                Intrinsics.checkNotNullExpressionValue(stringBuilder4, "append(value)");
                Intrinsics.checkNotNullExpressionValue(stringBuilder4.append('\n'), "append('\\n')");
            } else {
                StringBuilder stringBuilder5 = $this$buildText_u24lambda_u2d2.append(CollectionsKt.joinToString$default(this.resolveCandidates, "\n", null, null, 0, null, buildText.1.2.INSTANCE, 30, null));
                Intrinsics.checkNotNullExpressionValue(stringBuilder5, "append(value)");
                Intrinsics.checkNotNullExpressionValue(stringBuilder5.append('\n'), "append('\\n')");
            }
            StringBuilder stringBuilder6 = $this$buildText_u24lambda_u2d2.append("Route resolve result:");
            Intrinsics.checkNotNullExpressionValue(stringBuilder6, "append(value)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder6.append('\n'), "append('\\n')");
            StringBuilder stringBuilder7 = new StringBuilder().append("  ");
            RoutingResolveResult routingResolveResult = this.finalResult;
            if (routingResolveResult == null) {
                Intrinsics.throwUninitializedPropertyAccessException("finalResult");
                routingResolveResult = null;
            }
            $this$buildText_u24lambda_u2d2.append(stringBuilder7.append(routingResolveResult).toString());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final void addCandidate(@NotNull List<RoutingResolveResult.Success> trait) {
        Intrinsics.checkNotNullParameter(trait, "trait");
        int n = trait.size();
        ArrayList<RoutingResolveResult.Success> arrayList = new ArrayList<RoutingResolveResult.Success>(n);
        int n2 = 0;
        while (n2 < n) {
            void it;
            int n3;
            int n4 = n3 = n2++;
            ArrayList<RoutingResolveResult.Success> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(trait.get((int)it));
        }
        List candidate = arrayList;
        this.resolveCandidates.add(candidate);
    }
}

