/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@ChannelHandler.Sharable
public abstract class ChannelInitializer<C extends Channel>
extends ChannelInboundHandlerAdapter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelInitializer.class);
    private final Set<ChannelHandlerContext> initMap = Collections.newSetFromMap(new ConcurrentHashMap());

    protected abstract void initChannel(C var1) throws Exception;

    @Override
    public final void channelRegistered(ChannelHandlerContext ctx2) throws Exception {
        if (this.initChannel(ctx2)) {
            ctx2.pipeline().fireChannelRegistered();
            this.removeState(ctx2);
        } else {
            ctx2.fireChannelRegistered();
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx2, Throwable cause) throws Exception {
        if (logger.isWarnEnabled()) {
            logger.warn("Failed to initialize a channel. Closing: " + ctx2.channel(), cause);
        }
        ctx2.close();
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx2) throws Exception {
        if (ctx2.channel().isRegistered() && this.initChannel(ctx2)) {
            this.removeState(ctx2);
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx2) throws Exception {
        this.initMap.remove(ctx2);
    }

    private boolean initChannel(ChannelHandlerContext ctx2) throws Exception {
        if (this.initMap.add(ctx2)) {
            try {
                this.initChannel(ctx2.channel());
            }
            catch (Throwable cause) {
                this.exceptionCaught(ctx2, cause);
            }
            finally {
                if (!ctx2.isRemoved()) {
                    ctx2.pipeline().remove(this);
                }
            }
            return true;
        }
        return false;
    }

    private void removeState(final ChannelHandlerContext ctx2) {
        if (ctx2.isRemoved()) {
            this.initMap.remove(ctx2);
        } else {
            ctx2.executor().execute(new Runnable(){

                @Override
                public void run() {
                    ChannelInitializer.this.initMap.remove(ctx2);
                }
            });
        }
    }
}

