/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.local;

import io.netty.channel.Channel;
import io.netty.util.internal.ObjectUtil;
import java.net.SocketAddress;

public final class LocalAddress
extends SocketAddress
implements Comparable<LocalAddress> {
    private static final long serialVersionUID = 4644331421130916435L;
    public static final LocalAddress ANY = new LocalAddress("ANY");
    private final String id;
    private final String strVal;

    LocalAddress(Channel channel2) {
        StringBuilder buf2 = new StringBuilder(16);
        buf2.append("local:E");
        buf2.append(Long.toHexString((long)channel2.hashCode() & 0xFFFFFFFFL | 0x100000000L));
        buf2.setCharAt(7, ':');
        this.id = buf2.substring(6);
        this.strVal = buf2.toString();
    }

    public LocalAddress(String id2) {
        this.id = ObjectUtil.checkNonEmptyAfterTrim(id2, "id").toLowerCase();
        this.strVal = "local:" + this.id;
    }

    public String id() {
        return this.id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof LocalAddress)) {
            return false;
        }
        return this.id.equals(((LocalAddress)o).id);
    }

    @Override
    public int compareTo(LocalAddress o) {
        return this.id.compareTo(o.id);
    }

    public String toString() {
        return this.strVal;
    }
}

