/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.internal.TypeParameterMatcher;
import java.util.List;

public abstract class ByteToMessageCodec<I>
extends ChannelDuplexHandler {
    private final TypeParameterMatcher outboundMsgMatcher;
    private final MessageToByteEncoder<I> encoder;
    private final ByteToMessageDecoder decoder = new ByteToMessageDecoder(){

        @Override
        public void decode(ChannelHandlerContext ctx2, ByteBuf in, List<Object> out2) throws Exception {
            ByteToMessageCodec.this.decode(ctx2, in, out2);
        }

        @Override
        protected void decodeLast(ChannelHandlerContext ctx2, ByteBuf in, List<Object> out2) throws Exception {
            ByteToMessageCodec.this.decodeLast(ctx2, in, out2);
        }
    };

    protected ByteToMessageCodec() {
        this(true);
    }

    protected ByteToMessageCodec(Class<? extends I> outboundMessageType) {
        this(outboundMessageType, true);
    }

    protected ByteToMessageCodec(boolean preferDirect) {
        this.ensureNotSharable();
        this.outboundMsgMatcher = TypeParameterMatcher.find(this, ByteToMessageCodec.class, "I");
        this.encoder = new Encoder(preferDirect);
    }

    protected ByteToMessageCodec(Class<? extends I> outboundMessageType, boolean preferDirect) {
        this.ensureNotSharable();
        this.outboundMsgMatcher = TypeParameterMatcher.get(outboundMessageType);
        this.encoder = new Encoder(preferDirect);
    }

    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return this.outboundMsgMatcher.match(msg);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx2, Object msg) throws Exception {
        this.decoder.channelRead(ctx2, msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx2, Object msg, ChannelPromise promise) throws Exception {
        this.encoder.write(ctx2, msg, promise);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx2) throws Exception {
        this.decoder.channelReadComplete(ctx2);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx2) throws Exception {
        this.decoder.channelInactive(ctx2);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx2) throws Exception {
        try {
            this.decoder.handlerAdded(ctx2);
        }
        finally {
            this.encoder.handlerAdded(ctx2);
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx2) throws Exception {
        try {
            this.decoder.handlerRemoved(ctx2);
        }
        finally {
            this.encoder.handlerRemoved(ctx2);
        }
    }

    protected abstract void encode(ChannelHandlerContext var1, I var2, ByteBuf var3) throws Exception;

    protected abstract void decode(ChannelHandlerContext var1, ByteBuf var2, List<Object> var3) throws Exception;

    protected void decodeLast(ChannelHandlerContext ctx2, ByteBuf in, List<Object> out2) throws Exception {
        if (in.isReadable()) {
            this.decode(ctx2, in, out2);
        }
    }

    private final class Encoder
    extends MessageToByteEncoder<I> {
        Encoder(boolean preferDirect) {
            super(preferDirect);
        }

        @Override
        public boolean acceptOutboundMessage(Object msg) throws Exception {
            return ByteToMessageCodec.this.acceptOutboundMessage(msg);
        }

        @Override
        protected void encode(ChannelHandlerContext ctx2, I msg, ByteBuf out2) throws Exception {
            ByteToMessageCodec.this.encode(ctx2, msg, out2);
        }
    }
}

