/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.util.internal.ObjectUtil;
import java.util.List;

public class DatagramPacketDecoder
extends MessageToMessageDecoder<DatagramPacket> {
    private final MessageToMessageDecoder<ByteBuf> decoder;

    public DatagramPacketDecoder(MessageToMessageDecoder<ByteBuf> decoder) {
        this.decoder = ObjectUtil.checkNotNull(decoder, "decoder");
    }

    @Override
    public boolean acceptInboundMessage(Object msg) throws Exception {
        if (msg instanceof DatagramPacket) {
            return this.decoder.acceptInboundMessage(((DatagramPacket)msg).content());
        }
        return false;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx2, DatagramPacket msg, List<Object> out2) throws Exception {
        this.decoder.decode(ctx2, (ByteBuf)msg.content(), out2);
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx2) throws Exception {
        this.decoder.channelRegistered(ctx2);
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext ctx2) throws Exception {
        this.decoder.channelUnregistered(ctx2);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx2) throws Exception {
        this.decoder.channelActive(ctx2);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx2) throws Exception {
        this.decoder.channelInactive(ctx2);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx2) throws Exception {
        this.decoder.channelReadComplete(ctx2);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx2, Object evt) throws Exception {
        this.decoder.userEventTriggered(ctx2, evt);
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext ctx2) throws Exception {
        this.decoder.channelWritabilityChanged(ctx2);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx2, Throwable cause) throws Exception {
        this.decoder.exceptionCaught(ctx2, cause);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx2) throws Exception {
        this.decoder.handlerAdded(ctx2);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx2) throws Exception {
        this.decoder.handlerRemoved(ctx2);
    }

    @Override
    public boolean isSharable() {
        return this.decoder.isSharable();
    }
}

