/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;

public class DatagramPacketEncoder<M>
extends MessageToMessageEncoder<AddressedEnvelope<M, InetSocketAddress>> {
    private final MessageToMessageEncoder<? super M> encoder;

    public DatagramPacketEncoder(MessageToMessageEncoder<? super M> encoder2) {
        this.encoder = ObjectUtil.checkNotNull(encoder2, "encoder");
    }

    @Override
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        if (super.acceptOutboundMessage(msg)) {
            AddressedEnvelope envelope = (AddressedEnvelope)msg;
            return this.encoder.acceptOutboundMessage(envelope.content()) && (envelope.sender() instanceof InetSocketAddress || envelope.sender() == null) && envelope.recipient() instanceof InetSocketAddress;
        }
        return false;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx2, AddressedEnvelope<M, InetSocketAddress> msg, List<Object> out2) throws Exception {
        assert (out2.isEmpty());
        this.encoder.encode(ctx2, msg.content(), out2);
        if (out2.size() != 1) {
            throw new EncoderException(StringUtil.simpleClassName(this.encoder) + " must produce only one message.");
        }
        Object content2 = out2.get(0);
        if (!(content2 instanceof ByteBuf)) {
            throw new EncoderException(StringUtil.simpleClassName(this.encoder) + " must produce only ByteBuf.");
        }
        out2.set(0, new DatagramPacket((ByteBuf)content2, msg.recipient(), msg.sender()));
    }

    @Override
    public void bind(ChannelHandlerContext ctx2, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        this.encoder.bind(ctx2, localAddress, promise);
    }

    @Override
    public void connect(ChannelHandlerContext ctx2, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        this.encoder.connect(ctx2, remoteAddress, localAddress, promise);
    }

    @Override
    public void disconnect(ChannelHandlerContext ctx2, ChannelPromise promise) throws Exception {
        this.encoder.disconnect(ctx2, promise);
    }

    @Override
    public void close(ChannelHandlerContext ctx2, ChannelPromise promise) throws Exception {
        this.encoder.close(ctx2, promise);
    }

    @Override
    public void deregister(ChannelHandlerContext ctx2, ChannelPromise promise) throws Exception {
        this.encoder.deregister(ctx2, promise);
    }

    @Override
    public void read(ChannelHandlerContext ctx2) throws Exception {
        this.encoder.read(ctx2);
    }

    @Override
    public void flush(ChannelHandlerContext ctx2) throws Exception {
        this.encoder.flush(ctx2);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx2) throws Exception {
        this.encoder.handlerAdded(ctx2);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx2) throws Exception {
        this.encoder.handlerRemoved(ctx2);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx2, Throwable cause) throws Exception {
        this.encoder.exceptionCaught(ctx2, cause);
    }

    @Override
    public boolean isSharable() {
        return this.encoder.isSharable();
    }
}

