/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.internal.TypeParameterMatcher;

public abstract class MessageToByteEncoder<I>
extends ChannelOutboundHandlerAdapter {
    private final TypeParameterMatcher matcher;
    private final boolean preferDirect;

    protected MessageToByteEncoder() {
        this(true);
    }

    protected MessageToByteEncoder(Class<? extends I> outboundMessageType) {
        this(outboundMessageType, true);
    }

    protected MessageToByteEncoder(boolean preferDirect) {
        this.matcher = TypeParameterMatcher.find(this, MessageToByteEncoder.class, "I");
        this.preferDirect = preferDirect;
    }

    protected MessageToByteEncoder(Class<? extends I> outboundMessageType, boolean preferDirect) {
        this.matcher = TypeParameterMatcher.get(outboundMessageType);
        this.preferDirect = preferDirect;
    }

    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return this.matcher.match(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ChannelHandlerContext ctx2, Object msg, ChannelPromise promise) throws Exception {
        block14: {
            ReferenceCounted buf2 = null;
            try {
                if (this.acceptOutboundMessage(msg)) {
                    Object cast2 = msg;
                    buf2 = this.allocateBuffer(ctx2, cast2, this.preferDirect);
                    try {
                        this.encode(ctx2, cast2, (ByteBuf)buf2);
                    }
                    finally {
                        ReferenceCountUtil.release(cast2);
                    }
                    if (((ByteBuf)buf2).isReadable()) {
                        ctx2.write(buf2, promise);
                    } else {
                        buf2.release();
                        ctx2.write(Unpooled.EMPTY_BUFFER, promise);
                    }
                    buf2 = null;
                    break block14;
                }
                ctx2.write(msg, promise);
            }
            catch (EncoderException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new EncoderException(e);
            }
            finally {
                if (buf2 != null) {
                    buf2.release();
                }
            }
        }
    }

    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx2, I msg, boolean preferDirect) throws Exception {
        if (preferDirect) {
            return ctx2.alloc().ioBuffer();
        }
        return ctx2.alloc().heapBuffer();
    }

    protected abstract void encode(ChannelHandlerContext var1, I var2, ByteBuf var3) throws Exception;

    protected boolean isPreferDirect() {
        return this.preferDirect;
    }
}

