/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.compression.ZlibEncoder;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.PromiseNotifier;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SuppressJava6Requirement;
import java.util.concurrent.TimeUnit;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public class JdkZlibEncoder
extends ZlibEncoder {
    private final ZlibWrapper wrapper;
    private final Deflater deflater;
    private volatile boolean finished;
    private volatile ChannelHandlerContext ctx;
    private final CRC32 crc = new CRC32();
    private static final byte[] gzipHeader = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};
    private boolean writeHeader = true;
    private static final int THREAD_POOL_DELAY_SECONDS = 10;

    public JdkZlibEncoder() {
        this(6);
    }

    public JdkZlibEncoder(int compressionLevel) {
        this(ZlibWrapper.ZLIB, compressionLevel);
    }

    public JdkZlibEncoder(ZlibWrapper wrapper) {
        this(wrapper, 6);
    }

    public JdkZlibEncoder(ZlibWrapper wrapper, int compressionLevel) {
        ObjectUtil.checkInRange(compressionLevel, 0, 9, "compressionLevel");
        ObjectUtil.checkNotNull(wrapper, "wrapper");
        if (wrapper == ZlibWrapper.ZLIB_OR_NONE) {
            throw new IllegalArgumentException("wrapper '" + (Object)((Object)ZlibWrapper.ZLIB_OR_NONE) + "' is not allowed for compression.");
        }
        this.wrapper = wrapper;
        this.deflater = new Deflater(compressionLevel, wrapper != ZlibWrapper.ZLIB);
    }

    public JdkZlibEncoder(byte[] dictionary) {
        this(6, dictionary);
    }

    public JdkZlibEncoder(int compressionLevel, byte[] dictionary) {
        ObjectUtil.checkInRange(compressionLevel, 0, 9, "compressionLevel");
        ObjectUtil.checkNotNull(dictionary, "dictionary");
        this.wrapper = ZlibWrapper.ZLIB;
        this.deflater = new Deflater(compressionLevel);
        this.deflater.setDictionary(dictionary);
    }

    @Override
    public ChannelFuture close() {
        return this.close(this.ctx().newPromise());
    }

    @Override
    public ChannelFuture close(final ChannelPromise promise) {
        ChannelHandlerContext ctx2 = this.ctx();
        EventExecutor executor = ctx2.executor();
        if (executor.inEventLoop()) {
            return this.finishEncode(ctx2, promise);
        }
        final ChannelPromise p = ctx2.newPromise();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                ChannelFuture f = JdkZlibEncoder.this.finishEncode(JdkZlibEncoder.this.ctx(), p);
                PromiseNotifier.cascade(f, promise);
            }
        });
        return p;
    }

    private ChannelHandlerContext ctx() {
        ChannelHandlerContext ctx2 = this.ctx;
        if (ctx2 == null) {
            throw new IllegalStateException("not added to a pipeline");
        }
        return ctx2;
    }

    @Override
    public boolean isClosed() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext ctx2, ByteBuf uncompressed, ByteBuf out2) throws Exception {
        if (this.finished) {
            out2.writeBytes(uncompressed);
            return;
        }
        int len = uncompressed.readableBytes();
        if (len == 0) {
            return;
        }
        ReferenceCounted heapBuf = null;
        try {
            int offset;
            byte[] inAry;
            if (uncompressed.hasArray()) {
                inAry = uncompressed.array();
                offset = uncompressed.arrayOffset() + uncompressed.readerIndex();
                uncompressed.skipBytes(len);
            } else {
                heapBuf = ctx2.alloc().heapBuffer(len, len);
                uncompressed.readBytes((ByteBuf)heapBuf, len);
                inAry = ((ByteBuf)heapBuf).array();
                offset = ((ByteBuf)heapBuf).arrayOffset() + ((ByteBuf)heapBuf).readerIndex();
            }
            if (this.writeHeader) {
                this.writeHeader = false;
                if (this.wrapper == ZlibWrapper.GZIP) {
                    out2.writeBytes(gzipHeader);
                }
            }
            if (this.wrapper == ZlibWrapper.GZIP) {
                this.crc.update(inAry, offset, len);
            }
            this.deflater.setInput(inAry, offset, len);
            while (true) {
                this.deflate(out2);
                if (this.deflater.needsInput()) {
                    break;
                }
                if (out2.isWritable()) continue;
                out2.ensureWritable(out2.writerIndex());
            }
        }
        finally {
            if (heapBuf != null) {
                heapBuf.release();
            }
        }
    }

    @Override
    protected final ByteBuf allocateBuffer(ChannelHandlerContext ctx2, ByteBuf msg, boolean preferDirect) throws Exception {
        int sizeEstimate = (int)Math.ceil((double)msg.readableBytes() * 1.001) + 12;
        if (this.writeHeader) {
            switch (this.wrapper) {
                case GZIP: {
                    sizeEstimate += gzipHeader.length;
                    break;
                }
                case ZLIB: {
                    sizeEstimate += 2;
                    break;
                }
            }
        }
        return ctx2.alloc().heapBuffer(sizeEstimate);
    }

    @Override
    public void close(final ChannelHandlerContext ctx2, final ChannelPromise promise) throws Exception {
        ChannelFuture f = this.finishEncode(ctx2, ctx2.newPromise());
        f.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture f) throws Exception {
                ctx2.close(promise);
            }
        });
        if (!f.isDone()) {
            ctx2.executor().schedule(new Runnable(){

                @Override
                public void run() {
                    ctx2.close(promise);
                }
            }, 10L, TimeUnit.SECONDS);
        }
    }

    private ChannelFuture finishEncode(ChannelHandlerContext ctx2, ChannelPromise promise) {
        if (this.finished) {
            promise.setSuccess();
            return promise;
        }
        this.finished = true;
        ByteBuf footer = ctx2.alloc().heapBuffer();
        if (this.writeHeader && this.wrapper == ZlibWrapper.GZIP) {
            this.writeHeader = false;
            footer.writeBytes(gzipHeader);
        }
        this.deflater.finish();
        while (!this.deflater.finished()) {
            this.deflate(footer);
            if (footer.isWritable()) continue;
            ctx2.write(footer);
            footer = ctx2.alloc().heapBuffer();
        }
        if (this.wrapper == ZlibWrapper.GZIP) {
            int crcValue = (int)this.crc.getValue();
            int uncBytes = this.deflater.getTotalIn();
            footer.writeByte(crcValue);
            footer.writeByte(crcValue >>> 8);
            footer.writeByte(crcValue >>> 16);
            footer.writeByte(crcValue >>> 24);
            footer.writeByte(uncBytes);
            footer.writeByte(uncBytes >>> 8);
            footer.writeByte(uncBytes >>> 16);
            footer.writeByte(uncBytes >>> 24);
        }
        this.deflater.end();
        return ctx2.writeAndFlush(footer, promise);
    }

    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    private void deflate(ByteBuf out2) {
        int numBytes;
        if (PlatformDependent.javaVersion() < 7) {
            this.deflateJdk6(out2);
        }
        do {
            int writerIndex = out2.writerIndex();
            numBytes = this.deflater.deflate(out2.array(), out2.arrayOffset() + writerIndex, out2.writableBytes(), 2);
            out2.writerIndex(writerIndex + numBytes);
        } while (numBytes > 0);
    }

    private void deflateJdk6(ByteBuf out2) {
        int numBytes;
        do {
            int writerIndex = out2.writerIndex();
            numBytes = this.deflater.deflate(out2.array(), out2.arrayOffset() + writerIndex, out2.writableBytes());
            out2.writerIndex(writerIndex + numBytes);
        } while (numBytes > 0);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx2) throws Exception {
        this.ctx = ctx2;
    }
}

