/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

public class HttpClientUpgradeHandler
extends HttpObjectAggregator
implements ChannelOutboundHandler {
    private final SourceCodec sourceCodec;
    private final UpgradeCodec upgradeCodec;
    private boolean upgradeRequested;

    public HttpClientUpgradeHandler(SourceCodec sourceCodec, UpgradeCodec upgradeCodec, int maxContentLength) {
        super(maxContentLength);
        this.sourceCodec = ObjectUtil.checkNotNull(sourceCodec, "sourceCodec");
        this.upgradeCodec = ObjectUtil.checkNotNull(upgradeCodec, "upgradeCodec");
    }

    @Override
    public void bind(ChannelHandlerContext ctx2, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx2.bind(localAddress, promise);
    }

    @Override
    public void connect(ChannelHandlerContext ctx2, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx2.connect(remoteAddress, localAddress, promise);
    }

    @Override
    public void disconnect(ChannelHandlerContext ctx2, ChannelPromise promise) throws Exception {
        ctx2.disconnect(promise);
    }

    @Override
    public void close(ChannelHandlerContext ctx2, ChannelPromise promise) throws Exception {
        ctx2.close(promise);
    }

    @Override
    public void deregister(ChannelHandlerContext ctx2, ChannelPromise promise) throws Exception {
        ctx2.deregister(promise);
    }

    @Override
    public void read(ChannelHandlerContext ctx2) throws Exception {
        ctx2.read();
    }

    @Override
    public void write(ChannelHandlerContext ctx2, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof HttpRequest)) {
            ctx2.write(msg, promise);
            return;
        }
        if (this.upgradeRequested) {
            promise.setFailure(new IllegalStateException("Attempting to write HTTP request with upgrade in progress"));
            return;
        }
        this.upgradeRequested = true;
        this.setUpgradeRequestHeaders(ctx2, (HttpRequest)msg);
        ctx2.write(msg, promise);
        ctx2.fireUserEventTriggered((Object)UpgradeEvent.UPGRADE_ISSUED);
    }

    @Override
    public void flush(ChannelHandlerContext ctx2) throws Exception {
        ctx2.flush();
    }

    @Override
    protected void decode(ChannelHandlerContext ctx2, HttpObject msg, List<Object> out2) throws Exception {
        FullHttpResponse response2 = null;
        try {
            HttpResponse rep;
            if (!this.upgradeRequested) {
                throw new IllegalStateException("Read HTTP response without requesting protocol switch");
            }
            if (msg instanceof HttpResponse && !HttpResponseStatus.SWITCHING_PROTOCOLS.equals((rep = (HttpResponse)msg).status())) {
                ctx2.fireUserEventTriggered((Object)UpgradeEvent.UPGRADE_REJECTED);
                HttpClientUpgradeHandler.removeThisHandler(ctx2);
                ctx2.fireChannelRead(msg);
                return;
            }
            if (msg instanceof FullHttpResponse) {
                response2 = (FullHttpResponse)msg;
                response2.retain();
                out2.add(response2);
            } else {
                super.decode(ctx2, msg, out2);
                if (out2.isEmpty()) {
                    return;
                }
                assert (out2.size() == 1);
                response2 = (FullHttpResponse)out2.get(0);
            }
            String upgradeHeader = response2.headers().get(HttpHeaderNames.UPGRADE);
            if (upgradeHeader != null && !AsciiString.contentEqualsIgnoreCase(this.upgradeCodec.protocol(), upgradeHeader)) {
                throw new IllegalStateException("Switching Protocols response with unexpected UPGRADE protocol: " + upgradeHeader);
            }
            this.sourceCodec.prepareUpgradeFrom(ctx2);
            this.upgradeCodec.upgradeTo(ctx2, response2);
            ctx2.fireUserEventTriggered((Object)UpgradeEvent.UPGRADE_SUCCESSFUL);
            this.sourceCodec.upgradeFrom(ctx2);
            response2.release();
            out2.clear();
            HttpClientUpgradeHandler.removeThisHandler(ctx2);
        }
        catch (Throwable t) {
            ReferenceCountUtil.release(response2);
            ctx2.fireExceptionCaught(t);
            HttpClientUpgradeHandler.removeThisHandler(ctx2);
        }
    }

    private static void removeThisHandler(ChannelHandlerContext ctx2) {
        ctx2.pipeline().remove(ctx2.name());
    }

    private void setUpgradeRequestHeaders(ChannelHandlerContext ctx2, HttpRequest request2) {
        request2.headers().set((CharSequence)HttpHeaderNames.UPGRADE, (Object)this.upgradeCodec.protocol());
        LinkedHashSet<CharSequence> connectionParts = new LinkedHashSet<CharSequence>(2);
        connectionParts.addAll(this.upgradeCodec.setUpgradeHeaders(ctx2, request2));
        StringBuilder builder = new StringBuilder();
        for (CharSequence part2 : connectionParts) {
            builder.append(part2);
            builder.append(',');
        }
        builder.append(HttpHeaderValues.UPGRADE);
        request2.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)builder.toString());
    }

    public static interface UpgradeCodec {
        public CharSequence protocol();

        public Collection<CharSequence> setUpgradeHeaders(ChannelHandlerContext var1, HttpRequest var2);

        public void upgradeTo(ChannelHandlerContext var1, FullHttpResponse var2) throws Exception;
    }

    public static interface SourceCodec {
        public void prepareUpgradeFrom(ChannelHandlerContext var1);

        public void upgradeFrom(ChannelHandlerContext var1);
    }

    public static enum UpgradeEvent {
        UPGRADE_ISSUED,
        UPGRADE_SUCCESSFUL,
        UPGRADE_REJECTED;

    }
}

