/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;

final class HttpHeadersEncoder {
    private static final int COLON_AND_SPACE_SHORT = 14880;

    private HttpHeadersEncoder() {
    }

    static void encoderHeader(CharSequence name, CharSequence value, ByteBuf buf2) {
        int nameLen = name.length();
        int valueLen = value.length();
        int entryLen = nameLen + valueLen + 4;
        buf2.ensureWritable(entryLen);
        int offset = buf2.writerIndex();
        HttpHeadersEncoder.writeAscii(buf2, offset, name);
        ByteBufUtil.setShortBE(buf2, offset += nameLen, 14880);
        HttpHeadersEncoder.writeAscii(buf2, offset += 2, value);
        ByteBufUtil.setShortBE(buf2, offset += valueLen, 3338);
        buf2.writerIndex(offset += 2);
    }

    private static void writeAscii(ByteBuf buf2, int offset, CharSequence value) {
        if (value instanceof AsciiString) {
            ByteBufUtil.copy((AsciiString)value, 0, buf2, offset, value.length());
        } else {
            buf2.setCharSequence(offset, value, CharsetUtil.US_ASCII);
        }
    }
}

