/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersEncoder;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.StringUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class HttpObjectEncoder<H extends HttpMessage>
extends MessageToMessageEncoder<Object> {
    static final int CRLF_SHORT = 3338;
    private static final int ZERO_CRLF_MEDIUM = 3149066;
    private static final byte[] ZERO_CRLF_CRLF = new byte[]{48, 13, 10, 13, 10};
    private static final ByteBuf CRLF_BUF = Unpooled.unreleasableBuffer(Unpooled.directBuffer(2).writeByte(13).writeByte(10)).asReadOnly();
    private static final ByteBuf ZERO_CRLF_CRLF_BUF = Unpooled.unreleasableBuffer(Unpooled.directBuffer(ZERO_CRLF_CRLF.length).writeBytes(ZERO_CRLF_CRLF)).asReadOnly();
    private static final float HEADERS_WEIGHT_NEW = 0.2f;
    private static final float HEADERS_WEIGHT_HISTORICAL = 0.8f;
    private static final float TRAILERS_WEIGHT_NEW = 0.2f;
    private static final float TRAILERS_WEIGHT_HISTORICAL = 0.8f;
    private static final int ST_INIT = 0;
    private static final int ST_CONTENT_NON_CHUNK = 1;
    private static final int ST_CONTENT_CHUNK = 2;
    private static final int ST_CONTENT_ALWAYS_EMPTY = 3;
    private int state = 0;
    private float headersEncodedSizeAccumulator = 256.0f;
    private float trailersEncodedSizeAccumulator = 256.0f;

    @Override
    protected void encode(ChannelHandlerContext ctx2, Object msg, List<Object> out2) throws Exception {
        ByteBuf potentialEmptyBuf;
        ByteBuf buf2 = null;
        if (msg instanceof HttpMessage) {
            if (this.state != 0) {
                throw new IllegalStateException("unexpected message type: " + StringUtil.simpleClassName(msg) + ", state: " + this.state);
            }
            HttpMessage m3 = (HttpMessage)msg;
            buf2 = ctx2.alloc().buffer((int)this.headersEncodedSizeAccumulator);
            this.encodeInitialLine(buf2, m3);
            this.state = this.isContentAlwaysEmpty(m3) ? 3 : (HttpUtil.isTransferEncodingChunked(m3) ? 2 : 1);
            this.sanitizeHeadersBeforeEncode(m3, this.state == 3);
            this.encodeHeaders(m3.headers(), buf2);
            ByteBufUtil.writeShortBE(buf2, 3338);
            this.headersEncodedSizeAccumulator = 0.2f * (float)HttpObjectEncoder.padSizeForAccumulation(buf2.readableBytes()) + 0.8f * this.headersEncodedSizeAccumulator;
        }
        if (msg instanceof ByteBuf && !(potentialEmptyBuf = (ByteBuf)msg).isReadable()) {
            out2.add(potentialEmptyBuf.retain());
            return;
        }
        if (msg instanceof HttpContent || msg instanceof ByteBuf || msg instanceof FileRegion) {
            switch (this.state) {
                case 0: {
                    throw new IllegalStateException("unexpected message type: " + StringUtil.simpleClassName(msg) + ", state: " + this.state);
                }
                case 1: {
                    long contentLength = HttpObjectEncoder.contentLength(msg);
                    if (contentLength > 0L) {
                        if (buf2 != null && (long)buf2.writableBytes() >= contentLength && msg instanceof HttpContent) {
                            buf2.writeBytes(((HttpContent)msg).content());
                            out2.add(buf2);
                        } else {
                            if (buf2 != null) {
                                out2.add(buf2);
                            }
                            out2.add(HttpObjectEncoder.encodeAndRetain(msg));
                        }
                        if (!(msg instanceof LastHttpContent)) break;
                        this.state = 0;
                        break;
                    }
                }
                case 3: {
                    if (buf2 != null) {
                        out2.add(buf2);
                        break;
                    }
                    out2.add(Unpooled.EMPTY_BUFFER);
                    break;
                }
                case 2: {
                    if (buf2 != null) {
                        out2.add(buf2);
                    }
                    this.encodeChunkedContent(ctx2, msg, HttpObjectEncoder.contentLength(msg), out2);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            if (msg instanceof LastHttpContent) {
                this.state = 0;
            }
        } else if (buf2 != null) {
            out2.add(buf2);
        }
    }

    protected void encodeHeaders(HttpHeaders headers2, ByteBuf buf2) {
        Iterator<Map.Entry<CharSequence, CharSequence>> iter = headers2.iteratorCharSequence();
        while (iter.hasNext()) {
            Map.Entry<CharSequence, CharSequence> header = iter.next();
            HttpHeadersEncoder.encoderHeader(header.getKey(), header.getValue(), buf2);
        }
    }

    private void encodeChunkedContent(ChannelHandlerContext ctx2, Object msg, long contentLength, List<Object> out2) {
        ByteBuf buf2;
        if (contentLength > 0L) {
            String lengthHex = Long.toHexString(contentLength);
            buf2 = ctx2.alloc().buffer(lengthHex.length() + 2);
            buf2.writeCharSequence(lengthHex, CharsetUtil.US_ASCII);
            ByteBufUtil.writeShortBE(buf2, 3338);
            out2.add(buf2);
            out2.add(HttpObjectEncoder.encodeAndRetain(msg));
            out2.add(CRLF_BUF.duplicate());
        }
        if (msg instanceof LastHttpContent) {
            HttpHeaders headers2 = ((LastHttpContent)msg).trailingHeaders();
            if (headers2.isEmpty()) {
                out2.add(ZERO_CRLF_CRLF_BUF.duplicate());
            } else {
                buf2 = ctx2.alloc().buffer((int)this.trailersEncodedSizeAccumulator);
                ByteBufUtil.writeMediumBE(buf2, 3149066);
                this.encodeHeaders(headers2, buf2);
                ByteBufUtil.writeShortBE(buf2, 3338);
                this.trailersEncodedSizeAccumulator = 0.2f * (float)HttpObjectEncoder.padSizeForAccumulation(buf2.readableBytes()) + 0.8f * this.trailersEncodedSizeAccumulator;
                out2.add(buf2);
            }
        } else if (contentLength == 0L) {
            out2.add(HttpObjectEncoder.encodeAndRetain(msg));
        }
    }

    protected void sanitizeHeadersBeforeEncode(H msg, boolean isAlwaysEmpty) {
    }

    protected boolean isContentAlwaysEmpty(H msg) {
        return false;
    }

    @Override
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return msg instanceof HttpObject || msg instanceof ByteBuf || msg instanceof FileRegion;
    }

    private static Object encodeAndRetain(Object msg) {
        if (msg instanceof ByteBuf) {
            return ((ByteBuf)msg).retain();
        }
        if (msg instanceof HttpContent) {
            return ((HttpContent)msg).content().retain();
        }
        if (msg instanceof FileRegion) {
            return ((FileRegion)msg).retain();
        }
        throw new IllegalStateException("unexpected message type: " + StringUtil.simpleClassName(msg));
    }

    private static long contentLength(Object msg) {
        if (msg instanceof HttpContent) {
            return ((HttpContent)msg).content().readableBytes();
        }
        if (msg instanceof ByteBuf) {
            return ((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof FileRegion) {
            return ((FileRegion)msg).count();
        }
        throw new IllegalStateException("unexpected message type: " + StringUtil.simpleClassName(msg));
    }

    private static int padSizeForAccumulation(int readableBytes) {
        return (readableBytes << 2) / 3;
    }

    @Deprecated
    protected static void encodeAscii(String s2, ByteBuf buf2) {
        buf2.writeCharSequence(s2, CharsetUtil.US_ASCII);
    }

    protected abstract void encodeInitialLine(ByteBuf var1, H var2) throws Exception;
}

