/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.HttpObjectEncoder;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.CharsetUtil;

public class HttpRequestEncoder
extends HttpObjectEncoder<HttpRequest> {
    private static final char SLASH = '/';
    private static final char QUESTION_MARK = '?';
    private static final int SLASH_AND_SPACE_SHORT = 12064;
    private static final int SPACE_SLASH_AND_SPACE_MEDIUM = 0x202F20;

    @Override
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return super.acceptOutboundMessage(msg) && !(msg instanceof HttpResponse);
    }

    @Override
    protected void encodeInitialLine(ByteBuf buf2, HttpRequest request2) throws Exception {
        ByteBufUtil.copy(request2.method().asciiName(), buf2);
        String uri2 = request2.uri();
        if (uri2.isEmpty()) {
            ByteBufUtil.writeMediumBE(buf2, 0x202F20);
        } else {
            CharSequence uriCharSequence = uri2;
            boolean needSlash = false;
            int start = uri2.indexOf("://");
            if (start != -1 && uri2.charAt(0) != '/') {
                int index = uri2.indexOf(63, start += 3);
                if (index == -1) {
                    if (uri2.lastIndexOf(47) < start) {
                        needSlash = true;
                    }
                } else if (uri2.lastIndexOf(47, index) < start) {
                    uriCharSequence = new StringBuilder(uri2).insert(index, '/');
                }
            }
            buf2.writeByte(32).writeCharSequence(uriCharSequence, CharsetUtil.UTF_8);
            if (needSlash) {
                ByteBufUtil.writeShortBE(buf2, 12064);
            } else {
                buf2.writeByte(32);
            }
        }
        request2.protocolVersion().encode(buf2);
        ByteBufUtil.writeShortBE(buf2, 3338);
    }
}

