/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.PromiseNotifier;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import java.util.concurrent.TimeUnit;

abstract class WebSocketProtocolHandler
extends MessageToMessageDecoder<WebSocketFrame>
implements ChannelOutboundHandler {
    private final boolean dropPongFrames;
    private final WebSocketCloseStatus closeStatus;
    private final long forceCloseTimeoutMillis;
    private ChannelPromise closeSent;

    WebSocketProtocolHandler() {
        this(true);
    }

    WebSocketProtocolHandler(boolean dropPongFrames) {
        this(dropPongFrames, null, 0L);
    }

    WebSocketProtocolHandler(boolean dropPongFrames, WebSocketCloseStatus closeStatus, long forceCloseTimeoutMillis) {
        this.dropPongFrames = dropPongFrames;
        this.closeStatus = closeStatus;
        this.forceCloseTimeoutMillis = forceCloseTimeoutMillis;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx2, WebSocketFrame frame, List<Object> out2) throws Exception {
        if (frame instanceof PingWebSocketFrame) {
            frame.content().retain();
            ctx2.channel().writeAndFlush(new PongWebSocketFrame(frame.content()));
            WebSocketProtocolHandler.readIfNeeded(ctx2);
            return;
        }
        if (frame instanceof PongWebSocketFrame && this.dropPongFrames) {
            WebSocketProtocolHandler.readIfNeeded(ctx2);
            return;
        }
        out2.add(frame.retain());
    }

    private static void readIfNeeded(ChannelHandlerContext ctx2) {
        if (!ctx2.channel().config().isAutoRead()) {
            ctx2.read();
        }
    }

    @Override
    public void close(final ChannelHandlerContext ctx2, final ChannelPromise promise) throws Exception {
        if (this.closeStatus == null || !ctx2.channel().isActive()) {
            ctx2.close(promise);
        } else {
            if (this.closeSent == null) {
                this.write(ctx2, new CloseWebSocketFrame(this.closeStatus), ctx2.newPromise());
            }
            this.flush(ctx2);
            this.applyCloseSentTimeout(ctx2);
            this.closeSent.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) {
                    ctx2.close(promise);
                }
            });
        }
    }

    @Override
    public void write(ChannelHandlerContext ctx2, Object msg, ChannelPromise promise) throws Exception {
        if (this.closeSent != null) {
            ReferenceCountUtil.release(msg);
            promise.setFailure(new ClosedChannelException());
        } else if (msg instanceof CloseWebSocketFrame) {
            this.closeSent(promise.unvoid());
            ctx2.write(msg).addListener(new PromiseNotifier(false, this.closeSent));
        } else {
            ctx2.write(msg, promise);
        }
    }

    void closeSent(ChannelPromise promise) {
        this.closeSent = promise;
    }

    private void applyCloseSentTimeout(ChannelHandlerContext ctx2) {
        if (this.closeSent.isDone() || this.forceCloseTimeoutMillis < 0L) {
            return;
        }
        final ScheduledFuture<?> timeoutTask = ctx2.executor().schedule(new Runnable(){

            @Override
            public void run() {
                if (!WebSocketProtocolHandler.this.closeSent.isDone()) {
                    WebSocketProtocolHandler.this.closeSent.tryFailure(WebSocketProtocolHandler.this.buildHandshakeException("send close frame timed out"));
                }
            }
        }, this.forceCloseTimeoutMillis, TimeUnit.MILLISECONDS);
        this.closeSent.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) {
                timeoutTask.cancel(false);
            }
        });
    }

    protected WebSocketHandshakeException buildHandshakeException(String message2) {
        return new WebSocketHandshakeException(message2);
    }

    @Override
    public void bind(ChannelHandlerContext ctx2, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx2.bind(localAddress, promise);
    }

    @Override
    public void connect(ChannelHandlerContext ctx2, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx2.connect(remoteAddress, localAddress, promise);
    }

    @Override
    public void disconnect(ChannelHandlerContext ctx2, ChannelPromise promise) throws Exception {
        ctx2.disconnect(promise);
    }

    @Override
    public void deregister(ChannelHandlerContext ctx2, ChannelPromise promise) throws Exception {
        ctx2.deregister(promise);
    }

    @Override
    public void read(ChannelHandlerContext ctx2) throws Exception {
        ctx2.read();
    }

    @Override
    public void flush(ChannelHandlerContext ctx2) throws Exception {
        ctx2.flush();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx2, Throwable cause) throws Exception {
        ctx2.fireExceptionCaught(cause);
        ctx2.close();
    }
}

