/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.internal.ObjectUtil;

public class Http2InboundFrameLogger
implements Http2FrameReader {
    private final Http2FrameReader reader;
    private final Http2FrameLogger logger;

    public Http2InboundFrameLogger(Http2FrameReader reader, Http2FrameLogger logger) {
        this.reader = ObjectUtil.checkNotNull(reader, "reader");
        this.logger = ObjectUtil.checkNotNull(logger, "logger");
    }

    @Override
    public void readFrame(ChannelHandlerContext ctx2, ByteBuf input2, final Http2FrameListener listener) throws Http2Exception {
        this.reader.readFrame(ctx2, input2, new Http2FrameListener(){

            @Override
            public int onDataRead(ChannelHandlerContext ctx2, int streamId, ByteBuf data2, int padding, boolean endOfStream) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logData(Http2FrameLogger.Direction.INBOUND, ctx2, streamId, data2, padding, endOfStream);
                return listener.onDataRead(ctx2, streamId, data2, padding, endOfStream);
            }

            @Override
            public void onHeadersRead(ChannelHandlerContext ctx2, int streamId, Http2Headers headers2, int padding, boolean endStream) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logHeaders(Http2FrameLogger.Direction.INBOUND, ctx2, streamId, headers2, padding, endStream);
                listener.onHeadersRead(ctx2, streamId, headers2, padding, endStream);
            }

            @Override
            public void onHeadersRead(ChannelHandlerContext ctx2, int streamId, Http2Headers headers2, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logHeaders(Http2FrameLogger.Direction.INBOUND, ctx2, streamId, headers2, streamDependency, weight, exclusive, padding, endStream);
                listener.onHeadersRead(ctx2, streamId, headers2, streamDependency, weight, exclusive, padding, endStream);
            }

            @Override
            public void onPriorityRead(ChannelHandlerContext ctx2, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logPriority(Http2FrameLogger.Direction.INBOUND, ctx2, streamId, streamDependency, weight, exclusive);
                listener.onPriorityRead(ctx2, streamId, streamDependency, weight, exclusive);
            }

            @Override
            public void onRstStreamRead(ChannelHandlerContext ctx2, int streamId, long errorCode) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logRstStream(Http2FrameLogger.Direction.INBOUND, ctx2, streamId, errorCode);
                listener.onRstStreamRead(ctx2, streamId, errorCode);
            }

            @Override
            public void onSettingsAckRead(ChannelHandlerContext ctx2) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logSettingsAck(Http2FrameLogger.Direction.INBOUND, ctx2);
                listener.onSettingsAckRead(ctx2);
            }

            @Override
            public void onSettingsRead(ChannelHandlerContext ctx2, Http2Settings settings2) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logSettings(Http2FrameLogger.Direction.INBOUND, ctx2, settings2);
                listener.onSettingsRead(ctx2, settings2);
            }

            @Override
            public void onPingRead(ChannelHandlerContext ctx2, long data2) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logPing(Http2FrameLogger.Direction.INBOUND, ctx2, data2);
                listener.onPingRead(ctx2, data2);
            }

            @Override
            public void onPingAckRead(ChannelHandlerContext ctx2, long data2) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logPingAck(Http2FrameLogger.Direction.INBOUND, ctx2, data2);
                listener.onPingAckRead(ctx2, data2);
            }

            @Override
            public void onPushPromiseRead(ChannelHandlerContext ctx2, int streamId, int promisedStreamId, Http2Headers headers2, int padding) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logPushPromise(Http2FrameLogger.Direction.INBOUND, ctx2, streamId, promisedStreamId, headers2, padding);
                listener.onPushPromiseRead(ctx2, streamId, promisedStreamId, headers2, padding);
            }

            @Override
            public void onGoAwayRead(ChannelHandlerContext ctx2, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logGoAway(Http2FrameLogger.Direction.INBOUND, ctx2, lastStreamId, errorCode, debugData);
                listener.onGoAwayRead(ctx2, lastStreamId, errorCode, debugData);
            }

            @Override
            public void onWindowUpdateRead(ChannelHandlerContext ctx2, int streamId, int windowSizeIncrement) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logWindowsUpdate(Http2FrameLogger.Direction.INBOUND, ctx2, streamId, windowSizeIncrement);
                listener.onWindowUpdateRead(ctx2, streamId, windowSizeIncrement);
            }

            @Override
            public void onUnknownFrame(ChannelHandlerContext ctx2, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logUnknownFrame(Http2FrameLogger.Direction.INBOUND, ctx2, frameType, streamId, flags, payload);
                listener.onUnknownFrame(ctx2, frameType, streamId, flags, payload);
            }
        });
    }

    @Override
    public void close() {
        this.reader.close();
    }

    @Override
    public Http2FrameReader.Configuration configuration() {
        return this.reader.configuration();
    }
}

