/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.internal.ObjectUtil;

public class Http2OutboundFrameLogger
implements Http2FrameWriter {
    private final Http2FrameWriter writer;
    private final Http2FrameLogger logger;

    public Http2OutboundFrameLogger(Http2FrameWriter writer, Http2FrameLogger logger) {
        this.writer = ObjectUtil.checkNotNull(writer, "writer");
        this.logger = ObjectUtil.checkNotNull(logger, "logger");
    }

    @Override
    public ChannelFuture writeData(ChannelHandlerContext ctx2, int streamId, ByteBuf data2, int padding, boolean endStream, ChannelPromise promise) {
        this.logger.logData(Http2FrameLogger.Direction.OUTBOUND, ctx2, streamId, data2, padding, endStream);
        return this.writer.writeData(ctx2, streamId, data2, padding, endStream, promise);
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext ctx2, int streamId, Http2Headers headers2, int padding, boolean endStream, ChannelPromise promise) {
        this.logger.logHeaders(Http2FrameLogger.Direction.OUTBOUND, ctx2, streamId, headers2, padding, endStream);
        return this.writer.writeHeaders(ctx2, streamId, headers2, padding, endStream, promise);
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext ctx2, int streamId, Http2Headers headers2, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream, ChannelPromise promise) {
        this.logger.logHeaders(Http2FrameLogger.Direction.OUTBOUND, ctx2, streamId, headers2, streamDependency, weight, exclusive, padding, endStream);
        return this.writer.writeHeaders(ctx2, streamId, headers2, streamDependency, weight, exclusive, padding, endStream, promise);
    }

    @Override
    public ChannelFuture writePriority(ChannelHandlerContext ctx2, int streamId, int streamDependency, short weight, boolean exclusive, ChannelPromise promise) {
        this.logger.logPriority(Http2FrameLogger.Direction.OUTBOUND, ctx2, streamId, streamDependency, weight, exclusive);
        return this.writer.writePriority(ctx2, streamId, streamDependency, weight, exclusive, promise);
    }

    @Override
    public ChannelFuture writeRstStream(ChannelHandlerContext ctx2, int streamId, long errorCode, ChannelPromise promise) {
        this.logger.logRstStream(Http2FrameLogger.Direction.OUTBOUND, ctx2, streamId, errorCode);
        return this.writer.writeRstStream(ctx2, streamId, errorCode, promise);
    }

    @Override
    public ChannelFuture writeSettings(ChannelHandlerContext ctx2, Http2Settings settings2, ChannelPromise promise) {
        this.logger.logSettings(Http2FrameLogger.Direction.OUTBOUND, ctx2, settings2);
        return this.writer.writeSettings(ctx2, settings2, promise);
    }

    @Override
    public ChannelFuture writeSettingsAck(ChannelHandlerContext ctx2, ChannelPromise promise) {
        this.logger.logSettingsAck(Http2FrameLogger.Direction.OUTBOUND, ctx2);
        return this.writer.writeSettingsAck(ctx2, promise);
    }

    @Override
    public ChannelFuture writePing(ChannelHandlerContext ctx2, boolean ack, long data2, ChannelPromise promise) {
        if (ack) {
            this.logger.logPingAck(Http2FrameLogger.Direction.OUTBOUND, ctx2, data2);
        } else {
            this.logger.logPing(Http2FrameLogger.Direction.OUTBOUND, ctx2, data2);
        }
        return this.writer.writePing(ctx2, ack, data2, promise);
    }

    @Override
    public ChannelFuture writePushPromise(ChannelHandlerContext ctx2, int streamId, int promisedStreamId, Http2Headers headers2, int padding, ChannelPromise promise) {
        this.logger.logPushPromise(Http2FrameLogger.Direction.OUTBOUND, ctx2, streamId, promisedStreamId, headers2, padding);
        return this.writer.writePushPromise(ctx2, streamId, promisedStreamId, headers2, padding, promise);
    }

    @Override
    public ChannelFuture writeGoAway(ChannelHandlerContext ctx2, int lastStreamId, long errorCode, ByteBuf debugData, ChannelPromise promise) {
        this.logger.logGoAway(Http2FrameLogger.Direction.OUTBOUND, ctx2, lastStreamId, errorCode, debugData);
        return this.writer.writeGoAway(ctx2, lastStreamId, errorCode, debugData, promise);
    }

    @Override
    public ChannelFuture writeWindowUpdate(ChannelHandlerContext ctx2, int streamId, int windowSizeIncrement, ChannelPromise promise) {
        this.logger.logWindowsUpdate(Http2FrameLogger.Direction.OUTBOUND, ctx2, streamId, windowSizeIncrement);
        return this.writer.writeWindowUpdate(ctx2, streamId, windowSizeIncrement, promise);
    }

    @Override
    public ChannelFuture writeFrame(ChannelHandlerContext ctx2, byte frameType, int streamId, Http2Flags flags, ByteBuf payload, ChannelPromise promise) {
        this.logger.logUnknownFrame(Http2FrameLogger.Direction.OUTBOUND, ctx2, frameType, streamId, flags, payload);
        return this.writer.writeFrame(ctx2, frameType, streamId, flags, payload, promise);
    }

    @Override
    public void close() {
        this.writer.close();
    }

    @Override
    public Http2FrameWriter.Configuration configuration() {
        return this.writer.configuration();
    }
}

