/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.internal.ObjectUtil;

public class InboundHttp2ToHttpAdapter
extends Http2EventAdapter {
    private static final ImmediateSendDetector DEFAULT_SEND_DETECTOR = new ImmediateSendDetector(){

        @Override
        public boolean mustSendImmediately(FullHttpMessage msg) {
            if (msg instanceof FullHttpResponse) {
                return ((FullHttpResponse)msg).status().codeClass() == HttpStatusClass.INFORMATIONAL;
            }
            if (msg instanceof FullHttpRequest) {
                return msg.headers().contains(HttpHeaderNames.EXPECT);
            }
            return false;
        }

        @Override
        public FullHttpMessage copyIfNeeded(ByteBufAllocator allocator, FullHttpMessage msg) {
            if (msg instanceof FullHttpRequest) {
                FullHttpRequest copy2 = ((FullHttpRequest)msg).replace(allocator.buffer(0));
                copy2.headers().remove(HttpHeaderNames.EXPECT);
                return copy2;
            }
            return null;
        }
    };
    private final int maxContentLength;
    private final ImmediateSendDetector sendDetector;
    private final Http2Connection.PropertyKey messageKey;
    private final boolean propagateSettings;
    protected final Http2Connection connection;
    protected final boolean validateHttpHeaders;

    protected InboundHttp2ToHttpAdapter(Http2Connection connection, int maxContentLength, boolean validateHttpHeaders, boolean propagateSettings) {
        this.connection = ObjectUtil.checkNotNull(connection, "connection");
        this.maxContentLength = ObjectUtil.checkPositive(maxContentLength, "maxContentLength");
        this.validateHttpHeaders = validateHttpHeaders;
        this.propagateSettings = propagateSettings;
        this.sendDetector = DEFAULT_SEND_DETECTOR;
        this.messageKey = connection.newKey();
    }

    protected final void removeMessage(Http2Stream stream, boolean release2) {
        FullHttpMessage msg = (FullHttpMessage)stream.removeProperty(this.messageKey);
        if (release2 && msg != null) {
            msg.release();
        }
    }

    protected final FullHttpMessage getMessage(Http2Stream stream) {
        return (FullHttpMessage)stream.getProperty(this.messageKey);
    }

    protected final void putMessage(Http2Stream stream, FullHttpMessage message2) {
        FullHttpMessage previous = stream.setProperty(this.messageKey, message2);
        if (previous != message2 && previous != null) {
            previous.release();
        }
    }

    @Override
    public void onStreamRemoved(Http2Stream stream) {
        this.removeMessage(stream, true);
    }

    protected void fireChannelRead(ChannelHandlerContext ctx2, FullHttpMessage msg, boolean release2, Http2Stream stream) {
        this.removeMessage(stream, release2);
        HttpUtil.setContentLength(msg, msg.content().readableBytes());
        ctx2.fireChannelRead(msg);
    }

    protected FullHttpMessage newMessage(Http2Stream stream, Http2Headers headers2, boolean validateHttpHeaders, ByteBufAllocator alloc) throws Http2Exception {
        return this.connection.isServer() ? HttpConversionUtil.toFullHttpRequest(stream.id(), headers2, alloc, validateHttpHeaders) : HttpConversionUtil.toFullHttpResponse(stream.id(), headers2, alloc, validateHttpHeaders);
    }

    protected FullHttpMessage processHeadersBegin(ChannelHandlerContext ctx2, Http2Stream stream, Http2Headers headers2, boolean endOfStream, boolean allowAppend, boolean appendToTrailer) throws Http2Exception {
        FullHttpMessage msg = this.getMessage(stream);
        boolean release2 = true;
        if (msg == null) {
            msg = this.newMessage(stream, headers2, this.validateHttpHeaders, ctx2.alloc());
        } else if (allowAppend) {
            release2 = false;
            HttpConversionUtil.addHttp2ToHttpHeaders(stream.id(), headers2, msg, appendToTrailer);
        } else {
            release2 = false;
            msg = null;
        }
        if (this.sendDetector.mustSendImmediately(msg)) {
            FullHttpMessage copy2 = endOfStream ? null : this.sendDetector.copyIfNeeded(ctx2.alloc(), msg);
            this.fireChannelRead(ctx2, msg, release2, stream);
            return copy2;
        }
        return msg;
    }

    private void processHeadersEnd(ChannelHandlerContext ctx2, Http2Stream stream, FullHttpMessage msg, boolean endOfStream) {
        if (endOfStream) {
            this.fireChannelRead(ctx2, msg, this.getMessage(stream) != msg, stream);
        } else {
            this.putMessage(stream, msg);
        }
    }

    @Override
    public int onDataRead(ChannelHandlerContext ctx2, int streamId, ByteBuf data2, int padding, boolean endOfStream) throws Http2Exception {
        Http2Stream stream = this.connection.stream(streamId);
        FullHttpMessage msg = this.getMessage(stream);
        if (msg == null) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Data Frame received for unknown stream id %d", streamId);
        }
        ByteBuf content2 = msg.content();
        int dataReadableBytes = data2.readableBytes();
        if (content2.readableBytes() > this.maxContentLength - dataReadableBytes) {
            throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "Content length exceeded max of %d for stream id %d", this.maxContentLength, streamId);
        }
        content2.writeBytes(data2, data2.readerIndex(), dataReadableBytes);
        if (endOfStream) {
            this.fireChannelRead(ctx2, msg, false, stream);
        }
        return dataReadableBytes + padding;
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext ctx2, int streamId, Http2Headers headers2, int padding, boolean endOfStream) throws Http2Exception {
        Http2Stream stream = this.connection.stream(streamId);
        FullHttpMessage msg = this.processHeadersBegin(ctx2, stream, headers2, endOfStream, true, true);
        if (msg != null) {
            this.processHeadersEnd(ctx2, stream, msg, endOfStream);
        }
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext ctx2, int streamId, Http2Headers headers2, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        Http2Stream stream = this.connection.stream(streamId);
        FullHttpMessage msg = this.processHeadersBegin(ctx2, stream, headers2, endOfStream, true, true);
        if (msg != null) {
            if (streamDependency != 0) {
                msg.headers().setInt(HttpConversionUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text(), streamDependency);
            }
            msg.headers().setShort(HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), weight);
            this.processHeadersEnd(ctx2, stream, msg, endOfStream);
        }
    }

    @Override
    public void onRstStreamRead(ChannelHandlerContext ctx2, int streamId, long errorCode) throws Http2Exception {
        Http2Stream stream = this.connection.stream(streamId);
        FullHttpMessage msg = this.getMessage(stream);
        if (msg != null) {
            this.onRstStreamRead(stream, msg);
        }
        ctx2.fireExceptionCaught(Http2Exception.streamError(streamId, Http2Error.valueOf(errorCode), "HTTP/2 to HTTP layer caught stream reset", new Object[0]));
    }

    @Override
    public void onPushPromiseRead(ChannelHandlerContext ctx2, int streamId, int promisedStreamId, Http2Headers headers2, int padding) throws Http2Exception {
        FullHttpMessage msg;
        Http2Stream promisedStream = this.connection.stream(promisedStreamId);
        if (headers2.status() == null) {
            headers2.status(HttpResponseStatus.OK.codeAsText());
        }
        if ((msg = this.processHeadersBegin(ctx2, promisedStream, headers2, false, false, false)) == null) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Push Promise Frame received for pre-existing stream id %d", promisedStreamId);
        }
        msg.headers().setInt(HttpConversionUtil.ExtensionHeaderNames.STREAM_PROMISE_ID.text(), streamId);
        msg.headers().setShort(HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
        this.processHeadersEnd(ctx2, promisedStream, msg, false);
    }

    @Override
    public void onSettingsRead(ChannelHandlerContext ctx2, Http2Settings settings2) throws Http2Exception {
        if (this.propagateSettings) {
            ctx2.fireChannelRead(settings2);
        }
    }

    protected void onRstStreamRead(Http2Stream stream, FullHttpMessage msg) {
        this.removeMessage(stream, true);
    }

    private static interface ImmediateSendDetector {
        public boolean mustSendImmediately(FullHttpMessage var1);

        public FullHttpMessage copyIfNeeded(ByteBufAllocator var1, FullHttpMessage var2);
    }
}

