/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.serialization;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.serialization.CompactObjectOutputStream;
import io.netty.util.internal.ObjectUtil;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;

public class ObjectEncoderOutputStream
extends OutputStream
implements ObjectOutput {
    private final DataOutputStream out;
    private final int estimatedLength;

    public ObjectEncoderOutputStream(OutputStream out2) {
        this(out2, 512);
    }

    public ObjectEncoderOutputStream(OutputStream out2, int estimatedLength) {
        ObjectUtil.checkNotNull(out2, "out");
        ObjectUtil.checkPositiveOrZero(estimatedLength, "estimatedLength");
        this.out = out2 instanceof DataOutputStream ? (DataOutputStream)out2 : new DataOutputStream(out2);
        this.estimatedLength = estimatedLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObject(Object obj) throws IOException {
        ByteBuf buf2 = Unpooled.buffer(this.estimatedLength);
        try {
            CompactObjectOutputStream oout = new CompactObjectOutputStream(new ByteBufOutputStream(buf2));
            try {
                oout.writeObject(obj);
                oout.flush();
            }
            finally {
                oout.close();
            }
            int objectSize = buf2.readableBytes();
            this.writeInt(objectSize);
            buf2.getBytes(0, this, objectSize);
        }
        finally {
            buf2.release();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    public final int size() {
        return this.out.size();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.out.writeBoolean(v);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.out.writeByte(v);
    }

    @Override
    public final void writeBytes(String s2) throws IOException {
        this.out.writeBytes(s2);
    }

    @Override
    public final void writeChar(int v) throws IOException {
        this.out.writeChar(v);
    }

    @Override
    public final void writeChars(String s2) throws IOException {
        this.out.writeChars(s2);
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.out.writeDouble(v);
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.out.writeFloat(v);
    }

    @Override
    public final void writeInt(int v) throws IOException {
        this.out.writeInt(v);
    }

    @Override
    public final void writeLong(long v) throws IOException {
        this.out.writeLong(v);
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.out.writeShort(v);
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        this.out.writeUTF(str);
    }
}

