/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.flush;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.Future;

public class FlushConsolidationHandler
extends ChannelDuplexHandler {
    private final int explicitFlushAfterFlushes;
    private final boolean consolidateWhenNoReadInProgress;
    private final Runnable flushTask;
    private int flushPendingCount;
    private boolean readInProgress;
    private ChannelHandlerContext ctx;
    private Future<?> nextScheduledFlush;
    public static final int DEFAULT_EXPLICIT_FLUSH_AFTER_FLUSHES = 256;

    public FlushConsolidationHandler() {
        this(256, false);
    }

    public FlushConsolidationHandler(int explicitFlushAfterFlushes) {
        this(explicitFlushAfterFlushes, false);
    }

    public FlushConsolidationHandler(int explicitFlushAfterFlushes, boolean consolidateWhenNoReadInProgress) {
        this.explicitFlushAfterFlushes = ObjectUtil.checkPositive(explicitFlushAfterFlushes, "explicitFlushAfterFlushes");
        this.consolidateWhenNoReadInProgress = consolidateWhenNoReadInProgress;
        this.flushTask = consolidateWhenNoReadInProgress ? new Runnable(){

            @Override
            public void run() {
                if (FlushConsolidationHandler.this.flushPendingCount > 0 && !FlushConsolidationHandler.this.readInProgress) {
                    FlushConsolidationHandler.this.flushPendingCount = 0;
                    FlushConsolidationHandler.this.nextScheduledFlush = null;
                    FlushConsolidationHandler.this.ctx.flush();
                }
            }
        } : null;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx2) throws Exception {
        this.ctx = ctx2;
    }

    @Override
    public void flush(ChannelHandlerContext ctx2) throws Exception {
        if (this.readInProgress) {
            if (++this.flushPendingCount == this.explicitFlushAfterFlushes) {
                this.flushNow(ctx2);
            }
        } else if (this.consolidateWhenNoReadInProgress) {
            if (++this.flushPendingCount == this.explicitFlushAfterFlushes) {
                this.flushNow(ctx2);
            } else {
                this.scheduleFlush(ctx2);
            }
        } else {
            this.flushNow(ctx2);
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx2) throws Exception {
        this.resetReadAndFlushIfNeeded(ctx2);
        ctx2.fireChannelReadComplete();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx2, Object msg) throws Exception {
        this.readInProgress = true;
        ctx2.fireChannelRead(msg);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx2, Throwable cause) throws Exception {
        this.resetReadAndFlushIfNeeded(ctx2);
        ctx2.fireExceptionCaught(cause);
    }

    @Override
    public void disconnect(ChannelHandlerContext ctx2, ChannelPromise promise) throws Exception {
        this.resetReadAndFlushIfNeeded(ctx2);
        ctx2.disconnect(promise);
    }

    @Override
    public void close(ChannelHandlerContext ctx2, ChannelPromise promise) throws Exception {
        this.resetReadAndFlushIfNeeded(ctx2);
        ctx2.close(promise);
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext ctx2) throws Exception {
        if (!ctx2.channel().isWritable()) {
            this.flushIfNeeded(ctx2);
        }
        ctx2.fireChannelWritabilityChanged();
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx2) throws Exception {
        this.flushIfNeeded(ctx2);
    }

    private void resetReadAndFlushIfNeeded(ChannelHandlerContext ctx2) {
        this.readInProgress = false;
        this.flushIfNeeded(ctx2);
    }

    private void flushIfNeeded(ChannelHandlerContext ctx2) {
        if (this.flushPendingCount > 0) {
            this.flushNow(ctx2);
        }
    }

    private void flushNow(ChannelHandlerContext ctx2) {
        this.cancelScheduledFlush();
        this.flushPendingCount = 0;
        ctx2.flush();
    }

    private void scheduleFlush(ChannelHandlerContext ctx2) {
        if (this.nextScheduledFlush == null) {
            this.nextScheduledFlush = ctx2.channel().eventLoop().submit(this.flushTask);
        }
    }

    private void cancelScheduledFlush() {
        if (this.nextScheduledFlush != null) {
            this.nextScheduledFlush.cancel(false);
            this.nextScheduledFlush = null;
        }
    }
}

