/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ipfilter;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.SocketAddress;

public abstract class AbstractRemoteAddressFilter<T extends SocketAddress>
extends ChannelInboundHandlerAdapter {
    @Override
    public void channelRegistered(ChannelHandlerContext ctx2) throws Exception {
        this.handleNewChannel(ctx2);
        ctx2.fireChannelRegistered();
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx2) throws Exception {
        if (!this.handleNewChannel(ctx2)) {
            throw new IllegalStateException("cannot determine to accept or reject a channel: " + ctx2.channel());
        }
        ctx2.fireChannelActive();
    }

    private boolean handleNewChannel(ChannelHandlerContext ctx2) throws Exception {
        SocketAddress remoteAddress = ctx2.channel().remoteAddress();
        if (remoteAddress == null) {
            return false;
        }
        ctx2.pipeline().remove(this);
        if (this.accept(ctx2, remoteAddress)) {
            this.channelAccepted(ctx2, remoteAddress);
        } else {
            ChannelFuture rejectedFuture = this.channelRejected(ctx2, remoteAddress);
            if (rejectedFuture != null) {
                rejectedFuture.addListener(ChannelFutureListener.CLOSE);
            } else {
                ctx2.close();
            }
        }
        return true;
    }

    protected abstract boolean accept(ChannelHandlerContext var1, T var2) throws Exception;

    protected void channelAccepted(ChannelHandlerContext ctx2, T remoteAddress) {
    }

    protected ChannelFuture channelRejected(ChannelHandlerContext ctx2, T remoteAddress) {
        return null;
    }
}

