/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.logging;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.logging.ByteBufFormat;
import io.netty.handler.logging.LogLevel;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;

@ChannelHandler.Sharable
public class LoggingHandler
extends ChannelDuplexHandler {
    private static final LogLevel DEFAULT_LEVEL = LogLevel.DEBUG;
    protected final InternalLogger logger;
    protected final InternalLogLevel internalLevel;
    private final LogLevel level;
    private final ByteBufFormat byteBufFormat;

    public LoggingHandler() {
        this(DEFAULT_LEVEL);
    }

    public LoggingHandler(ByteBufFormat format) {
        this(DEFAULT_LEVEL, format);
    }

    public LoggingHandler(LogLevel level) {
        this(level, ByteBufFormat.HEX_DUMP);
    }

    public LoggingHandler(LogLevel level, ByteBufFormat byteBufFormat) {
        this.level = ObjectUtil.checkNotNull(level, "level");
        this.byteBufFormat = ObjectUtil.checkNotNull(byteBufFormat, "byteBufFormat");
        this.logger = InternalLoggerFactory.getInstance(this.getClass());
        this.internalLevel = level.toInternalLevel();
    }

    public LoggingHandler(Class<?> clazz) {
        this(clazz, DEFAULT_LEVEL);
    }

    public LoggingHandler(Class<?> clazz, LogLevel level) {
        this(clazz, level, ByteBufFormat.HEX_DUMP);
    }

    public LoggingHandler(Class<?> clazz, LogLevel level, ByteBufFormat byteBufFormat) {
        ObjectUtil.checkNotNull(clazz, "clazz");
        this.level = ObjectUtil.checkNotNull(level, "level");
        this.byteBufFormat = ObjectUtil.checkNotNull(byteBufFormat, "byteBufFormat");
        this.logger = InternalLoggerFactory.getInstance(clazz);
        this.internalLevel = level.toInternalLevel();
    }

    public LoggingHandler(String name) {
        this(name, DEFAULT_LEVEL);
    }

    public LoggingHandler(String name, LogLevel level) {
        this(name, level, ByteBufFormat.HEX_DUMP);
    }

    public LoggingHandler(String name, LogLevel level, ByteBufFormat byteBufFormat) {
        ObjectUtil.checkNotNull(name, "name");
        this.level = ObjectUtil.checkNotNull(level, "level");
        this.byteBufFormat = ObjectUtil.checkNotNull(byteBufFormat, "byteBufFormat");
        this.logger = InternalLoggerFactory.getInstance(name);
        this.internalLevel = level.toInternalLevel();
    }

    public LogLevel level() {
        return this.level;
    }

    public ByteBufFormat byteBufFormat() {
        return this.byteBufFormat;
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx2) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "REGISTERED"));
        }
        ctx2.fireChannelRegistered();
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext ctx2) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "UNREGISTERED"));
        }
        ctx2.fireChannelUnregistered();
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx2) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "ACTIVE"));
        }
        ctx2.fireChannelActive();
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx2) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "INACTIVE"));
        }
        ctx2.fireChannelInactive();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx2, Throwable cause) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "EXCEPTION", cause), cause);
        }
        ctx2.fireExceptionCaught(cause);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx2, Object evt) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "USER_EVENT", evt));
        }
        ctx2.fireUserEventTriggered(evt);
    }

    @Override
    public void bind(ChannelHandlerContext ctx2, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "BIND", localAddress));
        }
        ctx2.bind(localAddress, promise);
    }

    @Override
    public void connect(ChannelHandlerContext ctx2, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "CONNECT", remoteAddress, localAddress));
        }
        ctx2.connect(remoteAddress, localAddress, promise);
    }

    @Override
    public void disconnect(ChannelHandlerContext ctx2, ChannelPromise promise) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "DISCONNECT"));
        }
        ctx2.disconnect(promise);
    }

    @Override
    public void close(ChannelHandlerContext ctx2, ChannelPromise promise) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "CLOSE"));
        }
        ctx2.close(promise);
    }

    @Override
    public void deregister(ChannelHandlerContext ctx2, ChannelPromise promise) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "DEREGISTER"));
        }
        ctx2.deregister(promise);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx2) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "READ COMPLETE"));
        }
        ctx2.fireChannelReadComplete();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx2, Object msg) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "READ", msg));
        }
        ctx2.fireChannelRead(msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx2, Object msg, ChannelPromise promise) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "WRITE", msg));
        }
        ctx2.write(msg, promise);
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext ctx2) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "WRITABILITY CHANGED"));
        }
        ctx2.fireChannelWritabilityChanged();
    }

    @Override
    public void flush(ChannelHandlerContext ctx2) throws Exception {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx2, "FLUSH"));
        }
        ctx2.flush();
    }

    protected String format(ChannelHandlerContext ctx2, String eventName) {
        String chStr = ctx2.channel().toString();
        return new StringBuilder(chStr.length() + 1 + eventName.length()).append(chStr).append(' ').append(eventName).toString();
    }

    protected String format(ChannelHandlerContext ctx2, String eventName, Object arg) {
        if (arg instanceof ByteBuf) {
            return this.formatByteBuf(ctx2, eventName, (ByteBuf)arg);
        }
        if (arg instanceof ByteBufHolder) {
            return this.formatByteBufHolder(ctx2, eventName, (ByteBufHolder)arg);
        }
        return LoggingHandler.formatSimple(ctx2, eventName, arg);
    }

    protected String format(ChannelHandlerContext ctx2, String eventName, Object firstArg, Object secondArg) {
        if (secondArg == null) {
            return LoggingHandler.formatSimple(ctx2, eventName, firstArg);
        }
        String chStr = ctx2.channel().toString();
        String arg1Str = String.valueOf(firstArg);
        String arg2Str = secondArg.toString();
        StringBuilder buf2 = new StringBuilder(chStr.length() + 1 + eventName.length() + 2 + arg1Str.length() + 2 + arg2Str.length());
        buf2.append(chStr).append(' ').append(eventName).append(": ").append(arg1Str).append(", ").append(arg2Str);
        return buf2.toString();
    }

    private String formatByteBuf(ChannelHandlerContext ctx2, String eventName, ByteBuf msg) {
        String chStr = ctx2.channel().toString();
        int length = msg.readableBytes();
        if (length == 0) {
            StringBuilder buf2 = new StringBuilder(chStr.length() + 1 + eventName.length() + 4);
            buf2.append(chStr).append(' ').append(eventName).append(": 0B");
            return buf2.toString();
        }
        int outputLength = chStr.length() + 1 + eventName.length() + 2 + 10 + 1;
        if (this.byteBufFormat == ByteBufFormat.HEX_DUMP) {
            int rows = length / 16 + (length % 15 == 0 ? 0 : 1) + 4;
            int hexDumpLength = 2 + rows * 80;
            outputLength += hexDumpLength;
        }
        StringBuilder buf3 = new StringBuilder(outputLength);
        buf3.append(chStr).append(' ').append(eventName).append(": ").append(length).append('B');
        if (this.byteBufFormat == ByteBufFormat.HEX_DUMP) {
            buf3.append(StringUtil.NEWLINE);
            ByteBufUtil.appendPrettyHexDump(buf3, msg);
        }
        return buf3.toString();
    }

    private String formatByteBufHolder(ChannelHandlerContext ctx2, String eventName, ByteBufHolder msg) {
        String chStr = ctx2.channel().toString();
        String msgStr = msg.toString();
        ByteBuf content2 = msg.content();
        int length = content2.readableBytes();
        if (length == 0) {
            StringBuilder buf2 = new StringBuilder(chStr.length() + 1 + eventName.length() + 2 + msgStr.length() + 4);
            buf2.append(chStr).append(' ').append(eventName).append(", ").append(msgStr).append(", 0B");
            return buf2.toString();
        }
        int outputLength = chStr.length() + 1 + eventName.length() + 2 + msgStr.length() + 2 + 10 + 1;
        if (this.byteBufFormat == ByteBufFormat.HEX_DUMP) {
            int rows = length / 16 + (length % 15 == 0 ? 0 : 1) + 4;
            int hexDumpLength = 2 + rows * 80;
            outputLength += hexDumpLength;
        }
        StringBuilder buf3 = new StringBuilder(outputLength);
        buf3.append(chStr).append(' ').append(eventName).append(": ").append(msgStr).append(", ").append(length).append('B');
        if (this.byteBufFormat == ByteBufFormat.HEX_DUMP) {
            buf3.append(StringUtil.NEWLINE);
            ByteBufUtil.appendPrettyHexDump(buf3, content2);
        }
        return buf3.toString();
    }

    private static String formatSimple(ChannelHandlerContext ctx2, String eventName, Object msg) {
        String chStr = ctx2.channel().toString();
        String msgStr = String.valueOf(msg);
        StringBuilder buf2 = new StringBuilder(chStr.length() + 1 + eventName.length() + 2 + msgStr.length());
        return buf2.append(chStr).append(' ').append(eventName).append(": ").append(msgStr).toString();
    }
}

