/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.timeout;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.TimeUnit;

public class IdleStateHandler
extends ChannelDuplexHandler {
    private static final long MIN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private final ChannelFutureListener writeListener = new ChannelFutureListener(){

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            IdleStateHandler.this.lastWriteTime = IdleStateHandler.this.ticksInNanos();
            IdleStateHandler.this.firstWriterIdleEvent = (IdleStateHandler.this.firstAllIdleEvent = true);
        }
    };
    private final boolean observeOutput;
    private final long readerIdleTimeNanos;
    private final long writerIdleTimeNanos;
    private final long allIdleTimeNanos;
    private Future<?> readerIdleTimeout;
    private long lastReadTime;
    private boolean firstReaderIdleEvent = true;
    private Future<?> writerIdleTimeout;
    private long lastWriteTime;
    private boolean firstWriterIdleEvent = true;
    private Future<?> allIdleTimeout;
    private boolean firstAllIdleEvent = true;
    private byte state;
    private boolean reading;
    private long lastChangeCheckTimeStamp;
    private int lastMessageHashCode;
    private long lastPendingWriteBytes;
    private long lastFlushProgress;

    public IdleStateHandler(int readerIdleTimeSeconds, int writerIdleTimeSeconds, int allIdleTimeSeconds) {
        this(readerIdleTimeSeconds, writerIdleTimeSeconds, allIdleTimeSeconds, TimeUnit.SECONDS);
    }

    public IdleStateHandler(long readerIdleTime, long writerIdleTime, long allIdleTime, TimeUnit unit) {
        this(false, readerIdleTime, writerIdleTime, allIdleTime, unit);
    }

    public IdleStateHandler(boolean observeOutput, long readerIdleTime, long writerIdleTime, long allIdleTime, TimeUnit unit) {
        ObjectUtil.checkNotNull(unit, "unit");
        this.observeOutput = observeOutput;
        this.readerIdleTimeNanos = readerIdleTime <= 0L ? 0L : Math.max(unit.toNanos(readerIdleTime), MIN_TIMEOUT_NANOS);
        this.writerIdleTimeNanos = writerIdleTime <= 0L ? 0L : Math.max(unit.toNanos(writerIdleTime), MIN_TIMEOUT_NANOS);
        this.allIdleTimeNanos = allIdleTime <= 0L ? 0L : Math.max(unit.toNanos(allIdleTime), MIN_TIMEOUT_NANOS);
    }

    public long getReaderIdleTimeInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.readerIdleTimeNanos);
    }

    public long getWriterIdleTimeInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.writerIdleTimeNanos);
    }

    public long getAllIdleTimeInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.allIdleTimeNanos);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx2) throws Exception {
        if (ctx2.channel().isActive() && ctx2.channel().isRegistered()) {
            this.initialize(ctx2);
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx2) throws Exception {
        this.destroy();
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx2) throws Exception {
        if (ctx2.channel().isActive()) {
            this.initialize(ctx2);
        }
        super.channelRegistered(ctx2);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx2) throws Exception {
        this.initialize(ctx2);
        super.channelActive(ctx2);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx2) throws Exception {
        this.destroy();
        super.channelInactive(ctx2);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx2, Object msg) throws Exception {
        if (this.readerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) {
            this.reading = true;
            this.firstAllIdleEvent = true;
            this.firstReaderIdleEvent = true;
        }
        ctx2.fireChannelRead(msg);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx2) throws Exception {
        if ((this.readerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) && this.reading) {
            this.lastReadTime = this.ticksInNanos();
            this.reading = false;
        }
        ctx2.fireChannelReadComplete();
    }

    @Override
    public void write(ChannelHandlerContext ctx2, Object msg, ChannelPromise promise) throws Exception {
        if (this.writerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) {
            ctx2.write(msg, promise.unvoid()).addListener(this.writeListener);
        } else {
            ctx2.write(msg, promise);
        }
    }

    private void initialize(ChannelHandlerContext ctx2) {
        switch (this.state) {
            case 1: 
            case 2: {
                return;
            }
        }
        this.state = 1;
        this.initOutputChanged(ctx2);
        this.lastReadTime = this.lastWriteTime = this.ticksInNanos();
        if (this.readerIdleTimeNanos > 0L) {
            this.readerIdleTimeout = this.schedule(ctx2, new ReaderIdleTimeoutTask(ctx2), this.readerIdleTimeNanos, TimeUnit.NANOSECONDS);
        }
        if (this.writerIdleTimeNanos > 0L) {
            this.writerIdleTimeout = this.schedule(ctx2, new WriterIdleTimeoutTask(ctx2), this.writerIdleTimeNanos, TimeUnit.NANOSECONDS);
        }
        if (this.allIdleTimeNanos > 0L) {
            this.allIdleTimeout = this.schedule(ctx2, new AllIdleTimeoutTask(ctx2), this.allIdleTimeNanos, TimeUnit.NANOSECONDS);
        }
    }

    long ticksInNanos() {
        return System.nanoTime();
    }

    Future<?> schedule(ChannelHandlerContext ctx2, Runnable task2, long delay2, TimeUnit unit) {
        return ctx2.executor().schedule(task2, delay2, unit);
    }

    private void destroy() {
        this.state = (byte)2;
        if (this.readerIdleTimeout != null) {
            this.readerIdleTimeout.cancel(false);
            this.readerIdleTimeout = null;
        }
        if (this.writerIdleTimeout != null) {
            this.writerIdleTimeout.cancel(false);
            this.writerIdleTimeout = null;
        }
        if (this.allIdleTimeout != null) {
            this.allIdleTimeout.cancel(false);
            this.allIdleTimeout = null;
        }
    }

    protected void channelIdle(ChannelHandlerContext ctx2, IdleStateEvent evt) throws Exception {
        ctx2.fireUserEventTriggered(evt);
    }

    protected IdleStateEvent newIdleStateEvent(IdleState state2, boolean first2) {
        switch (state2) {
            case ALL_IDLE: {
                return first2 ? IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT : IdleStateEvent.ALL_IDLE_STATE_EVENT;
            }
            case READER_IDLE: {
                return first2 ? IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT : IdleStateEvent.READER_IDLE_STATE_EVENT;
            }
            case WRITER_IDLE: {
                return first2 ? IdleStateEvent.FIRST_WRITER_IDLE_STATE_EVENT : IdleStateEvent.WRITER_IDLE_STATE_EVENT;
            }
        }
        throw new IllegalArgumentException("Unhandled: state=" + (Object)((Object)state2) + ", first=" + first2);
    }

    private void initOutputChanged(ChannelHandlerContext ctx2) {
        Channel channel2;
        Channel.Unsafe unsafe;
        ChannelOutboundBuffer buf2;
        if (this.observeOutput && (buf2 = (unsafe = (channel2 = ctx2.channel()).unsafe()).outboundBuffer()) != null) {
            this.lastMessageHashCode = System.identityHashCode(buf2.current());
            this.lastPendingWriteBytes = buf2.totalPendingWriteBytes();
            this.lastFlushProgress = buf2.currentProgress();
        }
    }

    private boolean hasOutputChanged(ChannelHandlerContext ctx2, boolean first2) {
        if (this.observeOutput) {
            Channel channel2;
            Channel.Unsafe unsafe;
            ChannelOutboundBuffer buf2;
            if (this.lastChangeCheckTimeStamp != this.lastWriteTime) {
                this.lastChangeCheckTimeStamp = this.lastWriteTime;
                if (!first2) {
                    return true;
                }
            }
            if ((buf2 = (unsafe = (channel2 = ctx2.channel()).unsafe()).outboundBuffer()) != null) {
                long flushProgress;
                int messageHashCode = System.identityHashCode(buf2.current());
                long pendingWriteBytes = buf2.totalPendingWriteBytes();
                if (messageHashCode != this.lastMessageHashCode || pendingWriteBytes != this.lastPendingWriteBytes) {
                    this.lastMessageHashCode = messageHashCode;
                    this.lastPendingWriteBytes = pendingWriteBytes;
                    if (!first2) {
                        return true;
                    }
                }
                if ((flushProgress = buf2.currentProgress()) != this.lastFlushProgress) {
                    this.lastFlushProgress = flushProgress;
                    return !first2;
                }
            }
        }
        return false;
    }

    private final class AllIdleTimeoutTask
    extends AbstractIdleTask {
        AllIdleTimeoutTask(ChannelHandlerContext ctx2) {
            super(ctx2);
        }

        @Override
        protected void run(ChannelHandlerContext ctx2) {
            long nextDelay = IdleStateHandler.this.allIdleTimeNanos;
            if (!IdleStateHandler.this.reading) {
                nextDelay -= IdleStateHandler.this.ticksInNanos() - Math.max(IdleStateHandler.this.lastReadTime, IdleStateHandler.this.lastWriteTime);
            }
            if (nextDelay <= 0L) {
                IdleStateHandler.this.allIdleTimeout = IdleStateHandler.this.schedule(ctx2, this, IdleStateHandler.this.allIdleTimeNanos, TimeUnit.NANOSECONDS);
                boolean first2 = IdleStateHandler.this.firstAllIdleEvent;
                IdleStateHandler.this.firstAllIdleEvent = false;
                try {
                    if (IdleStateHandler.this.hasOutputChanged(ctx2, first2)) {
                        return;
                    }
                    IdleStateEvent event = IdleStateHandler.this.newIdleStateEvent(IdleState.ALL_IDLE, first2);
                    IdleStateHandler.this.channelIdle(ctx2, event);
                }
                catch (Throwable t) {
                    ctx2.fireExceptionCaught(t);
                }
            } else {
                IdleStateHandler.this.allIdleTimeout = IdleStateHandler.this.schedule(ctx2, this, nextDelay, TimeUnit.NANOSECONDS);
            }
        }
    }

    private final class WriterIdleTimeoutTask
    extends AbstractIdleTask {
        WriterIdleTimeoutTask(ChannelHandlerContext ctx2) {
            super(ctx2);
        }

        @Override
        protected void run(ChannelHandlerContext ctx2) {
            long lastWriteTime = IdleStateHandler.this.lastWriteTime;
            long nextDelay = IdleStateHandler.this.writerIdleTimeNanos - (IdleStateHandler.this.ticksInNanos() - lastWriteTime);
            if (nextDelay <= 0L) {
                IdleStateHandler.this.writerIdleTimeout = IdleStateHandler.this.schedule(ctx2, this, IdleStateHandler.this.writerIdleTimeNanos, TimeUnit.NANOSECONDS);
                boolean first2 = IdleStateHandler.this.firstWriterIdleEvent;
                IdleStateHandler.this.firstWriterIdleEvent = false;
                try {
                    if (IdleStateHandler.this.hasOutputChanged(ctx2, first2)) {
                        return;
                    }
                    IdleStateEvent event = IdleStateHandler.this.newIdleStateEvent(IdleState.WRITER_IDLE, first2);
                    IdleStateHandler.this.channelIdle(ctx2, event);
                }
                catch (Throwable t) {
                    ctx2.fireExceptionCaught(t);
                }
            } else {
                IdleStateHandler.this.writerIdleTimeout = IdleStateHandler.this.schedule(ctx2, this, nextDelay, TimeUnit.NANOSECONDS);
            }
        }
    }

    private final class ReaderIdleTimeoutTask
    extends AbstractIdleTask {
        ReaderIdleTimeoutTask(ChannelHandlerContext ctx2) {
            super(ctx2);
        }

        @Override
        protected void run(ChannelHandlerContext ctx2) {
            long nextDelay = IdleStateHandler.this.readerIdleTimeNanos;
            if (!IdleStateHandler.this.reading) {
                nextDelay -= IdleStateHandler.this.ticksInNanos() - IdleStateHandler.this.lastReadTime;
            }
            if (nextDelay <= 0L) {
                IdleStateHandler.this.readerIdleTimeout = IdleStateHandler.this.schedule(ctx2, this, IdleStateHandler.this.readerIdleTimeNanos, TimeUnit.NANOSECONDS);
                boolean first2 = IdleStateHandler.this.firstReaderIdleEvent;
                IdleStateHandler.this.firstReaderIdleEvent = false;
                try {
                    IdleStateEvent event = IdleStateHandler.this.newIdleStateEvent(IdleState.READER_IDLE, first2);
                    IdleStateHandler.this.channelIdle(ctx2, event);
                }
                catch (Throwable t) {
                    ctx2.fireExceptionCaught(t);
                }
            } else {
                IdleStateHandler.this.readerIdleTimeout = IdleStateHandler.this.schedule(ctx2, this, nextDelay, TimeUnit.NANOSECONDS);
            }
        }
    }

    private static abstract class AbstractIdleTask
    implements Runnable {
        private final ChannelHandlerContext ctx;

        AbstractIdleTask(ChannelHandlerContext ctx2) {
            this.ctx = ctx2;
        }

        @Override
        public void run() {
            if (!this.ctx.channel().isOpen()) {
                return;
            }
            this.run(this.ctx);
        }

        protected abstract void run(ChannelHandlerContext var1);
    }
}

