/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.h2.command.Prepared;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.mvstore.db.Store;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.table.Column;
import org.h2.value.TypeInfo;
import org.h2.value.ValueVarchar;

public class Explain
extends Prepared {
    private Prepared command;
    private LocalResult result;
    private boolean executeCommand;

    public Explain(SessionLocal sessionLocal) {
        super(sessionLocal);
    }

    public void setCommand(Prepared prepared2) {
        this.command = prepared2;
    }

    public Prepared getCommand() {
        return this.command;
    }

    @Override
    public void prepare() {
        this.command.prepare();
    }

    public void setExecuteCommand(boolean bl) {
        this.executeCommand = bl;
    }

    @Override
    public ResultInterface queryMeta() {
        return this.query(-1L);
    }

    @Override
    protected void checkParameters() {
        if (this.executeCommand) {
            super.checkParameters();
        }
    }

    @Override
    public ResultInterface query(long l) {
        Database database = this.session.getDatabase();
        Expression[] expressionArray = new Expression[]{new ExpressionColumn(database, new Column("PLAN", TypeInfo.TYPE_VARCHAR))};
        this.result = new LocalResult(this.session, expressionArray, 1, 1);
        int n = 8;
        if (l >= 0L) {
            String string;
            if (this.executeCommand) {
                Store store2 = null;
                if (database.isPersistent()) {
                    store2 = database.getStore();
                    store2.statisticsStart();
                }
                if (this.command.isQuery()) {
                    this.command.query(l);
                } else {
                    this.command.update();
                }
                string = this.command.getPlanSQL(n);
                Map<String, Integer> map2 = null;
                if (store2 != null) {
                    map2 = store2.statisticsEnd();
                }
                if (map2 != null) {
                    int n2 = 0;
                    for (Map.Entry<String, Integer> object : map2.entrySet()) {
                        n2 += object.getValue().intValue();
                    }
                    if (n2 > 0) {
                        map2 = new TreeMap<String, Integer>(map2);
                        StringBuilder stringBuilder = new StringBuilder();
                        if (map2.size() > 1) {
                            stringBuilder.append("total: ").append(n2).append('\n');
                        }
                        for (Map.Entry<String, Integer> entry : map2.entrySet()) {
                            int n3 = entry.getValue();
                            int n4 = (int)(100L * (long)n3 / (long)n2);
                            stringBuilder.append(entry.getKey()).append(": ").append(n3);
                            if (map2.size() > 1) {
                                stringBuilder.append(" (").append(n4).append("%)");
                            }
                            stringBuilder.append('\n');
                        }
                        string = string + "\n/*\n" + stringBuilder.toString() + "*/";
                    }
                }
            } else {
                string = this.command.getPlanSQL(n);
            }
            this.add(string);
        }
        this.result.done();
        return this.result;
    }

    private void add(String string) {
        this.result.addRow(ValueVarchar.get(string));
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return this.command.isReadOnly();
    }

    @Override
    public int getType() {
        return this.executeCommand ? 86 : 60;
    }

    @Override
    public void collectDependencies(HashSet<DbObject> hashSet) {
        this.command.collectDependencies(hashSet);
    }
}

