/*
 * Decompiled with CFR 0.152.
 */
package org.h2.security;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.h2.util.Bits;

public class SHA256 {
    private SHA256() {
    }

    public static byte[] getHashWithSalt(byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[byArray2.length + byArray3.length];
        System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, byArray2.length, byArray3.length);
        return SHA256.getHash(byArray4, true);
    }

    public static byte[] getKeyPasswordHash(String string, char[] cArray) {
        String string2 = string + "@";
        byte[] byArray2 = new byte[2 * (string2.length() + cArray.length)];
        int n = 0;
        int n2 = string2.length();
        for (int i = 0; i < n2; ++i) {
            int n3 = string2.charAt(i);
            byArray2[n++] = (byte)(n3 >> 8);
            byArray2[n++] = (byte)n3;
        }
        for (char c : cArray) {
            byArray2[n++] = (byte)(c >> 8);
            byArray2[n++] = (byte)c;
        }
        Arrays.fill(cArray, '\u0000');
        return SHA256.getHash(byArray2, true);
    }

    public static byte[] getHMAC(byte[] byArray2, byte[] byArray3) {
        return SHA256.initMac(byArray2).doFinal(byArray3);
    }

    private static Mac initMac(byte[] byArray2) {
        if (byArray2.length == 0) {
            byArray2 = new byte[1];
        }
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(byArray2, "HmacSHA256"));
            return mac;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException(generalSecurityException);
        }
    }

    public static byte[] getPBKDF2(byte[] byArray2, byte[] byArray3, int n, int n2) {
        byte[] byArray4 = new byte[n2];
        Mac mac = SHA256.initMac(byArray2);
        int n3 = 64 + Math.max(32, byArray3.length + 4);
        byte[] byArray5 = new byte[n3];
        byte[] byArray6 = null;
        int n4 = 1;
        for (int i = 0; i < n2; i += 32) {
            for (int k = 0; k < n; ++k) {
                if (k == 0) {
                    System.arraycopy(byArray3, 0, byArray5, 0, byArray3.length);
                    Bits.writeInt(byArray5, byArray3.length, n4);
                    n3 = byArray3.length + 4;
                } else {
                    System.arraycopy(byArray6, 0, byArray5, 0, 32);
                    n3 = 32;
                }
                mac.update(byArray5, 0, n3);
                byArray6 = mac.doFinal();
                for (int i2 = 0; i2 < 32 && i2 + i < n2; ++i2) {
                    int n5 = i2 + i;
                    byArray4[n5] = (byte)(byArray4[n5] ^ byArray6[i2]);
                }
            }
            ++n4;
        }
        Arrays.fill(byArray2, (byte)0);
        return byArray4;
    }

    public static byte[] getHash(byte[] byArray2, boolean bl) {
        byte[] byArray3;
        try {
            byArray3 = MessageDigest.getInstance("SHA-256").digest(byArray2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        if (bl) {
            Arrays.fill(byArray2, (byte)0);
        }
        return byArray3;
    }
}

