/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs.encrypt;

import org.h2.security.BlockCipher;

class XTS {
    private static final int GF_128_FEEDBACK = 135;
    private static final int CIPHER_BLOCK_SIZE = 16;
    private final BlockCipher cipher;

    XTS(BlockCipher blockCipher) {
        this.cipher = blockCipher;
    }

    void encrypt(long l, int n, byte[] byArray2, int n2) {
        byte[] byArray3 = this.initTweak(l);
        int n3 = 0;
        while (n3 + 16 <= n) {
            if (n3 > 0) {
                XTS.updateTweak(byArray3);
            }
            XTS.xorTweak(byArray2, n3 + n2, byArray3);
            this.cipher.encrypt(byArray2, n3 + n2, 16);
            XTS.xorTweak(byArray2, n3 + n2, byArray3);
            n3 += 16;
        }
        if (n3 < n) {
            XTS.updateTweak(byArray3);
            XTS.swap(byArray2, n3 + n2, n3 - 16 + n2, n - n3);
            XTS.xorTweak(byArray2, n3 - 16 + n2, byArray3);
            this.cipher.encrypt(byArray2, n3 - 16 + n2, 16);
            XTS.xorTweak(byArray2, n3 - 16 + n2, byArray3);
        }
    }

    void decrypt(long l, int n, byte[] byArray2, int n2) {
        byte[] byArray3;
        byte[] byArray4 = byArray3 = this.initTweak(l);
        int n3 = 0;
        while (n3 + 16 <= n) {
            if (n3 > 0) {
                XTS.updateTweak(byArray3);
                if (n3 + 16 + 16 > n && n3 + 16 < n) {
                    byArray4 = (byte[])byArray3.clone();
                    XTS.updateTweak(byArray3);
                }
            }
            XTS.xorTweak(byArray2, n3 + n2, byArray3);
            this.cipher.decrypt(byArray2, n3 + n2, 16);
            XTS.xorTweak(byArray2, n3 + n2, byArray3);
            n3 += 16;
        }
        if (n3 < n) {
            XTS.swap(byArray2, n3, n3 - 16 + n2, n - n3 + n2);
            XTS.xorTweak(byArray2, n3 - 16 + n2, byArray4);
            this.cipher.decrypt(byArray2, n3 - 16 + n2, 16);
            XTS.xorTweak(byArray2, n3 - 16 + n2, byArray4);
        }
    }

    private byte[] initTweak(long l) {
        byte[] byArray2 = new byte[16];
        int n = 0;
        while (n < 16) {
            byArray2[n] = (byte)(l & 0xFFL);
            ++n;
            l >>>= 8;
        }
        this.cipher.encrypt(byArray2, 0, 16);
        return byArray2;
    }

    private static void xorTweak(byte[] byArray2, int n, byte[] byArray3) {
        for (int i = 0; i < 16; ++i) {
            int n2 = n + i;
            byArray2[n2] = (byte)(byArray2[n2] ^ byArray3[i]);
        }
    }

    private static void updateTweak(byte[] byArray2) {
        int n = 0;
        byte by = 0;
        for (int i = 0; i < 16; ++i) {
            by = (byte)(byArray2[i] >> 7 & 1);
            byArray2[i] = (byte)((byArray2[i] << 1) + n & 0xFF);
            n = by;
        }
        if (by != 0) {
            byArray2[0] = (byte)(byArray2[0] ^ 0x87);
        }
    }

    private static void swap(byte[] byArray2, int n, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            byte by = byArray2[n + i];
            byArray2[n + i] = byArray2[n2 + i];
            byArray2[n2 + i] = by;
        }
    }
}

