/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.UUID;

public final class Bits {
    public static int compareNotNull(char[] cArray, char[] cArray2) {
        if (cArray == cArray2) {
            return 0;
        }
        int n = Math.min(cArray.length, cArray2.length);
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            char c2 = cArray2[i];
            if (c == c2) continue;
            return c > c2 ? 1 : -1;
        }
        return Integer.signum(cArray.length - cArray2.length);
    }

    public static int compareNotNullSigned(byte[] byArray2, byte[] byArray3) {
        if (byArray2 == byArray3) {
            return 0;
        }
        int n = Math.min(byArray2.length, byArray3.length);
        for (int i = 0; i < n; ++i) {
            byte by = byArray2[i];
            byte by2 = byArray3[i];
            if (by == by2) continue;
            return by > by2 ? 1 : -1;
        }
        return Integer.signum(byArray2.length - byArray3.length);
    }

    public static int compareNotNullUnsigned(byte[] byArray2, byte[] byArray3) {
        if (byArray2 == byArray3) {
            return 0;
        }
        int n = Math.min(byArray2.length, byArray3.length);
        for (int i = 0; i < n; ++i) {
            int n2 = byArray2[i] & 0xFF;
            int n3 = byArray3[i] & 0xFF;
            if (n2 == n3) continue;
            return n2 > n3 ? 1 : -1;
        }
        return Integer.signum(byArray2.length - byArray3.length);
    }

    public static int readInt(byte[] byArray2, int n) {
        return (byArray2[n++] << 24) + ((byArray2[n++] & 0xFF) << 16) + ((byArray2[n++] & 0xFF) << 8) + (byArray2[n] & 0xFF);
    }

    public static int readIntLE(byte[] byArray2, int n) {
        return (byArray2[n++] & 0xFF) + ((byArray2[n++] & 0xFF) << 8) + ((byArray2[n++] & 0xFF) << 16) + (byArray2[n] << 24);
    }

    public static long readLong(byte[] byArray2, int n) {
        return ((long)Bits.readInt(byArray2, n) << 32) + ((long)Bits.readInt(byArray2, n + 4) & 0xFFFFFFFFL);
    }

    public static long readLongLE(byte[] byArray2, int n) {
        return ((long)Bits.readIntLE(byArray2, n) & 0xFFFFFFFFL) + ((long)Bits.readIntLE(byArray2, n + 4) << 32);
    }

    public static double readDouble(byte[] byArray2, int n) {
        return Double.longBitsToDouble(Bits.readLong(byArray2, n));
    }

    public static double readDoubleLE(byte[] byArray2, int n) {
        return Double.longBitsToDouble(Bits.readLongLE(byArray2, n));
    }

    public static byte[] uuidToBytes(long l, long l2) {
        byte[] byArray2 = new byte[16];
        for (int i = 0; i < 8; ++i) {
            byArray2[i] = (byte)(l >> 8 * (7 - i) & 0xFFL);
            byArray2[8 + i] = (byte)(l2 >> 8 * (7 - i) & 0xFFL);
        }
        return byArray2;
    }

    public static byte[] uuidToBytes(UUID uUID) {
        return Bits.uuidToBytes(uUID.getMostSignificantBits(), uUID.getLeastSignificantBits());
    }

    public static void writeInt(byte[] byArray2, int n, int n2) {
        byArray2[n++] = (byte)(n2 >> 24);
        byArray2[n++] = (byte)(n2 >> 16);
        byArray2[n++] = (byte)(n2 >> 8);
        byArray2[n] = (byte)n2;
    }

    public static void writeIntLE(byte[] byArray2, int n, int n2) {
        byArray2[n++] = (byte)n2;
        byArray2[n++] = (byte)(n2 >> 8);
        byArray2[n++] = (byte)(n2 >> 16);
        byArray2[n] = (byte)(n2 >> 24);
    }

    public static void writeLong(byte[] byArray2, int n, long l) {
        Bits.writeInt(byArray2, n, (int)(l >> 32));
        Bits.writeInt(byArray2, n + 4, (int)l);
    }

    public static void writeLongLE(byte[] byArray2, int n, long l) {
        Bits.writeIntLE(byArray2, n, (int)l);
        Bits.writeIntLE(byArray2, n + 4, (int)(l >> 32));
    }

    public static void writeDouble(byte[] byArray2, int n, double d) {
        Bits.writeLong(byArray2, n, Double.doubleToRawLongBits(d));
    }

    public static void writeDoubleLE(byte[] byArray2, int n, double d) {
        Bits.writeLongLE(byArray2, n, Double.doubleToRawLongBits(d));
    }

    private Bits() {
    }
}

