/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.BasicBinaryColumnType;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/exposed/sql/BinaryColumnType;", "Lorg/jetbrains/exposed/sql/BasicBinaryColumnType;", "length", "", "(I)V", "getLength", "()I", "equals", "", "other", "", "hashCode", "sqlType", "", "validateValueBeforeUpdate", "", "value", "exposed-core"})
public class BinaryColumnType
extends BasicBinaryColumnType {
    private final int length;

    public BinaryColumnType(int length) {
        this.length = length;
    }

    public final int getLength() {
        return this.length;
    }

    @Override
    @NotNull
    public String sqlType() {
        return DefaultKt.getCurrentDialect().getDataTypeProvider().binaryType(this.length);
    }

    @Override
    public void validateValueBeforeUpdate(@Nullable Object value) {
        if (value instanceof byte[] && !(((byte[])value).length <= this.length)) {
            boolean bl = false;
            String string = "Value '" + value + "' can't be stored to database column because exceeds length (" + this.length + ')';
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.exposed.sql.BinaryColumnType");
        }
        BinaryColumnType cfr_ignored_0 = (BinaryColumnType)object2;
        return this.length == ((BinaryColumnType)other).length;
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.length;
        return result2;
    }
}

