/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.statements.api.ExposedBlob;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/exposed/sql/BlobColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "()V", "nonNullValueToString", "", "value", "", "notNullValueToDB", "readObject", "Lorg/jetbrains/exposed/sql/statements/api/ExposedBlob;", "rs", "Ljava/sql/ResultSet;", "index", "", "setParameter", "", "stmt", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "sqlType", "valueFromDB", "exposed-core"})
public final class BlobColumnType
extends ColumnType {
    public BlobColumnType() {
        super(false, 1, null);
    }

    @Override
    @NotNull
    public String sqlType() {
        return DefaultKt.getCurrentDialect().getDataTypeProvider().blobType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ExposedBlob valueFromDB(@NotNull Object value) {
        ExposedBlob exposedBlob;
        Intrinsics.checkNotNullParameter(value, "value");
        Object object = value;
        if (object instanceof ExposedBlob) {
            exposedBlob = (ExposedBlob)value;
        } else if (object instanceof Blob) {
            Closeable closeable = ((Blob)value).getBinaryStream();
            Throwable throwable = null;
            try {
                Object it = (InputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                it = ByteStreamsKt.readBytes((InputStream)it);
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            Object object2 = it;
            exposedBlob = new ExposedBlob((byte[])object2);
        } else if (object instanceof InputStream) {
            byte[] byArray2;
            Closeable closeable = (Closeable)value;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                byArray2 = ByteStreamsKt.readBytes(it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            byte[] byArray3 = byArray2;
            exposedBlob = new ExposedBlob(byArray3);
        } else if (object instanceof byte[]) {
            exposedBlob = new ExposedBlob((byte[])value);
        } else {
            throw new IllegalStateException(("Unexpected value of type Blob: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        return exposedBlob;
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull Object value) {
        Object object;
        Intrinsics.checkNotNullParameter(value, "value");
        if (value instanceof Blob) {
            InputStream inputStream2 = ((Blob)value).getBinaryStream();
            Intrinsics.checkNotNullExpressionValue(inputStream2, "{\n            value.binaryStream\n        }");
            object = inputStream2;
        } else {
            object = value;
        }
        return object;
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        Intrinsics.checkNotNullParameter(value, "value");
        return "?";
    }

    @Override
    @Nullable
    public ExposedBlob readObject(@NotNull ResultSet rs, int index) {
        ExposedBlob exposedBlob;
        Intrinsics.checkNotNullParameter(rs, "rs");
        byte[] byArray2 = rs.getBytes(index);
        if (byArray2 != null) {
            byte[] p0 = byArray2;
            boolean bl = false;
            exposedBlob = new ExposedBlob(p0);
        } else {
            exposedBlob = null;
        }
        return exposedBlob;
    }

    @Override
    public void setParameter(@NotNull PreparedStatementApi stmt, int index, @Nullable Object value) {
        byte[] byArray2;
        Object toSetValue;
        Intrinsics.checkNotNullParameter(stmt, "stmt");
        ExposedBlob exposedBlob = value instanceof ExposedBlob ? (ExposedBlob)value : null;
        Object object = toSetValue = exposedBlob != null && (byArray2 = exposedBlob.getBytes()) != null ? new ByteArrayInputStream(byArray2) : value;
        if (toSetValue instanceof InputStream) {
            stmt.setInputStream(index, (InputStream)toSetValue);
        } else {
            Object object2 = toSetValue;
            if (object2 == null ? true : object2 instanceof Op.NULL) {
                stmt.setNull(index, this);
            } else {
                super.setParameter(stmt, index, toSetValue);
            }
        }
    }
}

