/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.AndBitOp;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionKt;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.OpKt;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u0002H\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0003B)\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/exposed/sql/OrBitOp;", "T", "S", "Lorg/jetbrains/exposed/sql/ExpressionWithColumnType;", "expr1", "Lorg/jetbrains/exposed/sql/Expression;", "expr2", "columnType", "Lorg/jetbrains/exposed/sql/IColumnType;", "(Lorg/jetbrains/exposed/sql/Expression;Lorg/jetbrains/exposed/sql/Expression;Lorg/jetbrains/exposed/sql/IColumnType;)V", "getColumnType", "()Lorg/jetbrains/exposed/sql/IColumnType;", "getExpr1", "()Lorg/jetbrains/exposed/sql/Expression;", "getExpr2", "toQueryBuilder", "", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "exposed-core"})
public final class OrBitOp<T, S extends T>
extends ExpressionWithColumnType<T> {
    @NotNull
    private final Expression<T> expr1;
    @NotNull
    private final Expression<S> expr2;
    @NotNull
    private final IColumnType columnType;

    public OrBitOp(@NotNull Expression<T> expr1, @NotNull Expression<S> expr2, @NotNull IColumnType columnType) {
        Intrinsics.checkNotNullParameter(expr1, "expr1");
        Intrinsics.checkNotNullParameter(expr2, "expr2");
        Intrinsics.checkNotNullParameter(columnType, "columnType");
        this.expr1 = expr1;
        this.expr2 = expr2;
        this.columnType = columnType;
    }

    @NotNull
    public final Expression<T> getExpr1() {
        return this.expr1;
    }

    @NotNull
    public final Expression<S> getExpr2() {
        return this.expr2;
    }

    @Override
    @NotNull
    public IColumnType getColumnType() {
        return this.columnType;
    }

    @Override
    public void toQueryBuilder(@NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(this){
            final /* synthetic */ OrBitOp<T, S> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                DatabaseDialect dialect2 = DefaultKt.getCurrentDialectIfAvailable();
                if (dialect2 instanceof OracleDialect) {
                    Object[] objectArray = new Object[]{"(", this.this$0.getExpr1(), "+", this.this$0.getExpr2(), "-", new AndBitOp<T, S>(this.this$0.getExpr1(), this.this$0.getExpr2(), this.this$0.getColumnType()), ")"};
                    ExpressionKt.append($this$invoke, objectArray);
                } else if (dialect2 instanceof H2Dialect) {
                    boolean bl = ((H2Dialect)dialect2).isSecondVersion();
                    if (!bl) {
                        Object[] objectArray = new Object[]{"BITOR(", this.this$0.getExpr1(), ", ", this.this$0.getExpr2(), ")"};
                        ExpressionKt.append($this$invoke, objectArray);
                    } else if (bl) {
                        Object[] objectArray = new Object[]{"BITOR(", OpKt.access$castToExpressionTypeForH2BitWiseIps(this.this$0, this.this$0.getExpr1()), ", ", OpKt.access$castToExpressionTypeForH2BitWiseIps(this.this$0, this.this$0.getExpr2()), ")"};
                        ExpressionKt.append($this$invoke, objectArray);
                    }
                } else {
                    Object[] objectArray = new Object[]{Character.valueOf('('), this.this$0.getExpr1(), " | ", this.this$0.getExpr2(), Character.valueOf(')')};
                    ExpressionKt.append($this$invoke, objectArray);
                }
            }
        });
    }
}

