/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.ColumnTypeKt;
import org.jetbrains.exposed.sql.DdlAware;
import org.jetbrains.exposed.sql.DecimalColumnType;
import org.jetbrains.exposed.sql.EnumerationNameColumnType;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.LiteralOp;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.Sequence;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.InsertStatement;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.ColumnMetadata;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001HB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010\f\u001a\u00020\n2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\rJ\u001f\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\u0010J/\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ/\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00042\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000bJ3\u0010\u0014\u001a\u00020\u000f\"\b\b\u0000\u0010\u0015*\u00020\b2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00150\u0007\"\u0002H\u00152\b\b\u0002\u0010\u0016\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0017J)\u0010\u0018\u001a\u00020\u000f2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\"\u00020\u00052\b\b\u0002\u0010\u0016\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001aJ\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0007J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u001e\u001a\u00020\u001fJ\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010!\u001a\u00020\u0013J3\u0010\"\u001a\u00020\u000f2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b2\b\b\u0002\u0010\u0016\u001a\u00020\n2\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010#J)\u0010$\u001a\u00020\u000f2\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0\u0007\"\u00020&2\b\b\u0002\u0010\u0016\u001a\u00020\n\u00a2\u0006\u0002\u0010'J)\u0010(\u001a\u00020\u000f2\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020*0\u0007\"\u00020*2\b\b\u0002\u0010\u0016\u001a\u00020\n\u00a2\u0006\u0002\u0010+J%\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010-J)\u0010.\u001a\u00020\u000f2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b2\b\b\u0002\u0010\u0016\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0017J)\u0010/\u001a\u00020\u000f2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\"\u00020\u00052\b\b\u0002\u0010\u0016\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001aJ3\u00100\u001a\u00020\u000f2\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0\u0007\"\u00020&2\b\b\u0002\u00101\u001a\u00020\n2\b\b\u0002\u0010\u0016\u001a\u00020\n\u00a2\u0006\u0002\u00102J)\u00103\u001a\u00020\u000f2\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020*0\u0007\"\u00020*2\b\b\u0002\u0010\u0016\u001a\u00020\n\u00a2\u0006\u0002\u0010+J2\u00104\u001a\u0002H5\"\u0004\b\u0000\u001052\u0006\u00106\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\f\u00107\u001a\b\u0012\u0004\u0012\u0002H508H\u0082\b\u00a2\u0006\u0002\u00109J\u0018\u0010:\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020&2\b\b\u0002\u0010\u0016\u001a\u00020\nJ\u001a\u0010<\u001a\b\u0012\u0004\u0012\u00020\b0\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0=J/\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010?\u001a\u00020\u0005*\u00020@2\n\u0010A\u001a\u0006\u0012\u0002\b\u00030BH\u0002J\"\u0010C\u001a\u00020\u000f*\u00020D2\u0006\u0010\u0016\u001a\u00020\n2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u001e\u0010F\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u0015*\u00020D2\f\u0010G\u001a\b\u0012\u0004\u0012\u0002H\u001508\u00a8\u0006I"}, d2={"Lorg/jetbrains/exposed/sql/SchemaUtils;", "", "()V", "addMissingColumnsStatements", "", "", "tables", "", "Lorg/jetbrains/exposed/sql/Table;", "withLogs", "", "([Lorg/jetbrains/exposed/sql/Table;Z)Ljava/util/List;", "checkCycle", "([Lorg/jetbrains/exposed/sql/Table;)Z", "checkExcessiveIndices", "", "([Lorg/jetbrains/exposed/sql/Table;)V", "checkMappingConsistence", "checkMissingIndices", "Lorg/jetbrains/exposed/sql/Index;", "create", "T", "inBatch", "([Lorg/jetbrains/exposed/sql/Table;Z)V", "createDatabase", "databases", "([Ljava/lang/String;Z)V", "createFKey", "reference", "Lorg/jetbrains/exposed/sql/Column;", "foreignKey", "Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "createIndex", "index", "createMissingTablesAndColumns", "([Lorg/jetbrains/exposed/sql/Table;ZZ)V", "createSchema", "schemas", "Lorg/jetbrains/exposed/sql/Schema;", "([Lorg/jetbrains/exposed/sql/Schema;Z)V", "createSequence", "seq", "Lorg/jetbrains/exposed/sql/Sequence;", "([Lorg/jetbrains/exposed/sql/Sequence;Z)V", "createStatements", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/List;", "drop", "dropDatabase", "dropSchema", "cascade", "([Lorg/jetbrains/exposed/sql/Schema;ZZ)V", "dropSequence", "logTimeSpent", "R", "message", "block", "Lkotlin/Function0;", "(Ljava/lang/String;ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "setSchema", "schema", "sortTablesByReferences", "", "statementsRequiredToActualizeScheme", "dbDefaultToString", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "exp", "Lorg/jetbrains/exposed/sql/Expression;", "execStatements", "Lorg/jetbrains/exposed/sql/Transaction;", "statements", "withDataBaseLock", "body", "TableDepthGraph", "exposed-core"})
public final class SchemaUtils {
    @NotNull
    public static final SchemaUtils INSTANCE = new SchemaUtils();

    private SchemaUtils() {
    }

    private final <R> R logTimeSpent(String message2, boolean withLogs, Function0<? extends R> block2) {
        R r2;
        boolean $i$f$logTimeSpent = false;
        if (withLogs) {
            long start = System.currentTimeMillis();
            R answer = block2.invoke();
            SQLLogKt.getExposedLogger().info(message2 + " took " + (System.currentTimeMillis() - start) + "ms");
            r2 = answer;
        } else {
            r2 = block2.invoke();
        }
        return r2;
    }

    @NotNull
    public final List<Table> sortTablesByReferences(@NotNull Iterable<? extends Table> tables) {
        Intrinsics.checkNotNullParameter(tables, "tables");
        return new TableDepthGraph(tables).sorted();
    }

    public final boolean checkCycle(Table ... tables) {
        Intrinsics.checkNotNullParameter(tables, "tables");
        return new TableDepthGraph((Iterable<? extends Table>)ArraysKt.toList(tables)).hasCycle();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> createStatements(Table ... tables) {
        void $this$flatMapTo$iv$iv;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(tables, "tables");
        if (tables.length == 0) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$filterNot$iv = this.sortTablesByReferences((Iterable<? extends Table>)ArraysKt.toList(tables));
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Table it = (Table)element$iv$iv;
            boolean bl = false;
            if (QueriesKt.exists(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List toCreate = (List)destination$iv$iv;
        ArrayList alters = new ArrayList();
        Iterable $this$flatMap$iv = toCreate;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$flatMapTo$iv$iv2;
            Object element$iv2;
            Table table = (Table)element$iv$iv;
            boolean bl = false;
            Iterable $this$partition$iv = table.getDdl();
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv2 : $this$partition$iv) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                if (StringsKt.startsWith$default(it, "CREATE ", false, 2, null)) {
                    first$iv.add(element$iv2);
                    continue;
                }
                second$iv.add(element$iv2);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List create2 = pair.component1();
            List alter = pair.component2();
            Iterable $this$flatMap$iv2 = table.getIndices();
            boolean $i$f$flatMap2 = false;
            element$iv2 = $this$flatMap$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                Index it = (Index)element$iv$iv2;
                boolean bl3 = false;
                Iterable list$iv$iv = INSTANCE.createIndex(it);
                CollectionsKt.addAll(destination$iv$iv3, list$iv$iv);
            }
            List indicesDDL = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)alters, alter);
            Iterable list$iv$iv = CollectionsKt.plus((Collection)create2, (Iterable)indicesDDL);
            CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv2), (Iterable)alters);
    }

    /*
     * WARNING - void declaration
     */
    public final void createSequence(@NotNull Sequence[] seq, boolean inBatch) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(seq, "seq");
        Transaction $this$createSequence_u24lambda_u2d5 = TransactionManager.Companion.current();
        boolean bl = false;
        Sequence[] $this$flatMap$iv = seq;
        boolean $i$f$flatMap = false;
        Sequence[] sequenceArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$flatMapTo$iv$iv[i];
            boolean bl2 = false;
            Iterable list$iv$iv = it.createStatement();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List createStatements = (List)destination$iv$iv;
        INSTANCE.execStatements($this$createSequence_u24lambda_u2d5, inBatch, createStatements);
    }

    public static /* synthetic */ void createSequence$default(SchemaUtils schemaUtils, Sequence[] sequenceArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schemaUtils.createSequence(sequenceArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void dropSequence(@NotNull Sequence[] seq, boolean inBatch) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(seq, "seq");
        Transaction $this$dropSequence_u24lambda_u2d7 = TransactionManager.Companion.current();
        boolean bl = false;
        Sequence[] $this$flatMap$iv = seq;
        boolean $i$f$flatMap = false;
        Sequence[] sequenceArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$flatMapTo$iv$iv[i];
            boolean bl2 = false;
            Iterable list$iv$iv = it.dropStatement();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List dropStatements = (List)destination$iv$iv;
        INSTANCE.execStatements($this$dropSequence_u24lambda_u2d7, inBatch, dropStatements);
    }

    public static /* synthetic */ void dropSequence$default(SchemaUtils schemaUtils, Sequence[] sequenceArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schemaUtils.dropSequence(sequenceArray, bl);
    }

    @Deprecated(message="Will be removed in upcoming releases. Please use overloaded version instead", replaceWith=@ReplaceWith(expression="createFKey(checkNotNull(reference.foreignKey) { \"$reference does not reference anything\" })", imports={}), level=DeprecationLevel.WARNING)
    @NotNull
    public final List<String> createFKey(@NotNull Column<?> reference) {
        Intrinsics.checkNotNullParameter(reference, "reference");
        ForeignKeyConstraint foreignKey = reference.getForeignKey();
        if (!(foreignKey != null && (foreignKey.getDeleteRule() != null || foreignKey.getUpdateRule() != null))) {
            boolean bl = false;
            String string = reference + " does not reference anything";
            throw new IllegalArgumentException(string.toString());
        }
        return this.createFKey(foreignKey);
    }

    @NotNull
    public final List<String> createFKey(@NotNull ForeignKeyConstraint foreignKey) {
        boolean allTargetColumnsBelongToTheSameTable;
        ForeignKeyConstraint $this$createFKey_u24lambda_u2d16;
        block12: {
            boolean bl;
            boolean allFromColumnsBelongsToTheSameTable;
            block11: {
                boolean bl2;
                Intrinsics.checkNotNullParameter(foreignKey, "foreignKey");
                $this$createFKey_u24lambda_u2d16 = foreignKey;
                boolean bl3 = false;
                Iterable $this$all$iv = $this$createFKey_u24lambda_u2d16.getFrom();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Column it = (Column)element$iv;
                        boolean bl4 = false;
                        if (Intrinsics.areEqual(it.getTable(), $this$createFKey_u24lambda_u2d16.getFromTable())) continue;
                        bl2 = false;
                        break block11;
                    }
                    bl2 = allFromColumnsBelongsToTheSameTable = true;
                }
            }
            if (!allFromColumnsBelongsToTheSameTable) {
                boolean $i$a$-require-SchemaUtils$createFKey$2$62 = false;
                String $i$a$-require-SchemaUtils$createFKey$2$62 = "not all referencing columns of " + foreignKey + " belong to the same table";
                throw new IllegalArgumentException($i$a$-require-SchemaUtils$createFKey$2$62.toString());
            }
            Iterable $this$all$iv = $this$createFKey_u24lambda_u2d16.getTarget();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Column it = (Column)element$iv;
                    boolean bl5 = false;
                    if (Intrinsics.areEqual(it.getTable(), $this$createFKey_u24lambda_u2d16.getTargetTable())) continue;
                    bl = false;
                    break block12;
                }
                bl = allTargetColumnsBelongToTheSameTable = true;
            }
        }
        if (!allTargetColumnsBelongToTheSameTable) {
            boolean bl = false;
            String string = "not all referenced columns of " + foreignKey + " belong to the same table";
            throw new IllegalArgumentException(string.toString());
        }
        if (!($this$createFKey_u24lambda_u2d16.getFrom().size() == $this$createFKey_u24lambda_u2d16.getTarget().size())) {
            boolean $i$a$-require-SchemaUtils$createFKey$2$72 = false;
            String $i$a$-require-SchemaUtils$createFKey$2$72 = foreignKey + " referencing columns are not in accordance with referenced";
            throw new IllegalArgumentException($i$a$-require-SchemaUtils$createFKey$2$72.toString());
        }
        if (!($this$createFKey_u24lambda_u2d16.getDeleteRule() != null || $this$createFKey_u24lambda_u2d16.getUpdateRule() != null)) {
            boolean $i$a$-require-SchemaUtils$createFKey$2$82 = false;
            String $i$a$-require-SchemaUtils$createFKey$2$82 = foreignKey + " has no reference constraint actions";
            throw new IllegalArgumentException($i$a$-require-SchemaUtils$createFKey$2$82.toString());
        }
        if (!(CollectionsKt.toHashSet((Iterable)$this$createFKey_u24lambda_u2d16.getTarget()).size() == $this$createFKey_u24lambda_u2d16.getTarget().size())) {
            boolean bl = false;
            String string = "not all referenced columns of " + foreignKey + " are unique";
            throw new IllegalArgumentException(string.toString());
        }
        return $this$createFKey_u24lambda_u2d16.createStatement();
    }

    @NotNull
    public final List<String> createIndex(@NotNull Index index) {
        Intrinsics.checkNotNullParameter(index, "index");
        return index.createStatement();
    }

    private final String dbDefaultToString(DataTypeProvider $this$dbDefaultToString, Expression<?> exp) {
        String string;
        if (exp instanceof LiteralOp) {
            Object t = ((LiteralOp)exp).getValue();
            if (t instanceof Boolean) {
                DatabaseDialect databaseDialect = DefaultKt.getCurrentDialect();
                string = databaseDialect instanceof MysqlDialect ? (((Boolean)((LiteralOp)exp).getValue()).booleanValue() ? "1" : "0") : (databaseDialect instanceof PostgreSQLDialect ? ((LiteralOp)exp).getValue().toString() : $this$dbDefaultToString.booleanToStatementString((Boolean)((LiteralOp)exp).getValue()));
            } else if (t instanceof String) {
                string = DefaultKt.getCurrentDialect() instanceof PostgreSQLDialect ? ((LiteralOp)exp).getValue() + "'::character varying" : (String)((LiteralOp)exp).getValue();
            } else if (t instanceof Enum) {
                string = ((LiteralOp)exp).getColumnType() instanceof EnumerationNameColumnType ? (DefaultKt.getCurrentDialect() instanceof PostgreSQLDialect ? ((Enum)((LiteralOp)exp).getValue()).name() + "'::character varying" : ((Enum)((LiteralOp)exp).getValue()).name()) : $this$dbDefaultToString.processForDefaultValue(exp);
            } else if (t instanceof BigDecimal) {
                String string2 = DefaultKt.getCurrentDialect() instanceof MysqlDialect ? ((BigDecimal)((LiteralOp)exp).getValue()).setScale(((DecimalColumnType)((LiteralOp)exp).getColumnType()).getScale()).toString() : $this$dbDefaultToString.processForDefaultValue(exp);
                Intrinsics.checkNotNullExpressionValue(string2, "when (currentDialect) {\n\u2026ue(exp)\n                }");
                string = string2;
            } else {
                string = $this$dbDefaultToString.processForDefaultValue(exp);
            }
        } else {
            string = $this$dbDefaultToString.processForDefaultValue(exp);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> addMissingColumnsStatements(@NotNull Table[] tables, boolean withLogs) {
        Map<Table, List<ColumnMetadata>> map2;
        Intrinsics.checkNotNullParameter(tables, "tables");
        if (tables.length == 0) {
            return CollectionsKt.emptyList();
        }
        ArrayList statements = new ArrayList();
        SchemaUtils schemaUtils = this;
        String message$iv22 = "Extracting table columns";
        int $i$f$logTimeSpent22 = 0;
        if (withLogs) {
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            Map<Table, List<ColumnMetadata>> answer$iv = DefaultKt.getCurrentDialect().tableColumns(Arrays.copyOf(tables, tables.length));
            SQLLogKt.getExposedLogger().info(message$iv22 + " took " + (System.currentTimeMillis() - start$iv) + "ms");
            map2 = answer$iv;
        } else {
            boolean bl = false;
            map2 = DefaultKt.getCurrentDialect().tableColumns(Arrays.copyOf(tables, tables.length));
        }
        Map<Table, List<ColumnMetadata>> existingTablesColumns = map2;
        boolean dbSupportsAlterTableWithAddColumn = TransactionManager.Companion.current().getDb().getSupportsAlterTableWithAddColumn();
        $i$f$logTimeSpent22 = tables.length;
        for (int message$iv22 = 0; message$iv22 < $i$f$logTimeSpent22; ++message$iv22) {
            Map redoColumns;
            void $this$filterValues$iv;
            void $this$mapValuesTo$iv$iv;
            Map $this$mapValues$iv;
            void $this$forEach$iv;
            Object it;
            Object $this$filterTo$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            Table table = tables[message$iv22];
            List<ColumnMetadata> list = existingTablesColumns.get(table);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List<ColumnMetadata> thisTableExistingColumns = list;
            Iterable $this$mapNotNull$iv = table.getColumns();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Iterable<Pair<Column, ColumnMetadata>> destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach232 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Pair<Column, ColumnMetadata> it$iv$iv;
                ColumnMetadata existingColumn;
                Object v2;
                Column column;
                block26: {
                    Object element$iv$iv$iv;
                    Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    column = (Column)element$iv$iv2;
                    boolean bl2 = false;
                    Iterable iterable2 = thisTableExistingColumns;
                    for (Object object : iterable2) {
                        ColumnMetadata it2 = (ColumnMetadata)object;
                        boolean bl3 = false;
                        if (!StringsKt.equals(column.getName(), it2.getName(), true)) continue;
                        v2 = object;
                        break block26;
                    }
                    v2 = null;
                }
                ColumnMetadata columnMetadata = existingColumn = (ColumnMetadata)v2;
                if ((columnMetadata != null ? TuplesKt.to(column, columnMetadata) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Map existingTableColumns = MapsKt.toMap((List)destination$iv$iv);
            Iterable $this$filter$iv = table.getColumns();
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator $i$f$forEach232 = $this$filterTo$iv$iv.iterator();
            while ($i$f$forEach232.hasNext()) {
                Object t = $i$f$forEach232.next();
                it = (Column)t;
                boolean bl = false;
                boolean bl2 = !existingTableColumns.containsKey(it);
                if (!bl2) continue;
                destination$iv$iv2.add(t);
            }
            List missingTableColumns = (List)destination$iv$iv2;
            Iterable $this$flatMapTo$iv = missingTableColumns;
            boolean $i$f$flatMapTo = false;
            $this$filterTo$iv$iv = $this$flatMapTo$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                Object element$iv = $this$filterTo$iv$iv.next();
                Column it3 = (Column)element$iv;
                boolean bl = false;
                Iterable list$iv = it3.getDdl();
                CollectionsKt.addAll((Collection)statements, list$iv);
            }
            if (!dbSupportsAlterTableWithAddColumn) continue;
            $this$flatMapTo$iv = table.getIndices();
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            $i$f$filterTo = false;
            Iterator bl = $this$filterTo$iv$iv.iterator();
            while (bl.hasNext()) {
                boolean bl3;
                Object t;
                block27: {
                    t = bl.next();
                    Index index = (Index)t;
                    boolean bl6 = false;
                    Iterable $this$any$iv = index.getColumns();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Column it4 = (Column)element$iv;
                            boolean bl7 = false;
                            if (!missingTableColumns.contains(it4)) continue;
                            bl3 = true;
                            break block27;
                        }
                        bl3 = false;
                    }
                }
                if (!bl3) continue;
                destination$iv$iv3.add(t);
            }
            $this$filter$iv = (List)destination$iv$iv3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Index it5 = (Index)element$iv;
                boolean bl8 = false;
                statements.addAll(INSTANCE.createIndex(it5));
            }
            DataTypeProvider dataTypeProvider = DefaultKt.getCurrentDialect().getDataTypeProvider();
            $this$filterTo$iv$iv = existingTableColumns;
            boolean $i$f$mapValues = false;
            void it5 = $this$mapValues$iv;
            Map destination$iv$iv32 = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
            boolean bl4 = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                String string;
                void it$iv$iv;
                Object element$iv;
                Map.Entry bl2 = (Map.Entry)element$iv$iv$iv;
                element$iv = destination$iv$iv32;
                boolean bl9 = false;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Object object = element$iv;
                boolean bl10 = false;
                Column col = (Column)entry.getKey();
                ColumnMetadata existingCol = (ColumnMetadata)entry.getValue();
                IColumnType columnType = col.getColumnType();
                boolean incorrectNullability = existingCol.getNullable() != columnType.getNullable();
                boolean incorrectAutoInc = existingCol.getAutoIncrement() != ColumnTypeKt.isAutoInc(columnType);
                String string2 = existingCol.getDefaultDbValue();
                if (col.getDbDefaultValue$exposed_core() != null) {
                    void it6;
                    String string3 = string2;
                    boolean bl11 = false;
                    string = INSTANCE.dbDefaultToString(dataTypeProvider, (Expression<?>)it6);
                    string2 = string3;
                } else {
                    string = null;
                }
                boolean incorrectDefaults = !Intrinsics.areEqual(string2, string);
                boolean incorrectCaseSensitiveName = !Intrinsics.areEqual(DefaultKt.inProperCase(existingCol.getName()), col.nameInDatabaseCase());
                ColumnDiff columnDiff = new ColumnDiff(incorrectNullability, incorrectAutoInc, incorrectDefaults, incorrectCaseSensitiveName);
                object.put(k, (ColumnDiff)columnDiff);
            }
            $this$mapValues$iv = destination$iv$iv32;
            boolean $i$f$filterValues = false;
            Object result$iv = new LinkedHashMap();
            for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
                it = (ColumnDiff)entry.getValue();
                boolean bl12 = false;
                if (!((ColumnDiff)it).hasDifferences()) continue;
                ((HashMap)result$iv).put(entry.getKey(), entry.getValue());
            }
            Map $this$flatMapTo$iv2 = redoColumns = (Map)result$iv;
            boolean $i$f$flatMapTo2 = false;
            result$iv = $this$flatMapTo$iv2.entrySet().iterator();
            while (result$iv.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = (Map.Entry)result$iv.next();
                boolean bl13 = false;
                Column col = (Column)entry.getKey();
                ColumnDiff changedState = (ColumnDiff)entry.getValue();
                Iterable iterable3 = col.modifyStatements(changedState);
                CollectionsKt.addAll((Collection)statements, iterable3);
            }
        }
        if (dbSupportsAlterTableWithAddColumn) {
            void $this$flatMapTo$iv$iv;
            Map<Pair<Table, LinkedHashSet<Column<?>>>, List<ForeignKeyConstraint>> map3;
            SchemaUtils $i$f$logTimeSpent22 = this;
            String message$iv3 = "Extracting column constraints";
            boolean $i$f$logTimeSpent3 = false;
            if (withLogs) {
                long start$iv = System.currentTimeMillis();
                boolean bl = false;
                Map<Pair<Table, LinkedHashSet<Column<?>>>, List<ForeignKeyConstraint>> answer$iv = DefaultKt.getCurrentDialect().columnConstraints(Arrays.copyOf(tables, tables.length));
                SQLLogKt.getExposedLogger().info(message$iv3 + " took " + (System.currentTimeMillis() - start$iv) + "ms");
                map3 = answer$iv;
            } else {
                boolean bl = false;
                map3 = DefaultKt.getCurrentDialect().columnConstraints(Arrays.copyOf(tables, tables.length));
            }
            Map<Pair<Table, LinkedHashSet<Column<?>>>, List<ForeignKeyConstraint>> existingColumnConstraint = map3;
            Table[] $this$flatMap$iv = tables;
            boolean $i$f$flatMap = false;
            Table[] start$iv = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            int n = ((void)$this$flatMapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void $this$mapTo$iv$iv;
                void element$iv$iv;
                void table = element$iv$iv = $this$flatMapTo$iv$iv[i];
                boolean bl = false;
                Iterable iterable = table.getForeignKeys();
                boolean $i$f$map = false;
                Iterable col = iterable;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Object object;
                    ForeignKeyConstraint bl9 = (ForeignKeyConstraint)item$iv$iv;
                    object = destination$iv$iv4;
                    boolean bl14 = false;
                    List<ForeignKeyConstraint> list = existingColumnConstraint.get(TuplesKt.to(table, it.getFrom()));
                    object.add(TuplesKt.to(it, list != null ? CollectionsKt.firstOrNull(list) : null));
                }
                Iterable list$iv$iv = (List)destination$iv$iv4;
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            List foreignKeyConstraints = (List)destination$iv$iv;
            for (Pair pair : foreignKeyConstraints) {
                ForeignKeyConstraint foreignKey = (ForeignKeyConstraint)pair.component1();
                ForeignKeyConstraint existingConstraint = (ForeignKeyConstraint)pair.component2();
                if (existingConstraint == null) {
                    statements.addAll(this.createFKey(foreignKey));
                    continue;
                }
                if (Intrinsics.areEqual(existingConstraint.getTargetTable(), foreignKey.getTargetTable()) && foreignKey.getDeleteRule() == existingConstraint.getDeleteRule() && foreignKey.getUpdateRule() == existingConstraint.getUpdateRule()) continue;
                statements.addAll(existingConstraint.dropStatement());
                statements.addAll(this.createFKey(foreignKey));
            }
        }
        return statements;
    }

    public static /* synthetic */ List addMissingColumnsStatements$default(SchemaUtils schemaUtils, Table[] tableArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return schemaUtils.addMissingColumnsStatements(tableArray, bl);
    }

    private final void execStatements(Transaction $this$execStatements, boolean inBatch, List<String> statements) {
        if (inBatch) {
            $this$execStatements.execInBatch(statements);
        } else {
            for (String statement2 : statements) {
                Transaction.exec$default($this$execStatements, statement2, null, null, 6, null);
            }
        }
    }

    public final <T extends Table> void create(@NotNull T[] tables, boolean inBatch) {
        Intrinsics.checkNotNullParameter(tables, "tables");
        Transaction $this$create_u24lambda_u2d32 = TransactionManager.Companion.current();
        boolean bl = false;
        INSTANCE.execStatements($this$create_u24lambda_u2d32, inBatch, INSTANCE.createStatements((Table[])Arrays.copyOf(tables, tables.length)));
        $this$create_u24lambda_u2d32.commit();
        DefaultKt.getCurrentDialect().resetCaches();
    }

    public static /* synthetic */ void create$default(SchemaUtils schemaUtils, Table[] tableArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schemaUtils.create(tableArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void createDatabase(@NotNull String[] databases, boolean inBatch) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(databases, "databases");
        Transaction $this$createDatabase_u24lambda_u2d34 = TransactionManager.Companion.current();
        boolean bl = false;
        String[] $this$flatMap$iv = databases;
        boolean $i$f$flatMap = false;
        String[] stringArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$flatMapTo$iv$iv[i];
            boolean bl2 = false;
            Iterable list$iv$iv = CollectionsKt.listOf(DefaultKt.getCurrentDialect().createDatabase((String)it));
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List createStatements = (List)destination$iv$iv;
        INSTANCE.execStatements($this$createDatabase_u24lambda_u2d34, inBatch, createStatements);
    }

    public static /* synthetic */ void createDatabase$default(SchemaUtils schemaUtils, String[] stringArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schemaUtils.createDatabase(stringArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void dropDatabase(@NotNull String[] databases, boolean inBatch) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(databases, "databases");
        Transaction $this$dropDatabase_u24lambda_u2d36 = TransactionManager.Companion.current();
        boolean bl = false;
        String[] $this$flatMap$iv = databases;
        boolean $i$f$flatMap = false;
        String[] stringArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$flatMapTo$iv$iv[i];
            boolean bl2 = false;
            Iterable list$iv$iv = CollectionsKt.listOf(DefaultKt.getCurrentDialect().dropDatabase((String)it));
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List createStatements = (List)destination$iv$iv;
        INSTANCE.execStatements($this$dropDatabase_u24lambda_u2d36, inBatch, createStatements);
    }

    public static /* synthetic */ void dropDatabase$default(SchemaUtils schemaUtils, String[] stringArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schemaUtils.dropDatabase(stringArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void createMissingTablesAndColumns(@NotNull Table[] tables, boolean inBatch, boolean withLogs) {
        boolean bl;
        List<String> list;
        long start$iv;
        boolean bl2;
        List<String> list2;
        long start$iv2;
        Intrinsics.checkNotNullParameter(tables, "tables");
        Transaction $this$createMissingTablesAndColumns_u24lambda_u2d43 = TransactionManager.Companion.current();
        boolean bl3 = false;
        $this$createMissingTablesAndColumns_u24lambda_u2d43.getDb().getDialect().resetCaches();
        SchemaUtils schemaUtils = INSTANCE;
        Object message$iv = "Preparing create tables statements";
        boolean $i$f$logTimeSpent = false;
        if (withLogs) {
            start$iv2 = System.currentTimeMillis();
            boolean bl4 = false;
            List<String> answer$iv = INSTANCE.createStatements(Arrays.copyOf(tables, tables.length));
            SQLLogKt.getExposedLogger().info((String)message$iv + " took " + (System.currentTimeMillis() - start$iv2) + "ms");
            list2 = answer$iv;
        } else {
            boolean bl5 = false;
            list2 = INSTANCE.createStatements(Arrays.copyOf(tables, tables.length));
        }
        List<String> createStatements = list2;
        SchemaUtils this_$iv = INSTANCE;
        message$iv = "Executing create tables statements";
        $i$f$logTimeSpent = false;
        if (withLogs) {
            start$iv2 = System.currentTimeMillis();
            bl2 = false;
            INSTANCE.execStatements($this$createMissingTablesAndColumns_u24lambda_u2d43, inBatch, createStatements);
            $this$createMissingTablesAndColumns_u24lambda_u2d43.commit();
            Unit answer$iv = Unit.INSTANCE;
            SQLLogKt.getExposedLogger().info((String)message$iv + " took " + (System.currentTimeMillis() - start$iv2) + "ms");
        } else {
            bl2 = false;
            INSTANCE.execStatements($this$createMissingTablesAndColumns_u24lambda_u2d43, inBatch, createStatements);
            $this$createMissingTablesAndColumns_u24lambda_u2d43.commit();
        }
        message$iv = INSTANCE;
        Object message$iv2 = "Preparing alter table statements";
        boolean $i$f$logTimeSpent2 = false;
        if (withLogs) {
            start$iv = System.currentTimeMillis();
            boolean bl6 = false;
            List<String> answer$iv = INSTANCE.addMissingColumnsStatements(Arrays.copyOf(tables, tables.length), withLogs);
            SQLLogKt.getExposedLogger().info((String)message$iv2 + " took " + (System.currentTimeMillis() - start$iv) + "ms");
            list = answer$iv;
        } else {
            boolean bl7 = false;
            list = INSTANCE.addMissingColumnsStatements(Arrays.copyOf(tables, tables.length), withLogs);
        }
        List<String> alterStatements = list;
        SchemaUtils this_$iv2 = INSTANCE;
        message$iv2 = "Executing alter table statements";
        $i$f$logTimeSpent2 = false;
        if (withLogs) {
            start$iv = System.currentTimeMillis();
            bl = false;
            INSTANCE.execStatements($this$createMissingTablesAndColumns_u24lambda_u2d43, inBatch, alterStatements);
            $this$createMissingTablesAndColumns_u24lambda_u2d43.commit();
            Unit answer$iv = Unit.INSTANCE;
            SQLLogKt.getExposedLogger().info((String)message$iv2 + " took " + (System.currentTimeMillis() - start$iv) + "ms");
        } else {
            bl = false;
            INSTANCE.execStatements($this$createMissingTablesAndColumns_u24lambda_u2d43, inBatch, alterStatements);
            $this$createMissingTablesAndColumns_u24lambda_u2d43.commit();
        }
        List executedStatements = CollectionsKt.plus((Collection)createStatements, (Iterable)alterStatements);
        message$iv2 = INSTANCE;
        String message$iv3 = "Checking mapping consistence";
        boolean $i$f$logTimeSpent3 = false;
        if (withLogs) {
            void $this$filterTo$iv$iv;
            long start$iv3 = System.currentTimeMillis();
            boolean bl8 = false;
            Iterable $this$filter$iv = INSTANCE.checkMappingConsistence(Arrays.copyOf(tables, tables.length), withLogs);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl9 = false;
                if (!(!executedStatements.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List modifyTablesStatements = (List)destination$iv$iv;
            INSTANCE.execStatements($this$createMissingTablesAndColumns_u24lambda_u2d43, inBatch, modifyTablesStatements);
            $this$createMissingTablesAndColumns_u24lambda_u2d43.commit();
            Unit answer$iv = Unit.INSTANCE;
            SQLLogKt.getExposedLogger().info(message$iv3 + " took " + (System.currentTimeMillis() - start$iv3) + "ms");
        } else {
            boolean bl10 = false;
            Iterable $this$filter$iv = INSTANCE.checkMappingConsistence(Arrays.copyOf(tables, tables.length), withLogs);
            boolean $i$f$filter = false;
            Iterable $this$filterTo$iv$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl11 = false;
                if (!(!executedStatements.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List modifyTablesStatements = (List)destination$iv$iv;
            INSTANCE.execStatements($this$createMissingTablesAndColumns_u24lambda_u2d43, inBatch, modifyTablesStatements);
            $this$createMissingTablesAndColumns_u24lambda_u2d43.commit();
        }
        $this$createMissingTablesAndColumns_u24lambda_u2d43.getDb().getDialect().resetCaches();
    }

    public static /* synthetic */ void createMissingTablesAndColumns$default(SchemaUtils schemaUtils, Table[] tableArray, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        schemaUtils.createMissingTablesAndColumns(tableArray, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> statementsRequiredToActualizeScheme(@NotNull Table[] tables, boolean withLogs) {
        List list;
        Collection destination$iv$iv;
        Collection thisCollection$iv;
        List<String> list2;
        Table[] tableArray;
        Collection thisCollection$iv2;
        List<String> list3;
        Intrinsics.checkNotNullParameter(tables, "tables");
        Table[] $this$partition$iv = tables;
        boolean $i$f$partition = false;
        ArrayList<Table> first$iv = new ArrayList<Table>();
        Object second$iv = new ArrayList<Table>();
        int n = $this$partition$iv.length;
        for (int i = 0; i < n; ++i) {
            Table element$iv;
            Table it = element$iv = $this$partition$iv[i];
            boolean bl = false;
            if (!QueriesKt.exists(it)) {
                first$iv.add(element$iv);
                continue;
            }
            ((ArrayList)second$iv).add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List tablesToCreate = pair.component1();
        List tablesToAlter = pair.component2();
        second$iv = this;
        Object message$iv = "Preparing create tables statements";
        boolean $i$f$logTimeSpent = false;
        if (withLogs) {
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            Collection $this$toTypedArray$iv = tablesToCreate;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv3 = $this$toTypedArray$iv;
            Table[] tableArray2 = thisCollection$iv3.toArray(new Table[0]);
            if (tableArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            Table[] tableArray3 = tableArray2;
            List<String> answer$iv = INSTANCE.createStatements(Arrays.copyOf(tableArray3, tableArray3.length));
            SQLLogKt.getExposedLogger().info((String)message$iv + " took " + (System.currentTimeMillis() - start$iv) + "ms");
            list3 = answer$iv;
        } else {
            boolean bl = false;
            Collection $this$toTypedArray$iv = tablesToCreate;
            boolean $i$f$toTypedArray = false;
            thisCollection$iv2 = $this$toTypedArray$iv;
            Table[] tableArray4 = thisCollection$iv2.toArray(new Table[0]);
            if (tableArray4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            tableArray = tableArray4;
            list3 = INSTANCE.createStatements(Arrays.copyOf(tableArray, tableArray.length));
        }
        List<String> createStatements = list3;
        message$iv = this;
        String message$iv2 = "Preparing alter table statements";
        boolean $i$f$logTimeSpent22 = false;
        if (withLogs) {
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            Collection $this$toTypedArray$iv = tablesToAlter;
            boolean $i$f$toTypedArray = false;
            thisCollection$iv2 = $this$toTypedArray$iv;
            Table[] tableArray5 = thisCollection$iv2.toArray(new Table[0]);
            if (tableArray5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            tableArray = tableArray5;
            List<String> answer$iv = INSTANCE.addMissingColumnsStatements(Arrays.copyOf(tableArray, tableArray.length), withLogs);
            SQLLogKt.getExposedLogger().info(message$iv2 + " took " + (System.currentTimeMillis() - start$iv) + "ms");
            list2 = answer$iv;
        } else {
            boolean bl = false;
            Collection $this$toTypedArray$iv = tablesToAlter;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv4 = $this$toTypedArray$iv;
            Table[] tableArray6 = thisCollection$iv4.toArray(new Table[0]);
            if (tableArray6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            Table[] tableArray7 = tableArray6;
            list2 = INSTANCE.addMissingColumnsStatements(Arrays.copyOf(tableArray7, tableArray7.length), withLogs);
        }
        List<String> alterStatements = list2;
        List executedStatements = CollectionsKt.plus((Collection)createStatements, (Iterable)alterStatements);
        SchemaUtils $i$f$logTimeSpent22 = this;
        String message$iv3 = "Checking mapping consistence";
        boolean $i$f$logTimeSpent3 = false;
        if (withLogs) {
            void $this$filterTo$iv$iv;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            Collection $this$toTypedArray$iv = tablesToAlter;
            boolean $i$f$toTypedArray22 = false;
            thisCollection$iv = $this$toTypedArray$iv;
            Table[] tableArray8 = thisCollection$iv.toArray(new Table[0]);
            if (tableArray8 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            Table[] tableArray9 = tableArray8;
            Iterable $this$filter$iv = INSTANCE.checkMappingConsistence(Arrays.copyOf(tableArray9, tableArray9.length), withLogs);
            boolean $i$f$filter = false;
            Iterable $i$f$toTypedArray22 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (!(!executedStatements.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List answer$iv = (List)destination$iv$iv;
            SQLLogKt.getExposedLogger().info(message$iv3 + " took " + (System.currentTimeMillis() - start$iv) + "ms");
            list = answer$iv;
        } else {
            void $this$filterTo$iv$iv;
            boolean bl = false;
            Collection $this$toTypedArray$iv = tablesToAlter;
            boolean $i$f$toTypedArray32 = false;
            thisCollection$iv = $this$toTypedArray$iv;
            Table[] tableArray10 = thisCollection$iv.toArray(new Table[0]);
            if (tableArray10 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            Object $this$filter$iv = tableArray10;
            $this$filter$iv = INSTANCE.checkMappingConsistence(Arrays.copyOf($this$filter$iv, ((Table[])$this$filter$iv).length), withLogs);
            boolean $i$f$filter = false;
            Object $i$f$toTypedArray32 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                if (!(!executedStatements.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List modifyTablesStatements = list;
        return CollectionsKt.plus((Collection)executedStatements, (Iterable)modifyTablesStatements);
    }

    public static /* synthetic */ List statementsRequiredToActualizeScheme$default(SchemaUtils schemaUtils, Table[] tableArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return schemaUtils.statementsRequiredToActualizeScheme(tableArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> checkMappingConsistence(@NotNull Table[] tables, boolean withLogs) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(tables, "tables");
        if (withLogs) {
            this.checkExcessiveIndices(Arrays.copyOf(tables, tables.length));
        }
        Iterable $this$flatMap$iv = this.checkMissingIndices(Arrays.copyOf(tables, tables.length), withLogs);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Index it = (Index)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.createStatement();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List checkMappingConsistence$default(SchemaUtils schemaUtils, Table[] tableArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return schemaUtils.checkMappingConsistence(tableArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void checkExcessiveIndices(Table ... tables) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        void $this$flatMapTo$iv$iv;
        DdlAware it;
        Iterator<Object> value;
        Map.Entry element$iv;
        Iterator $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter(tables, "tables");
        Map<Pair<Table, LinkedHashSet<Column<?>>>, List<ForeignKeyConstraint>> $this$filter$iv2 = DefaultKt.getCurrentDialect().columnConstraints(Arrays.copyOf(tables, tables.length));
        boolean $i$f$filter = false;
        Map<Pair<Table, LinkedHashSet<Column<?>>>, List<ForeignKeyConstraint>> map2 = $this$filter$iv2;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo22 = false;
        Iterator iterator2 = $this$filterTo$iv$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(((List)entry.getValue()).size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map excessiveConstraints = destination$iv$iv;
        if (!excessiveConstraints.isEmpty()) {
            SQLLogKt.getExposedLogger().warn("List of excessive foreign key constraints:");
            Map $this$forEach$iv2 = excessiveConstraints;
            boolean $i$f$forEach = false;
            $this$filterTo$iv$iv2 = $this$forEach$iv2.entrySet().iterator();
            while ($this$filterTo$iv$iv2.hasNext()) {
                Map.Entry $i$f$filterTo22 = element$iv = $this$filterTo$iv$iv2.next();
                boolean bl = false;
                Pair pair = (Pair)$i$f$filterTo22.getKey();
                List list = (List)$i$f$filterTo22.getValue();
                ForeignKeyConstraint constraint = (ForeignKeyConstraint)CollectionsKt.first(list);
                String fkPartToLog2 = CollectionsKt.joinToString$default(list, ", ", null, null, 0, null, checkExcessiveIndices.1.fkPartToLog.1.INSTANCE, 30, null);
                SQLLogKt.getExposedLogger().warn("\t\t\t'" + pair.getFirst() + "'.'" + pair.getSecond() + "' -> '" + constraint.getFromTableName() + "':\t" + (String)fkPartToLog2);
            }
            SQLLogKt.getExposedLogger().info("SQL Queries to remove excessive keys:");
            Map $this$forEach$iv = excessiveConstraints;
            $i$f$forEach = false;
            $this$filterTo$iv$iv2 = $this$forEach$iv.entrySet().iterator();
            while ($this$filterTo$iv$iv2.hasNext()) {
                Map.Entry $i$f$filterTo22 = element$iv = $this$filterTo$iv$iv2.next();
                boolean bl = false;
                value = (List)$i$f$filterTo22.getValue();
                Iterable iterable = CollectionsKt.take((Iterable)((Object)value), value.size() - 1);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : iterable) {
                    it = (ForeignKeyConstraint)element$iv2;
                    boolean bl2 = false;
                    SQLLogKt.getExposedLogger().info("\t\t\t" + ((ForeignKeyConstraint)it).dropStatement() + ';');
                }
            }
        }
        Object $this$flatMap$iv = DefaultKt.getCurrentDialect().existingIndices(Arrays.copyOf(tables, tables.length));
        boolean $i$f$flatMap = false;
        element$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        value = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (value.hasNext()) {
            Map.Entry entry;
            Map.Entry it3 = entry = value.next();
            boolean bl = false;
            Iterable list$iv$iv = (List)it3.getValue();
            CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object t : $this$groupByTo$iv$iv) {
            Object object;
            Index it4 = (Index)t;
            boolean bl = false;
            Triple<Table, Boolean, String> key$iv$iv = new Triple<Table, Boolean, String>(it4.getTable(), it4.getUnique(), CollectionsKt.joinToString$default(it4.getColumns(), null, null, null, 0, null, checkExcessiveIndices.excessiveIndices.2.1.INSTANCE, 31, null));
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv3;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(t);
        }
        $this$groupBy$iv = destination$iv$iv3;
        boolean $i$f$filter2 = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$filterTo322 = false;
        value = $this$filterTo$iv$iv.entrySet().iterator();
        while (value.hasNext()) {
            Map.Entry entry;
            Map.Entry it5 = entry = (Map.Entry)value.next();
            boolean bl = false;
            if (!(((List)it5.getValue()).size() > 1)) continue;
            destination$iv$iv3.put(entry.getKey(), entry.getValue());
        }
        Map excessiveIndices2 = destination$iv$iv3;
        if (!excessiveIndices2.isEmpty()) {
            SQLLogKt.getExposedLogger().warn("List of excessive indices:");
            Map $this$forEach$iv3 = excessiveIndices2;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv3.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv3;
                Map.Entry $i$f$filterTo322 = element$iv3 = iterator3.next();
                boolean bl = false;
                Triple triple = (Triple)$i$f$filterTo322.getKey();
                List indices = (List)$i$f$filterTo322.getValue();
                SQLLogKt.getExposedLogger().warn("\t\t\t'" + ((Table)triple.getFirst()).getTableName() + "'.'" + (String)triple.getThird() + "' -> " + CollectionsKt.joinToString$default(indices, ", ", null, null, 0, null, checkExcessiveIndices.3.1.INSTANCE, 30, null));
            }
            SQLLogKt.getExposedLogger().info("SQL Queries to remove excessive indices:");
            Map $this$forEach$iv = excessiveIndices2;
            $i$f$forEach = false;
            iterator3 = $this$forEach$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv2;
                Map.Entry it6 = element$iv2 = iterator3.next();
                boolean bl = false;
                Iterable iterable = CollectionsKt.take((Iterable)it6.getValue(), ((List)it6.getValue()).size() - 1);
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : iterable) {
                    it = (Index)element$iv3;
                    boolean bl4 = false;
                    SQLLogKt.getExposedLogger().info("\t\t\t" + ((Index)it).dropStatement() + ';');
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Index> checkMissingIndices(Table[] tables, boolean withLogs) {
        Object object;
        boolean isMysql = DefaultKt.getCurrentDialect() instanceof MysqlDialect;
        boolean isSQLite = DefaultKt.getCurrentDialect() instanceof SQLiteDialect;
        Set<Pair<Table, LinkedHashSet<Column<?>>>> fKeyConstraints = DefaultKt.getCurrentDialect().columnConstraints(Arrays.copyOf(tables, tables.length)).keySet();
        Map<Table, List<Index>> existingIndices2 = DefaultKt.getCurrentDialect().existingIndices(Arrays.copyOf(tables, tables.length));
        HashSet missingIndices = new HashSet();
        HashMap notMappedIndices = new HashMap();
        HashSet<Index> nameDiffers = new HashSet<Index>();
        for (Table table : tables) {
            Object object2;
            void $this$getOrPut$iv;
            List<Index> list = existingIndices2.get(table);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List<Index> existingTableIndices = SchemaUtils.checkMissingIndices$filterInternalIndices(SchemaUtils.checkMissingIndices$filterFKeys(list, isMysql, fKeyConstraints), isSQLite);
            List<Index> mappedIndices = SchemaUtils.checkMissingIndices$filterInternalIndices(SchemaUtils.checkMissingIndices$filterFKeys(table.getIndices(), isMysql, fKeyConstraints), isSQLite);
            for (Index index : existingTableIndices) {
                Index mappedIndex;
                Object v1;
                block8: {
                    Iterable $this$firstOrNull$iv = mappedIndices;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Index it = (Index)element$iv;
                        boolean bl = false;
                        if (!it.onlyNameDiffer(index)) continue;
                        v1 = element$iv;
                        break block8;
                    }
                    v1 = null;
                }
                if ((Index)v1 == null) continue;
                if (withLogs) {
                    SQLLogKt.getExposedLogger().info("Index on table '" + table.getTableName() + "' differs only in name: in db " + index.getIndexName() + " -> in mapping " + mappedIndex.getIndexName());
                }
                nameDiffers.add(index);
                nameDiffers.add(mappedIndex);
            }
            object = notMappedIndices;
            String key$iv = table.nameInDatabaseCase();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = new HashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            ((Set)object2).addAll(CollectionsKt.subtract((Iterable)existingTableIndices, (Iterable)mappedIndices));
            missingIndices.addAll(CollectionsKt.subtract((Iterable)mappedIndices, (Iterable)existingTableIndices));
        }
        Set toCreate = CollectionsKt.subtract(missingIndices, (Iterable)nameDiffers);
        SchemaUtils.checkMissingIndices$log(toCreate, withLogs, "Indices missed from database (will be created):");
        Map $this$forEach$iv = notMappedIndices;
        boolean $i$f$forEach = false;
        for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
            object = element$iv;
            boolean bl = false;
            String name = (String)object.getKey();
            Set indexes = (Set)object.getValue();
            SchemaUtils.checkMissingIndices$log(CollectionsKt.subtract(indexes, (Iterable)nameDiffers), withLogs, "Indices exist in database and not mapped in code on class '" + name + "':");
        }
        return CollectionsKt.toList(toCreate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> void withDataBaseLock(@NotNull Transaction $this$withDataBaseLock, @NotNull Function0<? extends T> body2) {
        Intrinsics.checkNotNullParameter($this$withDataBaseLock, "<this>");
        Intrinsics.checkNotNullParameter(body2, "body");
        Table buzyTable2 = new Table(){
            @NotNull
            private final Column<Boolean> busy;
            {
                this.busy = Table.uniqueIndex$default((Table)this, this.bool("busy"), null, 1, null);
            }

            @NotNull
            public final Column<Boolean> getBusy() {
                return this.busy;
            }
        };
        withDataBaseLock.buzyTable.1[] nullArray2 = new withDataBaseLock.buzyTable.1[]{buzyTable2};
        SchemaUtils.create$default(this, nullArray2, false, 2, null);
        boolean isBusy = CollectionsKt.any(QueriesKt.selectAll(buzyTable2).forUpdate());
        if (!isBusy) {
            QueriesKt.insert((Table)buzyTable2, (Function2)new Function2<withDataBaseLock.buzyTable.1, InsertStatement<Number>, Unit>(buzyTable2){
                final /* synthetic */ withDataBaseLock.buzyTable.1 $buzyTable;
                {
                    this.$buzyTable = $buzyTable;
                    super(2);
                }

                public final void invoke(@NotNull withDataBaseLock.buzyTable.1 $this$insert, @NotNull InsertStatement<Number> it) {
                    Intrinsics.checkNotNullParameter($this$insert, "$this$insert");
                    Intrinsics.checkNotNullParameter(it, "it");
                    it.set(this.$buzyTable.getBusy(), true);
                }
            });
            try {
                body2.invoke();
            }
            finally {
                QueriesKt.deleteAll(buzyTable2);
                $this$withDataBaseLock.getConnection().commit();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void drop(@NotNull Table[] tables, boolean inBatch) {
        void $this$flatMapTo$iv$iv;
        Table it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(tables, "tables");
        if (tables.length == 0) {
            return;
        }
        Transaction $this$drop_u24lambda_u2d68 = TransactionManager.Companion.current();
        boolean bl = false;
        Iterable iterable = CollectionsKt.reversed((Iterable)INSTANCE.sortTablesByReferences((Iterable<? extends Table>)ArraysKt.toList(tables)));
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Table)element$iv$iv;
            boolean bl2 = false;
            if (!ArraysKt.contains(tables, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tablesForDeletion = (List)destination$iv$iv;
        if (!DefaultKt.getCurrentDialect().getSupportsIfNotExists()) {
            $this$filter$iv = tablesForDeletion;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Table)element$iv$iv;
                boolean bl3 = false;
                if (!QueriesKt.exists(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            tablesForDeletion = (List)destination$iv$iv;
        }
        Iterable $this$flatMap$iv = tablesForDeletion;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Table it2 = (Table)element$iv$iv;
            boolean bl4 = false;
            Iterable list$iv$iv = it2.dropStatement();
            CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        List dropStatements = (List)destination$iv$iv2;
        INSTANCE.execStatements($this$drop_u24lambda_u2d68, inBatch, dropStatements);
        DefaultKt.getCurrentDialect().resetCaches();
    }

    public static /* synthetic */ void drop$default(SchemaUtils schemaUtils, Table[] tableArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schemaUtils.drop(tableArray, bl);
    }

    public final void setSchema(@NotNull Schema schema2, boolean inBatch) {
        Intrinsics.checkNotNullParameter(schema2, "schema");
        Transaction $this$setSchema_u24lambda_u2d69 = TransactionManager.Companion.current();
        boolean bl = false;
        List<String> createStatements = schema2.setSchemaStatement();
        INSTANCE.execStatements($this$setSchema_u24lambda_u2d69, inBatch, createStatements);
        DatabaseDialect databaseDialect = DefaultKt.getCurrentDialect();
        if (databaseDialect instanceof MysqlDialect) {
            $this$setSchema_u24lambda_u2d69.getConnection().setCatalog(schema2.getIdentifier());
        } else if (databaseDialect instanceof H2Dialect) {
            $this$setSchema_u24lambda_u2d69.getConnection().setSchema(schema2.getIdentifier());
        }
        DefaultKt.getCurrentDialect().resetCaches();
        $this$setSchema_u24lambda_u2d69.getConnection().metadata(setSchema.1.1.INSTANCE);
    }

    public static /* synthetic */ void setSchema$default(SchemaUtils schemaUtils, Schema schema2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schemaUtils.setSchema(schema2, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void createSchema(@NotNull Schema[] schemas2, boolean inBatch) {
        void $this$flatMapTo$iv$iv;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(schemas2, "schemas");
        if (schemas2.length == 0) {
            return;
        }
        Transaction $this$createSchema_u24lambda_u2d72 = TransactionManager.Companion.current();
        boolean bl = false;
        Iterable $this$filterNot$iv = ArraysKt.distinct(schemas2);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Schema it = (Schema)element$iv$iv;
            boolean bl2 = false;
            if (it.exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List toCreate = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = toCreate;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Schema it = (Schema)element$iv$iv;
            boolean bl3 = false;
            Iterable list$iv$iv = it.createStatement();
            CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        List createStatements = (List)destination$iv$iv2;
        INSTANCE.execStatements($this$createSchema_u24lambda_u2d72, inBatch, createStatements);
        $this$createSchema_u24lambda_u2d72.commit();
        DefaultKt.getCurrentDialect().resetSchemaCaches();
    }

    public static /* synthetic */ void createSchema$default(SchemaUtils schemaUtils, Schema[] schemaArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schemaUtils.createSchema(schemaArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void dropSchema(@NotNull Schema[] schemas2, boolean cascade, boolean inBatch) {
        void $this$flatMapTo$iv$iv;
        Iterable destination$iv$iv;
        List list;
        Intrinsics.checkNotNullParameter(schemas2, "schemas");
        if (schemas2.length == 0) {
            return;
        }
        Transaction $this$dropSchema_u24lambda_u2d75 = TransactionManager.Companion.current();
        boolean bl = false;
        if (DefaultKt.getCurrentDialect().getSupportsIfNotExists()) {
            list = ArraysKt.distinct(schemas2);
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = ArraysKt.distinct(schemas2);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Schema it = (Schema)element$iv$iv;
                boolean bl2 = false;
                if (!it.exists()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List schemasForDeletion = list;
        Iterable $this$flatMap$iv = schemasForDeletion;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Schema it = (Schema)element$iv$iv;
            boolean bl3 = false;
            Iterable list$iv$iv = it.dropStatement(cascade);
            CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        List dropStatements = (List)destination$iv$iv2;
        INSTANCE.execStatements($this$dropSchema_u24lambda_u2d75, inBatch, dropStatements);
        DefaultKt.getCurrentDialect().resetSchemaCaches();
    }

    public static /* synthetic */ void dropSchema$default(SchemaUtils schemaUtils, Schema[] schemaArray, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        schemaUtils.dropSchema(schemaArray, bl, bl2);
    }

    private static final void checkMissingIndices$log(Collection<Index> $this$checkMissingIndices_u24log, boolean $withLogs, String mainMessage) {
        if ($withLogs && !$this$checkMissingIndices_u24log.isEmpty()) {
            String string = mainMessage + "\n\t\t";
            SQLLogKt.getExposedLogger().warn(CollectionsKt.joinToString$default($this$checkMissingIndices_u24log, "\n\t\t", string, null, 0, null, null, 60, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Index> checkMissingIndices$filterFKeys(List<Index> $this$checkMissingIndices_u24filterFKeys, boolean isMysql, Set<? extends Pair<? extends Table, ? extends LinkedHashSet<Column<?>>>> fKeyConstraints) {
        List list;
        if (isMysql) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = $this$checkMissingIndices_u24filterFKeys;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Index it = (Index)element$iv$iv;
                boolean bl = false;
                if (fKeyConstraints.contains(TuplesKt.to(it.getTable(), new LinkedHashSet(it.getColumns())))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = $this$checkMissingIndices_u24filterFKeys;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Index> checkMissingIndices$filterInternalIndices(List<Index> $this$checkMissingIndices_u24filterInternalIndices, boolean isSQLite) {
        List list;
        if (isSQLite) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = $this$checkMissingIndices_u24filterInternalIndices;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Index it = (Index)element$iv$iv;
                boolean bl = false;
                if (!(!StringsKt.startsWith$default(it.getIndexName(), "sqlite_", false, 2, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = $this$checkMissingIndices_u24filterInternalIndices;
        }
        return list;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u000ej\b\u0012\u0004\u0012\u00020\u0004`\u000fH\u0002J\u0006\u0010\u0010\u001a\u00020\bJ\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012R)\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/exposed/sql/SchemaUtils$TableDepthGraph;", "", "tables", "", "Lorg/jetbrains/exposed/sql/Table;", "(Ljava/lang/Iterable;)V", "graph", "", "", "getGraph", "()Ljava/util/Map;", "getTables", "()Ljava/lang/Iterable;", "fetchAllTables", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "hasCycle", "sorted", "", "exposed-core"})
    private static final class TableDepthGraph {
        @NotNull
        private final Iterable<Table> tables;
        @NotNull
        private final Map<Table, Map<Table, Boolean>> graph;

        /*
         * WARNING - void declaration
         */
        public TableDepthGraph(@NotNull Iterable<? extends Table> tables) {
            Map map2;
            void tables2;
            Intrinsics.checkNotNullParameter(tables, "tables");
            this.tables = tables;
            HashSet<Table> hashSet = this.fetchAllTables();
            TableDepthGraph tableDepthGraph = this;
            boolean bl = false;
            if (tables2.isEmpty()) {
                map2 = MapsKt.emptyMap();
            } else {
                Iterable $this$associateWith$iv = (Iterable)tables2;
                boolean $i$f$associateWith = false;
                LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
                Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
                boolean $i$f$associateWithTo = false;
                for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                    void $this$mapNotNullTo$iv$iv;
                    void t;
                    Table table = (Table)element$iv$iv;
                    Object t2 = element$iv$iv;
                    Map map3 = result$iv;
                    boolean bl2 = false;
                    Iterable $this$mapNotNull$iv = t.getColumns();
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        Pair<Table, Boolean> pair;
                        Object element$iv$iv$iv;
                        Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                        boolean bl3 = false;
                        Column c = (Column)element$iv$iv2;
                        boolean bl4 = false;
                        if (c.getReferee() != null) {
                            Column<?> it;
                            boolean bl5 = false;
                            pair = TuplesKt.to(it.getTable(), c.getColumnType().getNullable());
                        } else {
                            pair = null;
                        }
                        if (pair == null) continue;
                        Pair<Table, Boolean> it$iv$iv = pair;
                        boolean bl6 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    Map map4 = MapsKt.toMap((List)destination$iv$iv);
                    map3.put(t2, map4);
                }
                map2 = result$iv;
            }
            tableDepthGraph.graph = map2;
        }

        @NotNull
        public final Iterable<Table> getTables() {
            return this.tables;
        }

        @NotNull
        public final Map<Table, Map<Table, Boolean>> getGraph() {
            return this.graph;
        }

        private final HashSet<Table> fetchAllTables() {
            HashSet<Table> result2 = new HashSet<Table>();
            Iterable<Table> $this$forEach$iv = this.tables;
            boolean $i$f$forEach = false;
            Iterator<Table> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Table element$iv;
                Table p0 = element$iv = iterator2.next();
                boolean bl = false;
                TableDepthGraph.fetchAllTables$parseTable(result2, p0);
            }
            return result2;
        }

        @NotNull
        public final List<Table> sorted() {
            if (!this.tables.iterator().hasNext()) {
                return CollectionsKt.emptyList();
            }
            Set visited = new LinkedHashSet();
            ArrayList<Table> result2 = new ArrayList<Table>();
            Iterable<Table> $this$forEach$iv = this.tables;
            boolean $i$f$forEach = false;
            Iterator<Table> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Table element$iv;
                Table p0 = element$iv = iterator2.next();
                boolean bl = false;
                TableDepthGraph.sorted$traverse(visited, this, result2, p0);
            }
            return result2;
        }

        public final boolean hasCycle() {
            boolean bl;
            block4: {
                if (!this.tables.iterator().hasNext()) {
                    return false;
                }
                Set visited = new LinkedHashSet();
                Set recursion = new LinkedHashSet();
                List<Table> sortedTables = this.sorted();
                Iterable $this$any$iv = sortedTables;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Table it = (Table)element$iv;
                        boolean bl2 = false;
                        if (!TableDepthGraph.hasCycle$traverse-9(recursion, visited, this, it)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private static final void fetchAllTables$parseTable(HashSet<Table> result2, Table table) {
            if (result2.add(table)) {
                Iterable $this$forEach$iv = table.getColumns();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Column it = (Column)element$iv;
                    boolean bl = false;
                    Column<?> column = it.getReferee();
                    if (column != null && (column = column.getTable()) != null) {
                        Column<?> p0 = column;
                        boolean bl2 = false;
                        TableDepthGraph.fetchAllTables$parseTable(result2, p0);
                    }
                }
            }
        }

        private static final void sorted$traverse(Set<Table> visited, TableDepthGraph this$0, ArrayList<Table> result2, Table table) {
            if (!visited.contains(table)) {
                ((Collection)visited).add(table);
                Map<Table, Boolean> $this$forEach$iv = MapsKt.getValue(this$0.graph, table);
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<Table, Boolean>> iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<Table, Boolean> element$iv;
                    Map.Entry<Table, Boolean> entry = element$iv = iterator2.next();
                    boolean bl = false;
                    Table t = entry.getKey();
                    if (visited.contains(t)) continue;
                    TableDepthGraph.sorted$traverse(visited, this$0, result2, t);
                }
                ((Collection)result2).add(table);
            }
        }

        private static final boolean hasCycle$traverse-9(Set<Table> recursion, Set<Table> visited, TableDepthGraph this$0, Table table) {
            boolean bl;
            boolean bl2;
            block7: {
                if (recursion.contains(table)) {
                    return true;
                }
                if (visited.contains(table)) {
                    return false;
                }
                ((Collection)recursion).add(table);
                ((Collection)visited).add(table);
                Map<Table, Boolean> map2 = this$0.graph.get(table);
                Intrinsics.checkNotNull(map2);
                Map<Table, Boolean> $this$any$iv = map2;
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl2 = false;
                } else {
                    Iterator<Map.Entry<Table, Boolean>> iterator2 = $this$any$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<Table, Boolean> element$iv;
                        Map.Entry<Table, Boolean> it = element$iv = iterator2.next();
                        boolean bl3 = false;
                        if (!TableDepthGraph.hasCycle$traverse-9(recursion, visited, this$0, it.getKey())) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                bl = true;
            } else {
                ((Collection)recursion).remove(table);
                bl = false;
            }
            return bl;
        }
    }
}

