/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.exceptions.ExposedSQLException;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.GlobalStatementInterceptor;
import org.jetbrains.exposed.sql.statements.StatementContext;
import org.jetbrains.exposed.sql.statements.StatementInterceptor;
import org.jetbrains.exposed.sql.statements.StatementType;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\"\u0010\u0010\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00120\u00110\u0011H&J\u0015\u0010\u0014\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J)\u0010\u0018\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00060\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H&J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J\u001b\u0010 \u001a\u0004\u0018\u00018\u0000*\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0016H&\u00a2\u0006\u0002\u0010!R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lorg/jetbrains/exposed/sql/statements/Statement;", "T", "", "type", "Lorg/jetbrains/exposed/sql/statements/StatementType;", "targets", "", "Lorg/jetbrains/exposed/sql/Table;", "(Lorg/jetbrains/exposed/sql/statements/StatementType;Ljava/util/List;)V", "isAlwaysBatch", "", "()Z", "getTargets", "()Ljava/util/List;", "getType", "()Lorg/jetbrains/exposed/sql/statements/StatementType;", "arguments", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/IColumnType;", "execute", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "(Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/Object;", "executeIn", "Lorg/jetbrains/exposed/sql/statements/StatementContext;", "executeIn$exposed_core", "prepareSQL", "", "prepared", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "sql", "executeInternal", "(Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/Object;", "exposed-core"})
public abstract class Statement<T> {
    @NotNull
    private final StatementType type;
    @NotNull
    private final List<Table> targets;
    private final boolean isAlwaysBatch;

    public Statement(@NotNull StatementType type2, @NotNull List<? extends Table> targets) {
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Intrinsics.checkNotNullParameter(targets, "targets");
        this.type = type2;
        this.targets = targets;
    }

    @NotNull
    public final StatementType getType() {
        return this.type;
    }

    @NotNull
    public final List<Table> getTargets() {
        return this.targets;
    }

    @Nullable
    public abstract T executeInternal(@NotNull PreparedStatementApi var1, @NotNull Transaction var2);

    @NotNull
    public abstract String prepareSQL(@NotNull Transaction var1);

    @NotNull
    public abstract Iterable<Iterable<Pair<IColumnType, Object>>> arguments();

    @NotNull
    public PreparedStatementApi prepared(@NotNull Transaction transaction2, @NotNull String sql2) {
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        Intrinsics.checkNotNullParameter(sql2, "sql");
        return transaction2.getConnection().prepareStatement(sql2, false);
    }

    public boolean isAlwaysBatch() {
        return this.isAlwaysBatch;
    }

    @Nullable
    public final T execute(@NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        return transaction2.exec(this);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<T, List<StatementContext>> executeIn$exposed_core(@NotNull Transaction transaction2) {
        T $i$f$forEachIndexed2;
        PreparedStatementApi $this$forEach$iv;
        List<StatementContext> list;
        StatementContext args2;
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        Iterable<Iterable<Pair<IColumnType, Object>>> arguments2 = this.arguments();
        if (CollectionsKt.count(arguments2) > 0) {
            void $this$mapTo$iv$iv;
            Iterable<Iterable<Pair<IColumnType, Object>>> $this$map$iv = arguments2;
            boolean $i$f$map = false;
            Iterable<Iterable<Pair<IColumnType, Object>>> iterable = $this$map$iv;
            Iterator destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                StatementInterceptor it;
                Iterable iterable2 = (Iterable)item$iv$iv;
                Iterator iterator2 = destination$iv$iv;
                boolean bl = false;
                StatementContext context = new StatementContext(this, (Iterable<? extends Pair<? extends IColumnType, ? extends Object>>)((Object)args2));
                Iterable $this$forEach$iv2 = Transaction.Companion.getGlobalInterceptors$exposed_core();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it = (GlobalStatementInterceptor)element$iv;
                    boolean bl2 = false;
                    it.beforeExecution(transaction2, context);
                }
                $this$forEach$iv2 = transaction2.getInterceptors$exposed_core();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it = (StatementInterceptor)element$iv;
                    boolean bl3 = false;
                    it.beforeExecution(transaction2, context);
                }
                iterator2.add((StatementContext)context);
            }
            list = (List<StatementContext>)((Object)destination$iv$iv);
        } else {
            StatementInterceptor it;
            StatementContext context = new StatementContext(this, CollectionsKt.emptyList());
            Iterable $this$forEach$iv3 = Transaction.Companion.getGlobalInterceptors$exposed_core();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv3) {
                it = (GlobalStatementInterceptor)element$iv;
                boolean bl = false;
                it.beforeExecution(transaction2, context);
            }
            $this$forEach$iv3 = transaction2.getInterceptors$exposed_core();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv3) {
                it = (StatementInterceptor)element$iv;
                boolean bl = false;
                it.beforeExecution(transaction2, context);
            }
            list = CollectionsKt.listOf(context);
        }
        List<StatementContext> contexts = list;
        try {
            $this$forEach$iv = this.prepared(transaction2, this.prepareSQL(transaction2));
        }
        catch (SQLException e) {
            throw new ExposedSQLException(e, contexts, transaction2);
        }
        PreparedStatementApi statement2 = $this$forEach$iv;
        Iterable $this$forEachIndexed$iv = contexts;
        boolean $i$f$forEachIndexed2 = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void context;
            int bl;
            if ((bl = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            args2 = (StatementContext)item$iv;
            int i = bl;
            boolean bl4 = false;
            statement2.fillParameters(context.getArgs());
            if (contexts.size() <= 1 && !this.isAlwaysBatch()) continue;
            statement2.addBatch();
        }
        if (!transaction2.getDb().getSupportsMultipleResultSets()) {
            transaction2.closeExecutedStatements();
        }
        transaction2.setCurrentStatement(statement2);
        try {
            $i$f$forEachIndexed2 = this.executeInternal(statement2, transaction2);
        }
        catch (SQLException e) {
            throw new ExposedSQLException(e, contexts, transaction2);
        }
        T result2 = $i$f$forEachIndexed2;
        transaction2.setCurrentStatement(null);
        transaction2.getExecutedStatements$exposed_core().add(statement2);
        Iterable $this$forEach$iv4 = Transaction.Companion.getGlobalInterceptors$exposed_core();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv4) {
            GlobalStatementInterceptor it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            it.afterExecution(transaction2, contexts, statement2);
        }
        $this$forEach$iv4 = transaction2.getInterceptors$exposed_core();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv4) {
            StatementInterceptor it = (StatementInterceptor)element$iv;
            boolean bl = false;
            it.afterExecution(transaction2, contexts, statement2);
        }
        return TuplesKt.to(result2, contexts);
    }
}

