/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.LiteralOp;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaKt;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.vendors.ColumnMetadata;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000f0+H&J\u0010\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u000201H\u0016JW\u00102\u001a8\u0012(\u0012&\u0012\u0004\u0012\u000201\u0012\u001c\u0012\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030605j\f\u0012\b\u0012\u0006\u0012\u0002\b\u000306`704\u0012\n\u0012\b\u0012\u0004\u0012\u0002080+032\u0012\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u0002010:\"\u000201H\u0016\u00a2\u0006\u0002\u0010;J\u0010\u0010<\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010=\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020?H&J\u0010\u0010@\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010D\u001a\u00020\u000f2\u0006\u0010E\u001a\u00020\u000f2\u0006\u0010F\u001a\u00020\u000fH&J\u0018\u0010G\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020B2\u0006\u0010H\u001a\u00020\u0013H\u0016J3\u0010I\u001a\u0014\u0012\u0004\u0012\u000201\u0012\n\u0012\b\u0012\u0004\u0012\u00020?0+032\u0012\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u0002010:\"\u000201H\u0016\u00a2\u0006\u0002\u0010;J\b\u0010J\u001a\u00020\u000fH&J\u0014\u0010K\u001a\u00020\u00132\n\u0010L\u001a\u0006\u0012\u0002\b\u00030MH\u0016J\"\u0010N\u001a\b\u0012\u0004\u0012\u00020\u000f0+2\n\u0010O\u001a\u0006\u0012\u0002\b\u0003062\u0006\u0010P\u001a\u00020QH&J\b\u0010R\u001a\u00020SH&J\b\u0010T\u001a\u00020SH&J\u0010\u0010U\u001a\u00020\u00132\u0006\u0010A\u001a\u00020BH&J\u0010\u0010V\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020BH\u0016J\b\u0010W\u001a\u00020\u0013H&J3\u0010X\u001a\u0014\u0012\u0004\u0012\u000201\u0012\n\u0012\b\u0012\u0004\u0012\u00020Y0+032\u0012\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u0002010:\"\u000201H\u0016\u00a2\u0006\u0002\u0010;J\u0010\u0010Z\u001a\u00020\u00132\u0006\u00100\u001a\u000201H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015R\u0014\u0010\u001a\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015R\u0014\u0010\u001c\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0015R\u0014\u0010\u001e\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0015R\u0012\u0010 \u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0015R\u0014\u0010\"\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0015R\u0014\u0010$\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0015R\u0014\u0010&\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0015R\u0014\u0010(\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0015\u00a8\u0006["}, d2={"Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;", "", "dataTypeProvider", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "getDataTypeProvider", "()Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "defaultReferenceOption", "Lorg/jetbrains/exposed/sql/ReferenceOption;", "getDefaultReferenceOption", "()Lorg/jetbrains/exposed/sql/ReferenceOption;", "functionProvider", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "getFunctionProvider", "()Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "name", "", "getName", "()Ljava/lang/String;", "needsQuotesWhenSymbolsInNames", "", "getNeedsQuotesWhenSymbolsInNames", "()Z", "needsSequenceToAutoInc", "getNeedsSequenceToAutoInc", "supportsCreateSchema", "getSupportsCreateSchema", "supportsCreateSequence", "getSupportsCreateSequence", "supportsDualTableConcept", "getSupportsDualTableConcept", "supportsIfNotExists", "getSupportsIfNotExists", "supportsMultipleGeneratedKeys", "getSupportsMultipleGeneratedKeys", "supportsOnlyIdentifiersInGeneratedKeys", "getSupportsOnlyIdentifiersInGeneratedKeys", "supportsOrderByNullsFirstLast", "getSupportsOrderByNullsFirstLast", "supportsSequenceAsGeneratedKeys", "getSupportsSequenceAsGeneratedKeys", "supportsSubqueryUnions", "getSupportsSubqueryUnions", "allTablesNames", "", "catalog", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "checkTableMapping", "table", "Lorg/jetbrains/exposed/sql/Table;", "columnConstraints", "", "Lkotlin/Pair;", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/exposed/sql/Column;", "Lkotlin/collections/LinkedHashSet;", "Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "tables", "", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/Map;", "createDatabase", "createIndex", "index", "Lorg/jetbrains/exposed/sql/Index;", "createSchema", "schema", "Lorg/jetbrains/exposed/sql/Schema;", "dropDatabase", "dropIndex", "tableName", "indexName", "dropSchema", "cascade", "existingIndices", "getDatabase", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "modifyColumn", "column", "columnDiff", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "resetCaches", "", "resetSchemaCaches", "schemaExists", "setSchema", "supportsSelectForUpdate", "tableColumns", "Lorg/jetbrains/exposed/sql/vendors/ColumnMetadata;", "tableExists", "exposed-core"})
public interface DatabaseDialect {
    @NotNull
    public String getName();

    @NotNull
    public DataTypeProvider getDataTypeProvider();

    @NotNull
    public FunctionProvider getFunctionProvider();

    public boolean getSupportsIfNotExists();

    public boolean getSupportsCreateSequence();

    public boolean getNeedsSequenceToAutoInc();

    @NotNull
    public ReferenceOption getDefaultReferenceOption();

    public boolean getNeedsQuotesWhenSymbolsInNames();

    public boolean getSupportsMultipleGeneratedKeys();

    public boolean getSupportsSequenceAsGeneratedKeys();

    public boolean getSupportsOnlyIdentifiersInGeneratedKeys();

    public boolean getSupportsCreateSchema();

    public boolean getSupportsSubqueryUnions();

    public boolean getSupportsDualTableConcept();

    public boolean getSupportsOrderByNullsFirstLast();

    @NotNull
    public String getDatabase();

    @NotNull
    public List<String> allTablesNames();

    public boolean tableExists(@NotNull Table var1);

    public boolean schemaExists(@NotNull Schema var1);

    public boolean checkTableMapping(@NotNull Table var1);

    @NotNull
    public Map<Table, List<ColumnMetadata>> tableColumns(Table ... var1);

    @NotNull
    public Map<Pair<Table, LinkedHashSet<Column<?>>>, List<ForeignKeyConstraint>> columnConstraints(Table ... var1);

    @NotNull
    public Map<Table, List<Index>> existingIndices(Table ... var1);

    public boolean supportsSelectForUpdate();

    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> var1);

    @NotNull
    public String catalog(@NotNull Transaction var1);

    public void resetCaches();

    public void resetSchemaCaches();

    @NotNull
    public String createIndex(@NotNull Index var1);

    @NotNull
    public String dropIndex(@NotNull String var1, @NotNull String var2);

    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> var1, @NotNull ColumnDiff var2);

    @NotNull
    public String createDatabase(@NotNull String var1);

    @NotNull
    public String dropDatabase(@NotNull String var1);

    @NotNull
    public String setSchema(@NotNull Schema var1);

    @NotNull
    public String createSchema(@NotNull Schema var1);

    @NotNull
    public String dropSchema(@NotNull Schema var1, boolean var2);

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static boolean getSupportsIfNotExists(@NotNull DatabaseDialect this_) {
            return true;
        }

        public static boolean getSupportsCreateSequence(@NotNull DatabaseDialect this_) {
            return true;
        }

        public static boolean getNeedsSequenceToAutoInc(@NotNull DatabaseDialect this_) {
            return false;
        }

        @NotNull
        public static ReferenceOption getDefaultReferenceOption(@NotNull DatabaseDialect this_) {
            return ReferenceOption.RESTRICT;
        }

        public static boolean getNeedsQuotesWhenSymbolsInNames(@NotNull DatabaseDialect this_) {
            return true;
        }

        public static boolean getSupportsSequenceAsGeneratedKeys(@NotNull DatabaseDialect this_) {
            return this_.getSupportsCreateSequence();
        }

        public static boolean getSupportsOnlyIdentifiersInGeneratedKeys(@NotNull DatabaseDialect this_) {
            return false;
        }

        public static boolean getSupportsCreateSchema(@NotNull DatabaseDialect this_) {
            return true;
        }

        public static boolean getSupportsSubqueryUnions(@NotNull DatabaseDialect this_) {
            return false;
        }

        public static boolean getSupportsDualTableConcept(@NotNull DatabaseDialect this_) {
            return false;
        }

        public static boolean getSupportsOrderByNullsFirstLast(@NotNull DatabaseDialect this_) {
            return false;
        }

        public static boolean checkTableMapping(@NotNull DatabaseDialect this_, @NotNull Table table) {
            Intrinsics.checkNotNullParameter(table, "table");
            return true;
        }

        @NotNull
        public static Map<Table, List<ColumnMetadata>> tableColumns(@NotNull DatabaseDialect this_, Table ... tables) {
            Intrinsics.checkNotNullParameter(tables, "tables");
            return MapsKt.emptyMap();
        }

        @NotNull
        public static Map<Pair<Table, LinkedHashSet<Column<?>>>, List<ForeignKeyConstraint>> columnConstraints(@NotNull DatabaseDialect this_, Table ... tables) {
            Intrinsics.checkNotNullParameter(tables, "tables");
            return MapsKt.emptyMap();
        }

        @NotNull
        public static Map<Table, List<Index>> existingIndices(@NotNull DatabaseDialect this_, Table ... tables) {
            Intrinsics.checkNotNullParameter(tables, "tables");
            return MapsKt.emptyMap();
        }

        public static boolean isAllowedAsColumnDefault(@NotNull DatabaseDialect this_, @NotNull Expression<?> e) {
            Intrinsics.checkNotNullParameter(e, "e");
            return e instanceof LiteralOp;
        }

        @NotNull
        public static String catalog(@NotNull DatabaseDialect this_, @NotNull Transaction transaction2) {
            Intrinsics.checkNotNullParameter(transaction2, "transaction");
            return transaction2.getConnection().getCatalog();
        }

        @NotNull
        public static String createDatabase(@NotNull DatabaseDialect this_, @NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return "CREATE DATABASE IF NOT EXISTS " + DefaultKt.inProperCase(name);
        }

        @NotNull
        public static String dropDatabase(@NotNull DatabaseDialect this_, @NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return "DROP DATABASE IF EXISTS " + DefaultKt.inProperCase(name);
        }

        @NotNull
        public static String setSchema(@NotNull DatabaseDialect this_, @NotNull Schema schema2) {
            Intrinsics.checkNotNullParameter(schema2, "schema");
            return "SET SCHEMA " + schema2.getIdentifier();
        }

        @NotNull
        public static String createSchema(@NotNull DatabaseDialect this_, @NotNull Schema schema2) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter(schema2, "schema");
            StringBuilder $this$createSchema_u24lambda_u2d0 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$createSchema_u24lambda_u2d0.append("CREATE SCHEMA IF NOT EXISTS ");
            $this$createSchema_u24lambda_u2d0.append(schema2.getIdentifier());
            SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u2d0, " AUTHORIZATION ", schema2.getAuthorization());
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
            return string;
        }

        @NotNull
        public static String dropSchema(@NotNull DatabaseDialect this_, @NotNull Schema schema2, boolean cascade) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter(schema2, "schema");
            StringBuilder $this$dropSchema_u24lambda_u2d1 = stringBuilder = new StringBuilder();
            boolean bl = false;
            String[] stringArray = new String[]{"DROP SCHEMA IF EXISTS ", schema2.getIdentifier()};
            StringsKt.append($this$dropSchema_u24lambda_u2d1, stringArray);
            if (cascade) {
                $this$dropSchema_u24lambda_u2d1.append(" CASCADE");
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
            return string;
        }
    }
}

