/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.TextColumnType;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.H2DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2FunctionProvider;
import org.jetbrains.exposed.sql.vendors.H2Kt;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 12\u00020\u0001:\u000212B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0002J3\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020$\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0%0#2\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0'\"\u00020$H\u0016\u00a2\u0006\u0002\u0010(J\u0014\u0010)\u001a\u00020\u00042\n\u0010*\u001a\u0006\u0012\u0002\b\u00030+H\u0016J\"\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00100%2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.2\u0006\u0010/\u001a\u000200H\u0016R\u001b\u0010\u0003\u001a\u00020\u00048@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006R\u001b\u0010\n\u001a\u00020\u000b8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\b\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0006R\u001b\u0010\u0017\u001a\u00020\u00108@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\b\u001a\u0004\b\u0018\u0010\u0012\u00a8\u00063"}, d2={"Lorg/jetbrains/exposed/sql/vendors/H2Dialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "()V", "isMySQLMode", "", "isMySQLMode$exposed_core", "()Z", "isMySQLMode$delegate", "Lkotlin/Lazy;", "isSecondVersion", "majorVersion", "Lorg/jetbrains/exposed/sql/vendors/H2Dialect$H2MajorVersion;", "getMajorVersion$exposed_core", "()Lorg/jetbrains/exposed/sql/vendors/H2Dialect$H2MajorVersion;", "majorVersion$delegate", "name", "", "getName", "()Ljava/lang/String;", "supportsMultipleGeneratedKeys", "getSupportsMultipleGeneratedKeys", "supportsOnlyIdentifiersInGeneratedKeys", "getSupportsOnlyIdentifiersInGeneratedKeys", "version", "getVersion$exposed_core", "version$delegate", "createDatabase", "createIndex", "index", "Lorg/jetbrains/exposed/sql/Index;", "dropDatabase", "exactH2Version", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "existingIndices", "", "Lorg/jetbrains/exposed/sql/Table;", "", "tables", "", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/Map;", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "modifyColumn", "column", "Lorg/jetbrains/exposed/sql/Column;", "columnDiff", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "Companion", "H2MajorVersion", "exposed-core"})
public class H2Dialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy version$delegate = LazyKt.lazy((Function0)new Function0<String>(this){
        final /* synthetic */ H2Dialect this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final String invoke() {
            return H2Dialect.access$exactH2Version(this.this$0, TransactionManager.Companion.current());
        }
    });
    @NotNull
    private final Lazy majorVersion$delegate = LazyKt.lazy((Function0)new Function0<H2MajorVersion>(this){
        final /* synthetic */ H2Dialect this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final H2MajorVersion invoke() {
            H2MajorVersion h2MajorVersion;
            if (StringsKt.startsWith$default(this.this$0.getVersion$exposed_core(), "1.", false, 2, null)) {
                h2MajorVersion = H2MajorVersion.One;
            } else if (StringsKt.startsWith$default(this.this$0.getVersion$exposed_core(), "2.", false, 2, null)) {
                h2MajorVersion = H2MajorVersion.Two;
            } else {
                throw new IllegalStateException(("Unsupported H2 version: " + this.this$0.getVersion$exposed_core()).toString());
            }
            return h2MajorVersion;
        }
    });
    @NotNull
    private final Lazy isMySQLMode$delegate = LazyKt.lazy((Function0)new Function0<Boolean>(this){
        final /* synthetic */ H2Dialect this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final Boolean invoke() {
            Pair<String, String> pair;
            switch (isMySQLMode.WhenMappings.$EnumSwitchMapping$0[this.this$0.getMajorVersion$exposed_core().ordinal()]) {
                case 1: {
                    pair = TuplesKt.to("NAME", "VALUE");
                    break;
                }
                case 2: {
                    pair = TuplesKt.to("SETTING_NAME", "SETTING_VALUE");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Pair<String, String> pair2 = pair;
            String settingNameField = pair2.component1();
            String settingValueField = pair2.component2();
            String mySQLModeQuery = "SELECT " + settingValueField + " FROM INFORMATION_SCHEMA.SETTINGS WHERE " + settingNameField + " = 'MODE'";
            String mySQLMode2 = (String)Transaction.exec$default(TransactionManager.Companion.current(), mySQLModeQuery, null, null, new Function1<ResultSet, String>(settingValueField){
                final /* synthetic */ String $settingValueField;
                {
                    this.$settingValueField = $settingValueField;
                    super(1);
                }

                public final String invoke(@NotNull ResultSet rs) {
                    Intrinsics.checkNotNullParameter(rs, "rs");
                    rs.next();
                    return rs.getString(this.$settingValueField);
                }
            }, 6, null);
            return StringsKt.equals(mySQLMode2, "MySQL", true);
        }
    });
    private final boolean supportsMultipleGeneratedKeys;
    @NotNull
    public static final String dialectName = "h2";

    public H2Dialect() {
        super(dialectName, H2DataTypeProvider.INSTANCE, H2FunctionProvider.INSTANCE);
    }

    @NotNull
    public final String getVersion$exposed_core() {
        Lazy lazy = this.version$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final H2MajorVersion getMajorVersion$exposed_core() {
        Lazy lazy = this.majorVersion$delegate;
        return (H2MajorVersion)((Object)lazy.getValue());
    }

    public final boolean isSecondVersion() {
        return this.getMajorVersion$exposed_core() == H2MajorVersion.Two;
    }

    private final String exactH2Version(Transaction transaction2) {
        return (String)transaction2.getDb().metadata$exposed_core(exactH2Version.1.INSTANCE);
    }

    public final boolean isMySQLMode$exposed_core() {
        Lazy lazy = this.isMySQLMode$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    @NotNull
    public String getName() {
        Transaction transaction2 = TransactionManager.Companion.currentOrNull();
        return Intrinsics.areEqual(transaction2 != null ? Boolean.valueOf(H2Kt.access$isMySQLMode(transaction2)) : null, true) ? "h2 (Mysql Mode)" : dialectName;
    }

    @Override
    public boolean getSupportsMultipleGeneratedKeys() {
        return this.supportsMultipleGeneratedKeys;
    }

    @Override
    public boolean getSupportsOnlyIdentifiersInGeneratedKeys() {
        return !H2Kt.access$isMySQLMode(TransactionManager.Companion.current());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Table, List<Index>> existingIndices(Table ... tables) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(tables, "tables");
        Map<Table, List<Index>> $this$mapValues$iv = super.existingIndices(Arrays.copyOf(tables, tables.length));
        boolean $i$f$mapValues = false;
        Map<Table, List<Index>> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$filterNotTo$iv$iv;
            void entry;
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            Iterable $this$filterNot$iv = (Iterable)entry.getValue();
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Index it = (Index)element$iv$iv;
                boolean bl3 = false;
                if (StringsKt.startsWith$default(it.getIndexName(), "PRIMARY_KEY_", false, 2, null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv2;
            map4.put(k, list);
        }
        Map $this$filterValues$iv = destination$iv$iv;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            List it = (List)entry$iv.getValue();
            boolean bl = false;
            boolean bl4 = !((Collection)it).isEmpty();
            if (!bl4) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, "e");
        return true;
    }

    @Override
    @NotNull
    public String createIndex(@NotNull Index index) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(index, "index");
            Iterable $this$any$iv = index.getColumns();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Column it = (Column)element$iv;
                    boolean bl2 = false;
                    if (!(it.getColumnType() instanceof TextColumnType)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            SQLLogKt.getExposedLogger().warn("Index on " + index.getTable().getTableName() + " for " + CollectionsKt.joinToString$default(index.getColumns(), null, null, null, 0, null, createIndex.2.INSTANCE, 31, null) + " can't be created in H2");
            return "";
        }
        if (index.getIndexType() != null) {
            SQLLogKt.getExposedLogger().warn("Index of type " + index.getIndexType() + " on " + index.getTable().getTableName() + " for " + CollectionsKt.joinToString$default(index.getColumns(), null, null, null, 0, null, createIndex.3.INSTANCE, 31, null) + " can't be created in H2");
            return "";
        }
        return super.createIndex(index);
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return "CREATE SCHEMA IF NOT EXISTS " + DefaultKt.inProperCase(name);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> column, @NotNull ColumnDiff columnDiff) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(column, "column");
        Intrinsics.checkNotNullParameter(columnDiff, "columnDiff");
        Iterable $this$map$iv = super.modifyColumn(column, columnDiff);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.replace$default((String)it, "MODIFY COLUMN", "ALTER COLUMN", false, 4, null));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return "DROP SCHEMA IF EXISTS " + DefaultKt.inProperCase(name);
    }

    public static final /* synthetic */ String access$exactH2Version(H2Dialect $this, Transaction transaction2) {
        return $this.exactH2Version(transaction2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/exposed/sql/vendors/H2Dialect$H2MajorVersion;", "", "(Ljava/lang/String;I)V", "One", "Two", "exposed-core"})
    public static final class H2MajorVersion
    extends Enum<H2MajorVersion> {
        public static final /* enum */ H2MajorVersion One = new H2MajorVersion();
        public static final /* enum */ H2MajorVersion Two = new H2MajorVersion();
        private static final /* synthetic */ H2MajorVersion[] $VALUES;

        public static H2MajorVersion[] values() {
            return (H2MajorVersion[])$VALUES.clone();
        }

        public static H2MajorVersion valueOf(String value) {
            return Enum.valueOf(H2MajorVersion.class, value);
        }

        static {
            $VALUES = h2MajorVersionArray = new H2MajorVersion[]{H2MajorVersion.One, H2MajorVersion.Two};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/exposed/sql/vendors/H2Dialect$Companion;", "", "()V", "dialectName", "", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

