/*
 * Decompiled with CFR 0.152.
 */
package org.json.simple;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JSONValue {
    public static Object parse(Reader in) {
        try {
            JSONParser parser = new JSONParser();
            return parser.parse(in);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parse(String s2) {
        StringReader in = new StringReader(s2);
        return JSONValue.parse(in);
    }

    public static Object parseWithException(Reader in) throws IOException, ParseException {
        JSONParser parser = new JSONParser();
        return parser.parse(in);
    }

    public static Object parseWithException(String s2) throws ParseException {
        JSONParser parser = new JSONParser();
        return parser.parse(s2);
    }

    public static void writeJSONString(Object value, Writer out2) throws IOException {
        if (value == null) {
            out2.write("null");
            return;
        }
        if (value instanceof String) {
            out2.write(34);
            out2.write(JSONValue.escape((String)value));
            out2.write(34);
            return;
        }
        if (value instanceof Double) {
            if (((Double)value).isInfinite() || ((Double)value).isNaN()) {
                out2.write("null");
            } else {
                out2.write(value.toString());
            }
            return;
        }
        if (value instanceof Float) {
            if (((Float)value).isInfinite() || ((Float)value).isNaN()) {
                out2.write("null");
            } else {
                out2.write(value.toString());
            }
            return;
        }
        if (value instanceof Number) {
            out2.write(value.toString());
            return;
        }
        if (value instanceof Boolean) {
            out2.write(value.toString());
            return;
        }
        if (value instanceof JSONStreamAware) {
            ((JSONStreamAware)value).writeJSONString(out2);
            return;
        }
        if (value instanceof JSONAware) {
            out2.write(((JSONAware)value).toJSONString());
            return;
        }
        if (value instanceof Map) {
            JSONObject.writeJSONString((Map)value, out2);
            return;
        }
        if (value instanceof List) {
            JSONArray.writeJSONString((List)value, out2);
            return;
        }
        out2.write(value.toString());
    }

    public static String toJSONString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + JSONValue.escape((String)value) + "\"";
        }
        if (value instanceof Double) {
            if (((Double)value).isInfinite() || ((Double)value).isNaN()) {
                return "null";
            }
            return value.toString();
        }
        if (value instanceof Float) {
            if (((Float)value).isInfinite() || ((Float)value).isNaN()) {
                return "null";
            }
            return value.toString();
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JSONAware) {
            return ((JSONAware)value).toJSONString();
        }
        if (value instanceof Map) {
            return JSONObject.toJSONString((Map)value);
        }
        if (value instanceof List) {
            return JSONArray.toJSONString((List)value);
        }
        return value.toString();
    }

    public static String escape(String s2) {
        if (s2 == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        JSONValue.escape(s2, sb);
        return sb.toString();
    }

    static void escape(String s2, StringBuffer sb) {
        block10: for (int i = 0; i < s2.length(); ++i) {
            char ch2 = s2.charAt(i);
            switch (ch2) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch2 >= '\u0000' && ch2 <= '\u001f' || ch2 >= '\u007f' && ch2 <= '\u009f' || ch2 >= '\u2000' && ch2 <= '\u20ff') {
                        String ss = Integer.toHexString(ch2);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block10;
                    }
                    sb.append(ch2);
                }
            }
        }
    }
}

